/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.ce.impl;

import io.smallrye.reactive.messaging.ce.CloudEventMetadata;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BaseCloudEventMetadata<T>
implements CloudEventMetadata<T> {
    protected final String id;
    protected final String specVersion;
    protected final URI source;
    protected final String type;
    protected final String dataContentType;
    protected final URI dataSchema;
    protected final String subject;
    protected final ZonedDateTime timestamp;
    protected final Map<String, Object> extensions;
    protected final T data;

    public BaseCloudEventMetadata(String specVersion, String id, URI source, String type, String dataContentType, URI dataSchema, String subject, ZonedDateTime timestamp, Map<String, Object> extensions, T data) {
        this.id = id;
        this.specVersion = specVersion;
        this.source = source;
        this.type = type;
        this.dataContentType = dataContentType;
        this.dataSchema = dataSchema;
        this.subject = subject;
        this.timestamp = timestamp;
        this.extensions = extensions == null ? Collections.emptyMap() : extensions;
        this.data = data;
    }

    public void validate() {
        Objects.requireNonNull(this.id, "id must not be `null`");
        Objects.requireNonNull(this.specVersion, "specVersion must not be `null`");
        Objects.requireNonNull(this.source, "source must not be `null`");
        Objects.requireNonNull(this.type, "type must not be `null`");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Optional<String> getDataContentType() {
        return Optional.ofNullable(this.dataContentType);
    }

    @Override
    public Optional<URI> getDataSchema() {
        return Optional.ofNullable(this.dataSchema);
    }

    @Override
    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    @Override
    public Optional<ZonedDateTime> getTimeStamp() {
        return Optional.ofNullable(this.timestamp);
    }

    @Override
    public <A> Optional<A> getExtension(String name) {
        Objects.requireNonNull(name, "The attribute name cannot be `null`");
        switch (name) {
            case "specversion": {
                return Optional.of(this.specVersion);
            }
            case "id": {
                return Optional.of(this.id);
            }
            case "source": {
                return Optional.of(this.source);
            }
            case "type": {
                return Optional.of(this.type);
            }
            case "datacontenttype": {
                return this.getDataContentType();
            }
            case "dataschema": {
                return this.getDataSchema();
            }
            case "subject": {
                return this.getSubject();
            }
            case "time": {
                return this.getTimeStamp();
            }
        }
        return Optional.ofNullable(this.extensions.get(name));
    }

    @Override
    public Map<String, Object> getExtensions() {
        if (this.extensions.isEmpty()) {
            return Collections.emptyMap();
        }
        return new HashMap<String, Object>(this.extensions);
    }

    @Override
    public T getData() {
        return this.data;
    }
}

