/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.listener.impl;

import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.jms.internal.BatchOperationGroup;
import com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl;
import com.ibm.ws.jca.service.AdminObjectService;
import com.ibm.ws.jca.service.EndpointActivationService;
import com.ibm.ws.kernel.feature.ServerStartedPhase2;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.rrs.RRSXAResourceFactory;
import com.ibm.wsspi.application.lifecycle.ApplicationStartBarrier;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import jakarta.jms.ConnectionFactory;
import jakarta.resource.ResourceException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Optional;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.jbatch.jms.executor"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"JMSConnectionFactory.cardinality.minimum=2147483647", "service.vendor=IBM"})
public class BatchJmsExecutor {
    private static final TraceComponent tc = Tr.register(BatchJmsExecutor.class, (String)"wsbatch", (String)"com.ibm.ws.jbatch.jms.internal.resources.BatchJmsMessages");
    public static final String ACTIVATION_SPEC_REF_NAME = "JmsActivationSpec";
    public static final String CONN_FACTORY_REF_NAME = "JMSConnectionFactory";
    public static final String JMS_QUEUE_REF_NAME = "JmsQueue";
    public static final String OPERATION_GROUP = "operationGroup";
    private final ComponentContext context;
    private final ServiceReference<EndpointActivationService> endpointActivationSpecRef;
    private final MessageEndpointFactoryImpl endpointFactory;
    static final long serialVersionUID = 185320295483454584L;

    @Activate
    public BatchJmsExecutor(ComponentContext context, Map<String, Object> config, @Reference ApplicationStartBarrier requiredButNotUsed, @Reference ServerStartedPhase2 requiredButNotUsed2, @Reference J2EENameFactory j2eeNameFactory, @Reference ResourceConfigFactory resourceConfigFactory, @Reference WSJobRepository jobRepository, @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY) RRSXAResourceFactory xaResourceFactory, @Reference(name="JMSConnectionFactory", target="(id=unbound)", cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY) ResourceFactory jmsConnectionFactory, @Reference(name="JmsQueue", target="(id=unbound)") ServiceReference<AdminObjectService> adminObjectServiceRef, @Reference(name="JmsActivationSpec", target="(id=unbound)") ServiceReference<EndpointActivationService> jmsActivationSpecRef) throws ResourceException {
        this(context, config, jmsActivationSpecRef, BatchJmsExecutor.createMef(config, j2eeNameFactory, adminObjectServiceRef, xaResourceFactory, resourceConfigFactory, jmsConnectionFactory, jobRepository));
    }

    /*
     * WARNING - void declaration
     */
    BatchJmsExecutor(ComponentContext context, Map<String, Object> config, ServiceReference<EndpointActivationService> easRef, MessageEndpointFactoryImpl mef) throws ResourceException {
        this.context = context;
        this.endpointActivationSpecRef = easRef;
        this.endpointFactory = mef;
        mef.endpointActivationServiceInfo = new EndpointActivationServiceInfo();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activation spec = " + easRef), (Object[])new Object[0]);
        }
        if (FrameworkState.isStopping()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"BatchJmsExecutor", (Object[])new Object[]{"Framework stopping"});
            return;
        }
        try {
            mef.activateEndpointInternal();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Batch activation spec is " + mef.endpointActivationServiceInfo.id + " activated"), (Object[])new Object[0]);
            }
        }
        catch (ResourceException resourceException) {
            void e;
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor", (String)"141", (Object)this, (Object[])new Object[]{context, config, easRef, mef});
            Tr.error((TraceComponent)tc, (String)"error.batch.executor.activate.failure", (Object[])new Object[]{e});
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static MessageEndpointFactoryImpl createMef(Map<String, Object> config, J2EENameFactory j2eeNameFactory, ServiceReference<AdminObjectService> adminObjectServiceRef, RRSXAResourceFactory xarf, ResourceConfigFactory rcf, ResourceFactory rf, WSJobRepository repo) {
        try {
            J2EEName j2eeName = j2eeNameFactory.create("JBatchListenerApp", "JBatchListenerModule", "JBatchListenerComp");
            ConnectionFactory cf = BatchJmsExecutor.createConnectionFactoryInstance(rcf, rf);
            BatchOperationGroup grp = BatchJmsExecutor.createBatchOperationGroup(config);
            String jndiName = Optional.of(adminObjectServiceRef).filter(ref -> null != ref.getProperty("id")).map(id -> adminObjectServiceRef.getProperty("jndiName")).map(String.class::cast).orElse(null);
            MessageEndpointFactoryImpl mef = new MessageEndpointFactoryImpl(j2eeName, xarf, cf, grp, repo, jndiName);
            return mef;
        }
        catch (RemoteException j2eeName) {
            void e;
            FFDCFilter.processException((Throwable)j2eeName, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor", (String)"175", null, (Object[])new Object[]{config, j2eeNameFactory, adminObjectServiceRef, xarf, rcf, rf, repo});
            Tr.error((TraceComponent)tc, (String)"error.batch.executor.activate.failure", (Object[])new Object[]{e});
            return null;
        }
    }

    private static BatchOperationGroup createBatchOperationGroup(Map<String, Object> config) {
        return Optional.ofNullable(config.get(OPERATION_GROUP)).map(String[].class::cast).map(BatchOperationGroup::new).orElseGet(() -> new BatchOperationGroup(new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Deactivate
    protected void deactivate() {
        block2: {
            try {
                this.endpointFactory.deactivateEndpointInternal();
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor", (String)"206", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Ignoring unexpected exception : " + ex), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ConnectionFactory createConnectionFactoryInstance(ResourceConfigFactory rcf, ResourceFactory rf) {
        if (null == rf) {
            return null;
        }
        try {
            ResourceConfig cfResourceConfig = rcf.createResourceConfig(ConnectionFactory.class.getName());
            cfResourceConfig.setResAuthType(0);
            return (ConnectionFactory)rf.createResource((ResourceInfo)cfResourceConfig);
        }
        catch (Exception cfResourceConfig) {
            void e;
            FFDCFilter.processException((Throwable)cfResourceConfig, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor", (String)"229", null, (Object[])new Object[]{rcf, rf});
            Tr.error((TraceComponent)tc, (String)"error.batch.executor.jms.create.failure", (Object[])new Object[]{e});
            throw new IllegalStateException("Problem creating batch executor reply CF", (Throwable)e);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class EndpointActivationServiceInfo {
        final String id;
        final EndpointActivationService service;
        final int maxEndpoints;
        static final long serialVersionUID = -6384513744491908681L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EndpointActivationServiceInfo() {
            this.id = (String)BatchJmsExecutor.this.endpointActivationSpecRef.getProperty("id");
            this.service = (EndpointActivationService)BatchJmsExecutor.this.context.locateService(BatchJmsExecutor.ACTIVATION_SPEC_REF_NAME, BatchJmsExecutor.this.endpointActivationSpecRef);
            this.maxEndpoints = (Integer)BatchJmsExecutor.this.endpointActivationSpecRef.getProperty("maxEndpoints");
        }

        public String toString() {
            return "EndpointActivationServiceInfo [service=" + this.service + ", id=" + this.id + ", maxEndpoints=" + this.maxEndpoints + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor$EndpointActivationServiceInfo", EndpointActivationServiceInfo.class, (String)"wsbatch", null);
        }
    }
}

