/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.usage;

import graphql.Internal;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.DirectiveInfo;
import graphql.schema.idl.ScalarInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class SchemaUsage {
    private final Map<String, Integer> fieldReferenceCounts;
    private final Map<String, Integer> inputFieldReferenceCounts;
    private final Map<String, Integer> outputFieldReferenceCounts;
    private final Map<String, Integer> argReferenceCount;
    private final Map<String, Integer> interfaceReferenceCount;
    private final Map<String, Integer> unionReferenceCount;
    private final Map<String, Integer> directiveReferenceCount;
    private final Map<String, Set<String>> interfaceImplementors;
    private final Map<String, Set<String>> elementBackReferences;
    private final Map<String, Set<String>> unionReferences;

    private SchemaUsage(Builder builder) {
        this.fieldReferenceCounts = ImmutableMap.copyOf(builder.fieldReferenceCounts);
        this.inputFieldReferenceCounts = ImmutableMap.copyOf(builder.inputFieldReferenceCounts);
        this.outputFieldReferenceCounts = ImmutableMap.copyOf(builder.outputFieldReferenceCounts);
        this.argReferenceCount = ImmutableMap.copyOf(builder.argReferenceCount);
        this.interfaceReferenceCount = ImmutableMap.copyOf(builder.interfaceReferenceCount);
        this.unionReferenceCount = ImmutableMap.copyOf(builder.unionReferenceCount);
        this.directiveReferenceCount = ImmutableMap.copyOf(builder.directiveReferenceCount);
        this.interfaceImplementors = ImmutableMap.copyOf(builder.interfaceImplementors);
        this.elementBackReferences = ImmutableMap.copyOf(builder.elementBackReferences);
        this.unionReferences = ImmutableMap.copyOf(builder.unionReferences);
    }

    public Map<String, Integer> getFieldReferenceCounts() {
        return this.fieldReferenceCounts;
    }

    public Map<String, Integer> getOutputFieldReferenceCounts() {
        return this.outputFieldReferenceCounts;
    }

    public Map<String, Integer> getInputFieldReferenceCounts() {
        return this.inputFieldReferenceCounts;
    }

    public Map<String, Integer> getArgumentReferenceCounts() {
        return this.argReferenceCount;
    }

    public Map<String, Integer> getInterfaceReferenceCounts() {
        return this.interfaceReferenceCount;
    }

    public Map<String, Integer> getUnionReferenceCounts() {
        return this.unionReferenceCount;
    }

    public Map<String, Integer> getDirectiveReferenceCounts() {
        return this.directiveReferenceCount;
    }

    public boolean isStronglyReferenced(GraphQLSchema schema, String elementName) {
        return this.isReferencedImpl(schema, elementName, new HashSet<String>());
    }

    public Set<GraphQLNamedSchemaElement> getUnReferencedElements(GraphQLSchema schema) {
        LinkedHashSet<GraphQLNamedSchemaElement> elements = new LinkedHashSet<GraphQLNamedSchemaElement>();
        schema.getAllTypesAsList().forEach(type -> {
            if (!this.isStronglyReferenced(schema, type.getName())) {
                elements.add((GraphQLNamedSchemaElement)type);
            }
        });
        schema.getDirectives().forEach(directive -> {
            if (!this.isStronglyReferenced(schema, directive.getName())) {
                elements.add((GraphQLNamedSchemaElement)directive);
            }
        });
        return elements;
    }

    private boolean isReferencedImpl(GraphQLSchema schema, String elementName, Set<String> pathSoFar) {
        GraphQLNamedType type;
        if (pathSoFar.contains(elementName)) {
            return false;
        }
        pathSoFar.add(elementName);
        if (ScalarInfo.isGraphqlSpecifiedScalar(elementName)) {
            return true;
        }
        GraphQLDirective directive = schema.getDirective(elementName);
        if (directive != null) {
            String directiveName = directive.getName();
            if (DirectiveInfo.isGraphqlSpecifiedDirective(directiveName)) {
                return true;
            }
            if (this.isNamedElementReferenced(schema, directiveName, pathSoFar)) {
                return true;
            }
        }
        if ((type = (GraphQLNamedType)schema.getTypeAs(elementName)) == null) {
            return false;
        }
        if (Introspection.isIntrospectionTypes(type)) {
            return true;
        }
        if (type == schema.getQueryType()) {
            return true;
        }
        if (type == schema.getMutationType()) {
            return true;
        }
        if (type == schema.getSubscriptionType()) {
            return true;
        }
        if (this.isNamedElementReferenced(schema, elementName, pathSoFar)) {
            return true;
        }
        if (type instanceof GraphQLInterfaceType) {
            Set implementors = this.interfaceImplementors.getOrDefault(type.getName(), Collections.emptySet());
            for (String implementor : implementors) {
                if (!this.isReferencedImpl(schema, implementor, pathSoFar)) continue;
                return true;
            }
        }
        if (type instanceof GraphQLObjectType) {
            List<GraphQLNamedOutputType> interfaces = ((GraphQLObjectType)type).getInterfaces();
            for (GraphQLNamedOutputType memberInterface : interfaces) {
                Set implementors = this.interfaceImplementors.getOrDefault(memberInterface.getName(), Collections.emptySet());
                for (String implementor : implementors) {
                    if (!this.isReferencedImpl(schema, implementor, pathSoFar)) continue;
                    return true;
                }
            }
            Set unionContainers = this.unionReferences.getOrDefault(type.getName(), Collections.emptySet());
            for (String unionContainer : unionContainers) {
                if (!this.isReferencedImpl(schema, unionContainer, pathSoFar)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNamedElementReferenced(GraphQLSchema schema, String elementName, Set<String> pathSoFar) {
        Set references = this.elementBackReferences.getOrDefault(elementName, Collections.emptySet());
        for (String reference : references) {
            if (!this.isReferencedImpl(schema, reference, pathSoFar)) continue;
            return true;
        }
        return false;
    }

    @Internal
    static class Builder {
        Map<String, Integer> fieldReferenceCounts = new LinkedHashMap<String, Integer>();
        Map<String, Integer> inputFieldReferenceCounts = new LinkedHashMap<String, Integer>();
        Map<String, Integer> outputFieldReferenceCounts = new LinkedHashMap<String, Integer>();
        Map<String, Integer> argReferenceCount = new LinkedHashMap<String, Integer>();
        Map<String, Integer> interfaceReferenceCount = new LinkedHashMap<String, Integer>();
        Map<String, Integer> unionReferenceCount = new LinkedHashMap<String, Integer>();
        Map<String, Integer> directiveReferenceCount = new LinkedHashMap<String, Integer>();
        Map<String, Set<String>> interfaceImplementors = new LinkedHashMap<String, Set<String>>();
        Map<String, Set<String>> unionReferences = new LinkedHashMap<String, Set<String>>();
        Map<String, Set<String>> elementBackReferences = new LinkedHashMap<String, Set<String>>();

        Builder() {
        }

        SchemaUsage build() {
            return new SchemaUsage(this);
        }
    }
}

