/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.SipProviderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.RSeqHeader;
import com.ibm.ws.sip.container.events.EventsDispatcher;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.servlets.ReliableResponsesProcessor;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.timer.ReliabeResponseRetransmitTimer;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.stack.transaction.SIPTransactionConstants;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.HeaderParseException;

public class ReliableResponse {
    public static final String RELIABLY_PARAM = "100rel";
    private static final LogMgr c_logger = Log.get(ReliableResponse.class);
    private ReliabeResponseRetransmitTimer _timer;
    private SipServletResponseImpl _response;
    private long _rSeq;
    private long _cSeq;
    private ReliableResponsesProcessor _responseProcessor;

    public ReliableResponse(SipServletResponseImpl response, ReliableResponsesProcessor container) {
        block7: {
            this._rSeq = 0L;
            this._cSeq = 0L;
            this._response = response;
            this._responseProcessor = container;
            try {
                RSeqHeader h = (RSeqHeader)response.getResponse().getHeader("RSeq", true);
                if (h != null) {
                    this._rSeq = h.getResponseNumber();
                }
                CSeqHeader ch = (CSeqHeader)response.getResponse().getHeader("CSeq", true);
                if (h != null) {
                    this._cSeq = ch.getSequenceNumber();
                }
            }
            catch (HeaderParseException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "ReliableResponse", "Somthing was wrong in the RSeqHeader");
                }
            }
            catch (IllegalArgumentException e3) {
                if (!c_logger.isTraceDebugEnabled()) break block7;
                c_logger.traceDebug(this, "ReliableResponse", "Somthing was wrong2 in the RSeqHeader");
            }
        }
        if (this.hasOffer()) {
            this._responseProcessor.addOffer();
        }
        this._timer = new ReliabeResponseRetransmitTimer(this);
        SipContainerComponent.getTimerService().schedule(this._timer, false, SIPTransactionConstants.T1);
    }

    public SipServletResponseImpl getServletResponse() {
        return this._response;
    }

    public void retransmissionTimedOut() {
        TransactionUserWrapper tUser = this._response.getTransactionUser();
        EventsDispatcher.noPrackReceived(this._response, tUser.getSipServletDesc().getSipApp());
    }

    public void retransmitResponse() {
        block2: {
            try {
                ((SipProviderImpl)this._response.getSipProvider()).sendResponse(this._response.getResponse());
            }
            catch (SipException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                c_logger.error("error.exception", "Send Failure", null, (Throwable)e2);
            }
        }
    }

    public long getRSeq() {
        return this._rSeq;
    }

    public long getCSeq() {
        return this._cSeq;
    }

    public void acknowledged() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "acknowledged", "This Response was acknowledged");
        }
        this.removeThisRequest();
    }

    public void cancel() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cancell", " This Response was canceled");
        }
        this.removeThisRequest();
    }

    private void removeThisRequest() {
        if (this.hasOffer()) {
            this._responseProcessor.removeOffer();
        }
        this._timer.cancel();
    }

    public boolean hasOffer() {
        return this._response.getResponse().hasBody();
    }
}

