/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.pool.sizeof.filter;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;
import net.sf.ehcache.pool.sizeof.filter.SizeOfFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationSizeOfFilter
implements SizeOfFilter {
    @Override
    public Collection<Field> filterFields(Class<?> klazz, Collection<Field> fields) {
        Iterator<Field> it = fields.iterator();
        while (it.hasNext()) {
            if (!it.next().isAnnotationPresent(IgnoreSizeOf.class)) continue;
            it.remove();
        }
        return fields;
    }

    @Override
    public boolean filterClass(Class<?> klazz) {
        boolean classAnnotated = this.isAnnotationPresentOrInherited(klazz);
        Package pack = klazz.getPackage();
        boolean packageAnnotated = pack == null ? false : pack.isAnnotationPresent(IgnoreSizeOf.class);
        return !classAnnotated && !packageAnnotated;
    }

    private boolean isAnnotationPresentOrInherited(Class<?> instanceKlazz) {
        for (Class<?> klazz = instanceKlazz; klazz != null; klazz = klazz.getSuperclass()) {
            IgnoreSizeOf annotation = klazz.getAnnotation(IgnoreSizeOf.class);
            if (annotation == null || klazz != instanceKlazz && !annotation.inherited()) continue;
            return true;
        }
        return false;
    }
}

