/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.spi.LookupService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.microprofile.graphql.GraphQLException;

public class ReflectionHelper {
    private final LookupService lookupService = LookupService.get();
    private final ClassloadingService classloadingService = ClassloadingService.get();
    private final Operation operation;
    private final EventEmitter eventEmitter;
    private final Class<?> operationClass;
    private final Method method;
    private int injectContextAt = -1;

    public ReflectionHelper(Operation operation, EventEmitter eventEmitter) {
        this.operation = operation;
        this.eventEmitter = eventEmitter;
        this.operationClass = this.classloadingService.loadClass(operation.getClassName());
        this.method = this.lookupMethod(this.operationClass, operation);
    }

    public <T> T invokePrivileged(Object ... arguments) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return this.invokePrivileged(tccl, arguments);
    }

    public <T> T invokePrivileged(final ClassLoader classLoader, final Object ... arguments) {
        try {
            return (T)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    try {
                        Object t = ReflectionHelper.this.invoke(arguments);
                        return t;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalTccl);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public <T> T invoke(Object ... arguments) throws Exception {
        try {
            Object operationInstance = this.lookupService.getInstance(this.operationClass);
            this.eventEmitter.fireBeforeMethodInvoke(new InvokeInfo(operationInstance, this.method, arguments));
            if (this.injectContextAt > -1) {
                arguments = this.injectContext(arguments);
            }
            return (T)this.method.invoke(operationInstance, arguments);
        }
        catch (InvocationTargetException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof GraphQLException) {
                throw (GraphQLException)throwable;
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, throwable);
        }
    }

    private Method lookupMethod(Class<?> operationClass, Operation operation) {
        try {
            return operationClass.getMethod(operation.getMethodName(), this.getParameterClasses(operation));
        }
        catch (NoSuchMethodException e) {
            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(operation, e);
        }
    }

    private Class<?>[] getParameterClasses(Operation operation) {
        if (operation.hasArguments()) {
            LinkedList cl = new LinkedList();
            int cnt = 0;
            for (Field field : operation.getArguments()) {
                Class<?> clazz;
                if (field.hasWrapper()) {
                    clazz = this.classloadingService.loadClass(field.getWrapper().getWrapperClassName());
                    cl.add(clazz);
                } else {
                    clazz = this.classloadingService.loadClass(field.getReference().getClassName());
                    cl.add(clazz);
                    if (field.getReference().getClassName().equals(Context.class.getName())) {
                        this.injectContextAt = cnt;
                    }
                }
                ++cnt;
            }
            return cl.toArray(new Class[0]);
        }
        return null;
    }

    private Object[] injectContext(Object[] arguments) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arguments));
        list.set(this.injectContextAt, SmallRyeContext.getContext());
        return list.toArray();
    }
}

