/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import io.openliberty.grpc.internal.client.config.GrpcClientConfig;
import io.openliberty.grpc.internal.client.config.GrpcClientConfigHolder;
import io.openliberty.grpc.internal.client.config.GrpcClientConfigValidation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(immediate=true, service={GrpcClientConfig.class}, configurationPid={"io.openliberty.grpc.clientConfig"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class GrpcClientConfigImpl
implements GrpcClientConfig {
    private static final TraceComponent tc = Tr.register(GrpcClientConfigImpl.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.client.resources.grpcclientmessages");
    private static final HashSet<String> propertiesToRemove = new HashSet();

    private Map<String, String> filterProps(Map<String, Object> props) {
        boolean debug;
        HashMap<String, String> filteredProps = new HashMap<String, String>();
        Iterator<String> it = props.keySet().iterator();
        boolean bl = debug = tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled();
        while (it.hasNext()) {
            String key = it.next();
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("key: " + key + " value: " + props.get(key)), (Object[])new Object[0]);
            }
            if (propertiesToRemove.contains(key) || key.compareTo("keepAliveTime") == 0 && !GrpcClientConfigValidation.validateKeepAliveTime(props.get(key).toString()) || key.compareTo("keepAliveTimeout") == 0 && !GrpcClientConfigValidation.validateKeepAliveTimeout(props.get(key).toString()) || key.compareTo("maxInboundMessageSize") == 0 && !GrpcClientConfigValidation.validateMaxInboundMessageSize(props.get(key).toString()) || key.compareTo("sslRef") == 0 && !GrpcClientConfigValidation.validateSslConfig(props.get(key).toString())) continue;
            filteredProps.put(key, props.get(key).toString());
        }
        return filteredProps;
    }

    private String getHost(Map<String, Object> props) {
        if (props == null) {
            return null;
        }
        if (props.keySet().contains("host")) {
            return props.get("host").toString();
        }
        return null;
    }

    private String getPath(Map<String, Object> props) {
        if (props == null) {
            return null;
        }
        if (props.keySet().contains("path")) {
            return props.get("path").toString();
        }
        return null;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        String host = this.getHost(properties);
        String path = this.getPath(properties);
        GrpcClientConfigHolder.addConfig(this.toString(), GrpcClientConfigHolder.getPathID(host, path), this.filterProps(properties));
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        GrpcClientConfigHolder.removeConfig(this.toString());
        String host = this.getHost(properties);
        String path = this.getPath(properties);
        GrpcClientConfigHolder.addConfig(this.toString(), GrpcClientConfigHolder.getPathID(host, path), this.filterProps(properties));
    }

    @Deactivate
    protected void deactivate() {
        GrpcClientConfigHolder.removeConfig(this.toString());
    }

    static {
        propertiesToRemove.add("defaultSSHPublicKeyPath");
        propertiesToRemove.add("defaultSSHPrivateKeyPath");
        propertiesToRemove.add("config.overrides");
        propertiesToRemove.add("config.id");
        propertiesToRemove.add("component.id");
        propertiesToRemove.add("config.displayId");
        propertiesToRemove.add("component.name");
        propertiesToRemove.add("config.source");
        propertiesToRemove.add("service.pid");
        propertiesToRemove.add("service.vendor");
        propertiesToRemove.add("service.factoryPid");
        propertiesToRemove.add("host");
    }
}

