/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import com.ibm.websphere.jaxrs20.multipart.IAttachment;
import com.ibm.websphere.jaxrs20.multipart.IMultipartBody;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.resteasy.plugins.providers.multipart.IAttachmentImpl;
import org.jboss.resteasy.plugins.providers.multipart.IMultipartBodyImpl;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.jboss.resteasy.spi.InternalServerErrorException;

@Provider
@Consumes(value={"multipart/related", "multipart/mixed", "multipart/alternative", "multipart/form-data"})
@Produces(value={"multipart/related", "multipart/mixed", "multipart/alternative", "multipart/form-data"})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class IBMMultipartProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Set<Class<?>> MULTIPART_CLASSES;
    private static final Set<String> MULTIPART_SUBTYPES;
    @Context
    Providers providers;
    private LibertyMultipartWriter writer = new LibertyMultipartWriter();
    static final long serialVersionUID = 8677156388429444662L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean isReadable(Class<?> clazz, Type type, Annotation[] anns, MediaType mt) {
        return this.isSupported(clazz, anns, mt);
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] anns, MediaType mt) {
        return this.isSupported(clazz, anns, mt);
    }

    private boolean isSupported(Class<?> type, Annotation[] anns, MediaType mt) {
        return this.mediaTypeSupported(mt) && (MULTIPART_CLASSES.contains(type) || Collection.class.isAssignableFrom(type));
    }

    private boolean mediaTypeSupported(MediaType mt) {
        return "multipart".equals(mt.getType()) && MULTIPART_SUBTYPES.contains(mt.getSubtype());
    }

    public Object readFrom(Class<Object> clazz, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException, WebApplicationException {
        MultipartReader reader = new MultipartReader();
        reader.workers = this.providers;
        Object multiInput = reader.readFrom((Class)MultipartInput.class, genericType, anns, mt, (MultivaluedMap)headers, entityStream);
        if (clazz.equals(IMultipartBody.class)) {
            return new IMultipartBodyImpl((MultipartInputImpl)multiInput);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getActualTypeArguments()[0].getTypeName().equals(IAttachment.class.getName())) {
                ArrayList<IAttachmentImpl> attachments = new ArrayList<IAttachmentImpl>();
                for (InputPart inputPart : multiInput.getParts()) {
                    attachments.add(new IAttachmentImpl(inputPart));
                }
                return attachments;
            }
            if (genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getActualTypeArguments()[0].getTypeName().equals(String.class.getName())) {
                ArrayList<String> parts = new ArrayList<String>();
                for (InputPart inputPart : multiInput.getParts()) {
                    parts.add(inputPart.getBodyAsString());
                }
                return parts;
            }
        }
        String genericTypeStr = genericType == null ? "null" : genericType.getTypeName();
        throw new InternalServerErrorException("Unexpected multipart type: " + clazz.getName() + " / " + genericTypeStr);
    }

    public void writeTo(Object entity, Class<?> clazz, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream outputStream) throws IOException, WebApplicationException {
        List attachments;
        if (entity instanceof IMultipartBody) {
            attachments = ((IMultipartBody)entity).getAllAttachments();
        } else if (entity instanceof List) {
            attachments = (List)entity;
        } else {
            throw new WebApplicationException("Unexpected output type");
        }
        MultipartOutput outputObj = new MultipartOutput();
        for (IAttachment attachment : attachments) {
            Object content = attachment.getDataHandler().getContent();
            OutputPart part = outputObj.addPart(content, content.getClass(), null, attachment.getContentType(), ((IAttachmentImpl)attachment).getFileName());
            attachment.getHeaders().entrySet().stream().forEach(entry -> part.getHeaders().put((Object)((String)entry.getKey()), (Object)((List)entry.getValue())));
        }
        this.writer.init();
        this.writer.writeTo(outputObj, clazz, genericType, anns, mt, headers, outputStream);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.multipart.IBMMultipartProvider", IBMMultipartProvider.class, null, null);
        MULTIPART_CLASSES = new HashSet();
        MULTIPART_SUBTYPES = new HashSet<String>();
        MULTIPART_CLASSES.add(IMultipartBody.class);
        MULTIPART_CLASSES.add(IAttachment.class);
        MULTIPART_SUBTYPES.add("form-data");
        MULTIPART_SUBTYPES.add("mixed");
        MULTIPART_SUBTYPES.add("related");
        MULTIPART_SUBTYPES.add("alternative");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    class LibertyMultipartWriter
    extends MultipartWriter {
        static final long serialVersionUID = 7702829179169078971L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        LibertyMultipartWriter() {
        }

        void init() {
            this.workers = IBMMultipartProvider.this.providers;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.multipart.IBMMultipartProvider$LibertyMultipartWriter", LibertyMultipartWriter.class, null, null);
        }
    }
}

