/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor.computed;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ComputedMappingTable {
    public static final int COMPUTED_METRIC_NAME = 0;
    public static final int COMPUTED_METRIC_DISPLAYNAME = 1;
    public static final int COMPUTED_METRIC_DESCRIPTION = 2;
    public static final int COMPUTED_METRIC_TYPE = 3;
    public static final int COMPUTED_METRIC_UNIT = 4;
    public static final int MONITOR_METRIC_REGISTRY_SCOPE = 5;
    public static final int MONITOR_METRIC_DURATION = 6;
    public static final int MONITOR_METRIC_DURATION_UNIT = 7;
    public static final int MONITOR_METRIC_TOTAL_COUNT = 8;
    public static final int MONITOR_METRIC_TOTAL_UNIT = 9;
    public static final String GAUGE;
    private static ComputedMappingTable singleton;
    private Map<String, String[][]> mappingTable = new HashMap<String, String[][]>();
    static final long serialVersionUID = -8317307421942192750L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ComputedMappingTable getInstance() {
        if (singleton == null) {
            singleton = new ComputedMappingTable();
        }
        return singleton;
    }

    private ComputedMappingTable() {
        String[][] cpuTable = new String[][]{{"cpu.processCpuUtilization", "Process CPU Utilization", "cpu.processCpuUtilization.description", GAUGE, "percent", "base", "cpu.processCpuTime", "nanoseconds", "cpu.availableProcessors", "none"}};
        this.mappingTable.put("cpuStats", cpuTable);
        String[][] memoryTable = new String[][]{{"memory.heapUtilization", "Heap Utilization", "memory.heapUtilization.description", GAUGE, "percent", "base", "memory.usedHeap", "bytes", "memory.maxHeap", "bytes"}};
        this.mappingTable.put("memoryStats", memoryTable);
        String[][] gcTable = new String[][]{{"gc.time.per.cycle", "Total Garbage Collection Time Per Garbage Collection Cycle", "gc.time.per.cycle.description", GAUGE, "seconds", "base", "gc.time", "milliseconds", "gc.total", "none"}};
        this.mappingTable.put("gcStats", gcTable);
        String[][] servletTable = new String[][]{{"servlet.request.elapsedTime.per.request", "Total Elapsed Time per Request", "servlet.request.elapsedTime.per.request.description", GAUGE, "seconds", "vendor", "servlet.responseTime.total", "nanoseconds", "servlet.request.total", "none"}};
        this.mappingTable.put("ServletStats", servletTable);
        String[][] connectionPoolTable = new String[][]{{"connectionpool.inUseTime.per.usedConnection", "Total Connection Pool In Use Time per Used Connection", "connectionpool.inUseTime.per.usedConnection.description", GAUGE, "seconds", "vendor", "connectionpool.inUseTime.total", "milliseconds", "connectionpool.usedConnections.total", "none"}, {"connectionpool.waitTime.per.queuedRequest", "Total Connection Pool Wait Time per Queued Request", "connectionpool.waitTime.per.queuedRequest.description", GAUGE, "seconds", "vendor", "connectionpool.waitTime.total", "milliseconds", "connectionpool.queuedRequests.total", "none"}};
        this.mappingTable.put("ConnectionPoolStats", connectionPoolTable);
        String[][] restTable = new String[][]{{"REST.request.elapsedTime.per.request", "Total Elapsed Time per Request", "REST.request.elapsedTime.per.request.description", GAUGE, "seconds", "vendor", "REST.request.elapsedTime", "nanoseconds", "REST.request.total", "none"}};
        this.mappingTable.put("REST_Stats", restTable);
    }

    public List<String> getMetricGroupsList(String metricScope) {
        ArrayList<String> metricGroupList = new ArrayList<String>();
        for (Map.Entry<String, String[][]> entry : this.mappingTable.entrySet()) {
            String[][] data;
            for (String[] metricData : data = entry.getValue()) {
                if (!metricData[5].equals(metricScope)) continue;
                metricGroupList.add(entry.getKey());
            }
        }
        return metricGroupList;
    }

    public String[][] getData(String metricGroup) {
        String group = metricGroup.contains(",") ? this.getType(metricGroup) : metricGroup;
        for (String k : this.mappingTable.keySet()) {
            if (!group.contains(k)) continue;
            return this.mappingTable.get(k);
        }
        return null;
    }

    private String getType(String objectName) {
        for (String subString : objectName.split(",")) {
            if (!(subString = subString.trim()).contains("type=")) continue;
            return subString.split("=")[1];
        }
        return "notype";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics.internal.monitor.computed.ComputedMappingTable", ComputedMappingTable.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        GAUGE = MetricType.GAUGE.toString().toUpperCase();
        singleton = null;
    }
}

