/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.security.oauth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.client.MpJwtPropagation;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={OAuthPropagationHelper.class}, name="OAuthPropagationHelper", immediate=true, property={"service.vendor=IBM"})
public class OAuthPropagationHelper {
    private static final TraceComponent tc = Tr.register(OAuthPropagationHelper.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
    public static final String ISSUED_JWT_TOKEN = "issuedJwt";
    public static final String MP_JSON_WEB_TOKEN_PROPAGATION = "MpJwtPropagation";
    protected static final AtomicServiceReference<MpJwtPropagation> MpJsonWebTokenUtilRef = new AtomicServiceReference("MpJwtPropagation");
    static final long serialVersionUID = 6970744262472130248L;

    @Reference(service=MpJwtPropagation.class, name="MpJwtPropagation", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setMpJwtPropagation(ServiceReference<MpJwtPropagation> ref) {
        MpJsonWebTokenUtilRef.setReference(ref);
    }

    protected void unsetMpJwtPropagation(ServiceReference<MpJwtPropagation> ref) {
        MpJsonWebTokenUtilRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        MpJsonWebTokenUtilRef.activate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"MpJwtPropagation service is activated", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OAuthPropagationHelper service is activated", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        MpJsonWebTokenUtilRef.deactivate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"MpJwtPropagation service is deactivated", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OAuthPropagationHelper service is activated", (Object[])new Object[0]);
        }
    }

    public static String getMpJsonWebToken() {
        if (MpJsonWebTokenUtilRef.getService() != null) {
            return ((MpJwtPropagation)MpJsonWebTokenUtilRef.getService()).getJsonWebTokenPrincipal(OAuthPropagationHelper.getRunAsSubject());
        }
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"warn_mpjwt_prop_service_notavail", (Object[])new Object[0]);
        Tr.warning((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        return null;
    }

    public static String getAccessTokenType() {
        return OAuthPropagationHelper.getSubjectAttributeString("token_type", true);
    }

    public static String getAccessToken() {
        return OAuthPropagationHelper.getSubjectAttributeString("access_token", true);
    }

    public static String getJwtToken() throws Exception {
        String jwt = OAuthPropagationHelper.getIssuedJwtToken();
        if (jwt == null && !OAuthPropagationHelper.isJwt(jwt = OAuthPropagationHelper.getAccessToken())) {
            jwt = null;
        }
        return jwt;
    }

    private static boolean isJwt(String jwt) {
        return jwt != null && jwt.indexOf(".") >= 0;
    }

    public static String getIssuedJwtToken() throws Exception {
        return OAuthPropagationHelper.getSubjectAttributeString(ISSUED_JWT_TOKEN, true);
    }

    public static String getScopes() {
        return OAuthPropagationHelper.getSubjectAttributeString("scope", true);
    }

    /*
     * WARNING - void declaration
     */
    static Subject getRunAsSubject() {
        try {
            return WSSubject.getRunAsSubject();
        }
        catch (WSSecurityException wSSecurityException) {
            void e;
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.jaxrs20.client.security.oauth.OAuthPropagationHelper", (String)"146", null, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while getting runAsSubject:", (Object[])new Object[]{e.getCause()});
            }
            Tr.warning((TraceComponent)tc, (String)"failed_run_as_subject", (Object[])new Object[]{e.getLocalizedMessage()});
            return null;
        }
    }

    static String getSubjectAttributeString(String attribKey, boolean bindWithAccessToken) {
        Subject runAsSubject = OAuthPropagationHelper.getRunAsSubject();
        if (runAsSubject != null) {
            return OAuthPropagationHelper.getSubjectAttributeObject(runAsSubject, attribKey, bindWithAccessToken);
        }
        return null;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    static String getSubjectAttributeObject(Subject subject, String attribKey, boolean bindWithAccessToken) {
        try {
            Set<Object> publicCredentials = subject.getPublicCredentials();
            String result = OAuthPropagationHelper.getCredentialAttribute(publicCredentials, attribKey, bindWithAccessToken, "publicCredentials");
            if (result == null || result.isEmpty()) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                result = OAuthPropagationHelper.getCredentialAttribute(privateCredentials, attribKey, bindWithAccessToken, "privateCredentials");
            }
            return result;
        }
        catch (PrivilegedActionException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find a value for the attribute (" + attribKey + ")"), (Object[])new Object[0]);
            }
            return null;
        }
    }

    static String getCredentialAttribute(final Set<Object> credentials, final String attribKey, final boolean bindWithAccessToken, final String msg) throws PrivilegedActionException {
        Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
            static final long serialVersionUID = -719887960180542843L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() throws Exception {
                int iCnt = 0;
                for (Object credentialObj : credentials) {
                    Object value;
                    Object accessToken;
                    ++iCnt;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(msg + "(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
                    }
                    if (!(credentialObj instanceof Map) || bindWithAccessToken && (accessToken = ((Map)credentialObj).get("access_token")) == null || (value = ((Map)credentialObj).get(attribKey)) == null) continue;
                    return value;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.client.security.oauth.OAuthPropagationHelper$1", 1.class, null, null);
            }
        });
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }
}

