/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jcache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.library.spi.SpiLibrary;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.library.Library;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.jcache.internal.CacheServiceClassLoader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.condition.Condition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={CachingProviderService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"io.openliberty.jcache.cachingprovider"}, property={"service.vendor=IBM"})
public class CachingProviderService {
    private static final TraceComponent tc = Tr.register(CachingProviderService.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
    private static final String KEY_PROVIDER_CLASS = "providerClass";
    private static final String KEY_ID = "id";
    private CachingProvider cachingProvider = null;
    private Set<Library> commonLibraries = new HashSet<Library>();
    private Library jCacheLibrary;
    private ClassLoader classLoader = null;
    private String cachingProviderClass = null;
    private String id = null;
    private ClassLoadingService classLoadingService = null;
    private Object closeSyncObject = null;
    static final long serialVersionUID = -8368103840203161577L;

    @Activate
    public void activate(Map<String, Object> configProps) throws Exception {
        this.closeSyncObject = new Object();
        this.processConfiguration(configProps);
        CheckpointPhase.onRestore((int)0, (CheckpointPhase.OnRestore)new CheckpointPhase.OnRestore(){
            static final long serialVersionUID = 2902886600267446679L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            public void call() throws Throwable {
                try {
                    ClassLoader classloader = CachingProviderService.this.getUnifiedClassLoader();
                    if (CachingProviderService.this.cachingProviderClass != null && !CachingProviderService.this.cachingProviderClass.trim().isEmpty()) {
                        CachingProviderService.this.cachingProvider = Caching.getCachingProvider((String)CachingProviderService.this.cachingProviderClass, (ClassLoader)classloader);
                    } else {
                        CachingProviderService.this.cachingProvider = Caching.getCachingProvider((ClassLoader)classloader);
                    }
                }
                catch (Throwable classloader) {
                    void e;
                    FFDCFilter.processException((Throwable)classloader, (String)"io.openliberty.jcache.internal.CachingProviderService$1", (String)"96", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"CWLJC0004_GET_PROVIDER_FAILED", (Object[])new Object[]{CachingProviderService.this.id, e});
                    throw e;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.jcache.internal.CachingProviderService$1", 1.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
            }
        });
    }

    @Modified
    public void modified(Map<String, Object> configProps) {
        this.processConfiguration(configProps);
    }

    private void processConfiguration(Map<String, Object> configProps) {
        this.id = (String)configProps.get(KEY_ID);
        this.cachingProviderClass = (String)configProps.get(KEY_PROVIDER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    @FFDCIgnore(value={Exception.class})
    public void deactivate() {
        if (this.cachingProvider != null) {
            Object object = this.closeSyncObject;
            synchronized (object) {
                try {
                    this.cachingProvider.close();
                }
                catch (Exception e) {
                    Tr.warning((TraceComponent)tc, (String)"CWLJC0014_CLOSE_CACHINGPRVDR_ERR", (Object[])new Object[]{this.id == null ? "" : this.id, e});
                }
            }
        }
        this.cachingProvider = null;
        this.classLoader = null;
        this.closeSyncObject = null;
    }

    public ClassLoader getUnifiedClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        int numFollowOns = (this.commonLibraries != null ? this.commonLibraries.size() : 0) + 1;
        ClassLoader[] followOns = new ClassLoader[numFollowOns];
        int idx = 0;
        followOns[idx++] = ((SpiLibrary)this.jCacheLibrary).getSpiClassLoader(CachingProviderService.class.getName());
        if (this.commonLibraries != null) {
            for (Library commonLib : this.commonLibraries) {
                if (commonLib.id().equalsIgnoreCase(this.jCacheLibrary.id())) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"CWLJC0006_MULTI_REF_LIB", (Object[])new Object[]{this.id == null ? "" : this.id, commonLib.id()});
                    Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                    throw new IllegalStateException(msg);
                }
                followOns[idx++] = commonLib.getClassLoader();
            }
        }
        ClassLoader unifiedClassLoader = this.classLoadingService.unify(CachingProviderService.class.getClassLoader(), followOns);
        this.classLoader = new CacheServiceClassLoader(unifiedClassLoader);
        return this.classLoader;
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    @Reference(name="commonLibrary", cardinality=ReferenceCardinality.MULTIPLE, target="(id=unbound)")
    public void setCommonLibrary(Library library) {
        this.commonLibraries.add(library);
        this.classLoader = null;
    }

    public void unsetCommonLibrary(Library library) {
        this.commonLibraries.remove(library);
        this.classLoader = null;
    }

    @Reference(name="jCacheLibrary", cardinality=ReferenceCardinality.MANDATORY, target="(id=unbound)")
    public void setJCacheLibrary(Library library) {
        this.jCacheLibrary = library;
        this.classLoader = null;
    }

    public void unsetLibrary(Library library) {
        if (this.jCacheLibrary != null) {
            this.jCacheLibrary = null;
            this.classLoader = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setClassLoadingService(ClassLoadingService classLoadingService) {
        this.classLoadingService = classLoadingService;
    }

    public void unsetClassLoadingService(ClassLoadingService classLoadingService) {
        this.classLoadingService = null;
    }

    @Reference(name="configCondition", service=Condition.class, target="(osgi.condition.id=jcache.cache.config)")
    protected void setConfigCondition(Condition configCondition) {
    }

    public String toString() {
        return super.toString() + "{id=" + this.id + ", cachingProvider=" + this.cachingProvider + ", jCacheLibrary=" + this.jCacheLibrary + ", commonLibraries=" + this.commonLibraries + "}";
    }

    Object getCloseSyncObject() {
        return this.closeSyncObject;
    }
}

