/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class LogRecord {
    private static final TraceComponent tc = Tr.register(LogRecord.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected static final byte TRUE = 1;
    protected static final byte FALSE = 0;
    protected ByteBuffer _buffer;
    private final int _absolutePosition;
    protected static final byte[] RECORD_MAGIC_NUMBER = new byte[]{82, 67, 82, 68};
    public static final int HEADER_SIZE = RECORD_MAGIC_NUMBER.length + 8 + 4 + 8;
    static final long serialVersionUID = 6906157404203407169L;

    @Trivial
    protected LogRecord(Buffer buffer, int absolutePosition) {
        this._buffer = (ByteBuffer)buffer;
        this._absolutePosition = absolutePosition;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LogRecord {0} {1} {2}", (Object[])new Object[]{this, buffer, absolutePosition});
        }
    }

    @Trivial
    protected int position() {
        int position = this._absolutePosition + this._buffer.position();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"position {0} {1}", (Object[])new Object[]{position, this});
        }
        return position;
    }

    @ManualTrace
    protected void position(int newPosition) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"position", (Object[])new Object[]{this, newPosition});
        }
        this._buffer.position(newPosition -= this._absolutePosition);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"position");
        }
    }

    @Trivial
    protected int absolutePosition() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"absolutePosition {0} {1}", (Object[])new Object[]{this._absolutePosition, this});
        }
        return this._absolutePosition;
    }

    @ManualTrace
    protected void advancePosition(int bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"advancePosition", (Object[])new Object[]{this, bytes});
        }
        int newPosition = this._buffer.position() + bytes;
        this._buffer.position(newPosition);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Buffer's position now " + newPosition), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"advancePosition");
        }
    }

    @Trivial
    protected void get(byte[] bytes) {
        this._buffer.get(bytes);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)RLSUtils.toHexString(bytes, 32), (Object[])new Object[0]);
        }
    }

    @Trivial
    protected int getInt() {
        int data = this._buffer.getInt();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getInt {0} {1}", (Object[])new Object[]{data, this});
        }
        return data;
    }

    @Trivial
    protected long getLong() {
        long data = this._buffer.getLong();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getLong {0} {1}", (Object[])new Object[]{data, this});
        }
        return data;
    }

    @Trivial
    protected short getShort() {
        short data = this._buffer.getShort();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getShort {0} {1}", (Object[])new Object[]{data, this});
        }
        return data;
    }

    @Trivial
    protected boolean getBoolean() {
        boolean data;
        byte dataByte = this._buffer.get();
        boolean bl = data = dataByte == 1;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getBoolean {0} {1}", (Object[])new Object[]{data, this});
        }
        return data;
    }
}

