/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.ByteArrayOutputStream;

class ObjectManagerByteArrayOutputStream
extends ByteArrayOutputStream {
    private static final Class cclass = ObjectManagerByteArrayOutputStream.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerLog");
    private int releaseSize;

    ObjectManagerByteArrayOutputStream() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
            trace.exit(this, cclass, "<init>");
        }
    }

    ObjectManagerByteArrayOutputStream(int size) {
        super(size);
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{new Integer(size)});
            trace.exit(this, cclass, "<init>");
        }
    }

    byte[] getBuffer() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getBuffer");
            trace.exit((Object)this, cclass, "getBuffer", "return length=" + this.buf.length);
        }
        return this.buf;
    }

    int getCount() {
        return this.count;
    }

    final void setReleaseSize(int releaseSize) {
        this.releaseSize = releaseSize;
    }

    final int getReleaseSize() {
        return this.releaseSize;
    }

    @Override
    public void reset() {
        super.reset();
        this.releaseSize = 0;
    }

    final void writeInt(int value) {
        byte[] writeBuffer = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
        this.write(writeBuffer, 0, 4);
    }

    final void writeLong(long value) {
        byte[] writeBuffer = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
        this.write(writeBuffer, 0, 8);
    }

    @Override
    public String toString() {
        return new String("ObjectManagerByteArrayOutputStream/" + this.count + "/" + Integer.toHexString(this.hashCode()));
    }
}

