/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIDataGraphException;
import com.ibm.websphere.sib.exception.SIDataGraphFormatMismatchException;
import com.ibm.websphere.sib.exception.SIDataGraphSchemaNotFoundException;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIMessageDomainNotSupportedException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SINotSupportedException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.client.OptimizedTransaction;
import com.ibm.ws.sib.comms.client.SuspendableXAResource;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.common.CATHandshakeProperties;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.common.CommsLightTrace;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.impl.CommsClientServiceFacade;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageHandle;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.impl.JsMessageFactory;
import com.ibm.ws.sib.mfp.impl.JsMessageHandleFactory;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.Reasonable;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SICommandInvocationFailedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInsufficientDataForFactoryTypeException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class CommsByteBuffer
extends JFapByteBuffer {
    private static String CLASS_NAME = CommsByteBuffer.class.getName();
    private static final TraceComponent tc = SibTr.register(CommsByteBuffer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private CommsByteBufferPool poolManager = null;

    public CommsByteBuffer(CommsByteBufferPool pool) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)pool);
        }
        this.poolManager = pool;
        this.reset();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public synchronized void putShort(int item) {
        super.putShort((short)item);
    }

    public synchronized void putString(String item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putString", (Object)item);
        }
        this.checkValid();
        if (item == null) {
            WsByteBuffer currentBuffer = this.getCurrentByteBuffer(3);
            currentBuffer.putShort((short)1);
            currentBuffer.put(new byte[]{0});
        } else {
            byte[] stringAsBytes = item.getBytes(StandardCharsets.UTF_8);
            WsByteBuffer currentBuffer = this.getCurrentByteBuffer(2 + stringAsBytes.length);
            currentBuffer.putShort((short)stringAsBytes.length);
            currentBuffer.put(stringAsBytes);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putString");
        }
    }

    public synchronized void putSIDestinationAddress(SIDestinationAddress destAddr, short fapLevel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putSIDestinationAddress", (Object)new Object[]{destAddr, fapLevel});
        }
        this.checkValid();
        String destName = null;
        String busName = null;
        byte[] uuid = new byte[]{};
        boolean localOnly = false;
        if (destAddr != null) {
            destName = destAddr.getDestinationName();
            busName = destAddr.getBusName();
            if (destAddr instanceof JsDestinationAddress) {
                JsDestinationAddress jsDestAddr = (JsDestinationAddress)destAddr;
                if (jsDestAddr.getME() != null) {
                    uuid = jsDestAddr.getME().toByteArray();
                }
                localOnly = jsDestAddr.isLocalOnly();
            }
        }
        this.putShort((short)uuid.length);
        if (uuid.length != 0) {
            this.put(uuid);
        }
        this.putString(destName);
        this.putString(busName);
        if (fapLevel >= 9) {
            this.put(localOnly ? (byte)0 : 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putSIDestinationAddress");
        }
    }

    public synchronized void putSelectionCriteria(SelectionCriteria criteria) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putSelectionCriteria", (Object)criteria);
        }
        this.checkValid();
        String discriminator = null;
        String selector = null;
        short selectorDomain = (short)SelectorDomain.SIMESSAGE.toInt();
        if (criteria != null) {
            discriminator = criteria.getDiscriminator();
            selector = criteria.getSelectorString();
            SelectorDomain selDomain = criteria.getSelectorDomain();
            if (selDomain != null) {
                selectorDomain = (short)selDomain.toInt();
            }
        }
        this.putShort(selectorDomain);
        this.putString(discriminator);
        this.putString(selector);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putSelectionCriteria");
        }
    }

    public synchronized void putXid(Xid xid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putXid", (Object)xid);
        }
        this.putInt(xid.getFormatId());
        this.putInt(xid.getGlobalTransactionId().length);
        this.put(xid.getGlobalTransactionId());
        this.putInt(xid.getBranchQualifier().length);
        this.put(xid.getBranchQualifier());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putXid");
        }
    }

    public synchronized void putSITransaction(SITransaction transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putSITransaction", (Object)transaction);
        }
        Transaction commsTx = (Transaction)transaction;
        int flags = -1;
        if (transaction == null) {
            this.putInt(0);
        } else {
            OptimizedTransaction optTx = null;
            if (transaction instanceof SuspendableXAResource) {
                SIXAResource suspendableXARes = ((SuspendableXAResource)transaction).getCurrentXAResource();
                if (suspendableXARes instanceof OptimizedTransaction) {
                    optTx = (OptimizedTransaction)suspendableXARes;
                }
            } else if (transaction instanceof OptimizedTransaction) {
                optTx = (OptimizedTransaction)transaction;
            }
            if (optTx != null) {
                flags = 1;
                boolean local = optTx instanceof SIUncoordinatedTransaction;
                boolean addXid = false;
                boolean endPreviousUow = false;
                if (local) {
                    flags |= 2;
                }
                if (!optTx.isServerTransactionCreated()) {
                    flags |= 4;
                    if (local && optTx.areSubordinatesAllowed()) {
                        flags |= 0x10;
                    }
                    optTx.setServerTransactionCreated();
                    boolean bl = addXid = !local;
                }
                if (addXid && optTx.isEndRequired()) {
                    flags |= 8;
                    endPreviousUow = true;
                }
                this.putInt(flags);
                this.putInt(optTx.getCreatingConversationId());
                this.putInt(commsTx.getTransactionId());
                if (addXid) {
                    if (endPreviousUow) {
                        this.putInt(optTx.getEndFlags());
                        optTx.setEndNotRequired();
                    }
                    this.putXid(new XidProxy(optTx.getXidForCurrentUow()));
                }
            } else {
                this.putInt(commsTx.getTransactionId());
            }
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            int commsId = -1;
            if (commsTx != null) {
                commsId = commsTx.getTransactionId();
            }
            CommsLightTrace.traceTransaction(tc, "PutTxnTrace", commsTx, commsId, flags);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putSITransaction");
        }
    }

    public synchronized int putMessage(JsMessage message, CommsConnection commsConnection, Conversation conversation) throws MessageCopyFailedException, IncorrectMessageTypeException, MessageEncodeFailedException, UnsupportedEncodingException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putMessage", (Object)new Object[]{message, commsConnection, conversation});
        }
        int messageLength = this.putMessgeWithoutEncode(this.encodeFast((AbstractMessage)message, commsConnection, conversation));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putMessage", (Object)messageLength);
        }
        return messageLength;
    }

    public int putMessgeWithoutEncode(List<DataSlice> messageParts) {
        int x;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putMessgeWithoutEncode", messageParts);
        }
        int messageLength = 0;
        for (x = 0; x < messageParts.size(); ++x) {
            messageLength += messageParts.get(x).getLength();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message is " + messageLength + "byte(s) in length"));
        }
        this.putLong(messageLength);
        for (x = 0; x < messageParts.size(); ++x) {
            DataSlice messPart = messageParts.get(x);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("DataSlice[" + x + "]: Array: " + Arrays.toString(messPart.getBytes()) + ", Offset: " + messPart.getOffset() + ", Length: " + messPart.getLength()));
            }
            this.wrap(messPart.getBytes(), messPart.getOffset(), messPart.getLength());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putMessgeWithoutEncode", (Object)messageLength);
        }
        return messageLength;
    }

    public synchronized int putClientMessage(SIBusMessage message, CommsConnection commsConnection, Conversation conversation) throws SIConnectionDroppedException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putClientMessage", (Object)new Object[]{message, commsConnection, conversation});
        }
        int msgLength = 0;
        try {
            msgLength = this.putMessage((JsMessage)message, commsConnection, conversation);
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".putClientMessage"), (String)"5-006-0005", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught unsupported encoding exception", (Object)e);
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageCopyFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".putClientMessage"), (String)"5-006-0006", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught message copy failed exception", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (IncorrectMessageTypeException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".putClientMessage"), (String)"5-006-0007", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught incorrect message type exception", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageEncodeFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".putClientMessage"), (String)"5-006-0008", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught message encoding failed exception", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putClientMessage", (Object)msgLength);
        }
        return msgLength;
    }

    public synchronized void putDataSlice(DataSlice slice) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putDataSlice", (Object)slice);
        }
        this.putInt(slice.getLength());
        this.wrap(slice.getBytes(), slice.getOffset(), slice.getLength());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putDataSlice");
        }
    }

    public synchronized void putSIMessageHandles(SIMessageHandle[] siMsgHandles) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putSIMessageHandles", (Object)siMsgHandles);
        }
        this.putInt(siMsgHandles.length);
        for (int handleIndex = 0; handleIndex < siMsgHandles.length; ++handleIndex) {
            JsMessageHandle jsHandle = (JsMessageHandle)siMsgHandles[handleIndex];
            this.putLong(jsHandle.getSystemMessageValue());
            this.put(jsHandle.getSystemMessageSourceUuid().toByteArray());
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("message handle: " + siMsgHandles[handleIndex]));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putSIMessageHandles");
        }
    }

    public synchronized void putException(Throwable throwable, String probeId, Conversation conversation) {
        short fapLevel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putException", (Object)new Object[]{throwable, probeId, conversation});
        }
        Throwable currentException = throwable;
        short numberOfExceptions = 0;
        while (currentException != null) {
            currentException = currentException.getCause();
            numberOfExceptions = (short)(numberOfExceptions + 1);
        }
        this.putShort(numberOfExceptions);
        for (currentException = throwable; currentException != null; currentException = currentException.getCause()) {
            short exceptionId = this.getExceptionId(currentException);
            this.addException(currentException, exceptionId, probeId);
            probeId = null;
        }
        HandshakeProperties handshakeProperties = conversation.getHandshakeProperties();
        if (handshakeProperties != null && ((CATHandshakeProperties)handshakeProperties).isFapLevelKnown() && (fapLevel = ((CATHandshakeProperties)handshakeProperties).getFapLevel()) >= 9) {
            int reason = 1;
            String[] inserts = Reasonable.DEFAULT_INSERTS;
            if (throwable instanceof Reasonable) {
                reason = ((Reasonable)throwable).getExceptionReason();
                inserts = ((Reasonable)throwable).getExceptionInserts();
            } else if (throwable instanceof SIException) {
                reason = ((SIException)throwable).getExceptionReason();
                inserts = ((SIException)throwable).getExceptionInserts();
            } else if (throwable instanceof SIErrorException) {
                reason = ((SIErrorException)throwable).getExceptionReason();
                inserts = ((SIErrorException)throwable).getExceptionInserts();
            }
            this.putInt(reason);
            this.putShort(inserts.length);
            for (int i = 0; i < inserts.length; ++i) {
                this.putString(inserts[i]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putException");
        }
    }

    public void putMap(Map<String, String> map) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putMap", (Object)("map=" + map));
        }
        if (map != null) {
            Set<String> keys = map.keySet();
            this.putShort(keys.size());
            for (String k : keys) {
                this.putString(k);
                this.putString(map.get(k));
            }
        } else {
            this.putShort(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putMap");
        }
    }

    public synchronized byte[] getRemaining() {
        return this.get(this.receivedBuffer.remaining());
    }

    public synchronized String getString() {
        this.checkReleased();
        String returningString = null;
        short stringLength = this.receivedBuffer.getShort();
        byte[] stringBytes = new byte[stringLength];
        this.receivedBuffer.get(stringBytes);
        if (stringLength != 1 || stringBytes[0] != 0) {
            returningString = new String(stringBytes, StandardCharsets.UTF_8);
        }
        return returningString;
    }

    public synchronized SIDestinationAddress getSIDestinationAddress(short fapLevel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSIDestinationAddress", (Object)fapLevel);
        }
        this.checkReleased();
        boolean isFromMediation = false;
        short uuidLength = this.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Uuid length:", (Object)("" + uuidLength));
        }
        SIBUuid8 uuid = null;
        if (uuidLength != 0) {
            if (uuidLength == 1) {
                byte addressFlags = this.get();
                if (addressFlags == 1) {
                    isFromMediation = true;
                }
            } else {
                byte[] uuidBytes = this.get(uuidLength);
                uuid = new SIBUuid8(uuidBytes);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Uuid:", (Object)uuid);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Uuid was null");
        }
        String destinationName = this.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Destination name:", (Object)destinationName);
        }
        String busName = this.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Bus name:", (Object)busName);
        }
        boolean localOnly = false;
        if (fapLevel >= 9) {
            byte localOnlyByte = this.get();
            boolean bl = localOnly = localOnlyByte == 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"localOnly: ", (Object)localOnly);
        }
        JsDestinationAddress destAddress = null;
        if (uuid == null && destinationName == null && busName == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Both UUID, destination name and bus name were null");
            }
        } else {
            destAddress = JsDestinationAddressFactory.getInstance().createJsDestinationAddress(destinationName, localOnly, uuid, busName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSIDestinationAddress", (Object)destAddress);
        }
        return destAddress;
    }

    public synchronized SelectionCriteria getSelectionCriteria() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSelectionCriteria");
        }
        this.checkReleased();
        SelectorDomain selectorDomain = SelectorDomain.getSelectorDomain((int)this.getShort());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Selector domain", (Object)selectorDomain);
        }
        String discriminator = this.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Discriminator:", (Object)discriminator);
        }
        String selector = this.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Selector:", (Object)selector);
        }
        SelectionCriteria selectionCriteria = CommsClientServiceFacade.getSelectionCriteriaFactory().createSelectionCriteria(discriminator, selector, selectorDomain);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSelectionCriteria");
        }
        return selectionCriteria;
    }

    public synchronized Xid getXid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getXid");
        }
        this.checkReleased();
        int formatId = this.getInt();
        int glidLength = this.getInt();
        byte[] globalTransactionId = this.get(glidLength);
        int blqfLength = this.getInt();
        byte[] branchQualifier = this.get(blqfLength);
        XidProxy xidProxy = new XidProxy(formatId, globalTransactionId, branchQualifier);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getXid", (Object)xidProxy);
        }
        return xidProxy;
    }

    public synchronized SIBusMessage getMessage(CommsConnection commsConnection) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessage");
        }
        this.checkReleased();
        JsMessage mess = null;
        int messageLen = (int)this.getLong();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message length", (Object)messageLen);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Remaining in buffer", (Object)this.receivedBuffer.remaining());
        }
        if (messageLen > -1) {
            try {
                if (this.receivedBuffer.hasArray()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received buffer has a backing array");
                    }
                    mess = JsMessageFactory.getInstance().createInboundJsMessage(this.receivedBuffer.array(), this.receivedBuffer.position() + this.receivedBuffer.arrayOffset(), messageLen, (Object)commsConnection);
                    this.receivedBuffer.position(this.receivedBuffer.position() + messageLen);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received buffer does NOT have a backing array");
                    }
                    byte[] messageArray = this.get(messageLen);
                    mess = JsMessageFactory.getInstance().createInboundJsMessage(messageArray, 0, messageLen, (Object)commsConnection);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getMessage"), (String)"5-006-0002", (Object)this, (Object[])new Object[]{"messageLen=" + messageLen + ", position=" + this.receivedBuffer.position() + ", limit=" + this.receivedBuffer.limit() + " " + (this.receivedBuffer.hasArray() ? "arrayOffset=" + this.receivedBuffer.arrayOffset() + " array.length=" + this.receivedBuffer.array().length : "no backing array")});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to create message", (Object)e);
                    this.dump(this, tc, 100);
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessage", mess);
        }
        return mess;
    }

    public synchronized DataSlice getDataSlice() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDataSlice");
        }
        DataSlice slice = null;
        int sliceLength = this.getInt();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Slice length: " + sliceLength));
        }
        if (this.receivedBuffer.hasArray()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received buffer has a backing array");
            }
            slice = new DataSlice(this.receivedBuffer.array(), this.receivedBuffer.position() + this.receivedBuffer.arrayOffset(), sliceLength);
            this.receivedBuffer.position(this.receivedBuffer.position() + sliceLength);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received buffer does NOT have a backing array");
            }
            byte[] sliceArray = this.get(sliceLength);
            slice = new DataSlice(sliceArray, 0, sliceLength);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDataSlice", (Object)slice);
        }
        return slice;
    }

    public synchronized SIMessageHandle[] getSIMessageHandles() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSIMessageHandles");
        }
        int arrayCount = this.getInt();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"arrayCount", (Object)arrayCount);
        }
        SIMessageHandle[] msgHandles = new SIMessageHandle[arrayCount];
        JsMessageHandleFactory jsMsgHandleFactory = JsMessageHandleFactory.getInstance();
        for (int msgHandleIndex = 0; msgHandleIndex < msgHandles.length; ++msgHandleIndex) {
            long msgHandleValue = this.getLong();
            byte[] msgHandleUuid = this.get(8);
            msgHandles[msgHandleIndex] = jsMsgHandleFactory.createJsMessageHandle(new SIBUuid8(msgHandleUuid), msgHandleValue);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSIMessageHandles", (Object)msgHandles);
        }
        return msgHandles;
    }

    public synchronized short getCommandCompletionCode(int expectedSegmentType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCommandCompletionCode", (Object)new Object[]{"" + expectedSegmentType});
        }
        this.checkReleased();
        short result = -1;
        if (this.receivedData != null) {
            int receivedDataSegmentType = this.getReceivedDataSegmentType();
            if (receivedDataSegmentType == expectedSegmentType) {
                result = 0;
            } else if (receivedDataSegmentType == 11) {
                this.getShort();
                result = this.getShort();
                this.receivedBuffer.rewind();
            } else {
                String expected = expectedSegmentType + " (0x" + Integer.toHexString(expectedSegmentType).toUpperCase() + ")";
                String actual = receivedDataSegmentType + " (0x" + Integer.toHexString(receivedDataSegmentType).toUpperCase() + ")";
                throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"JFAP_SEG_MISMATCH_EXCEPTION_SICO1006", (Object[])new Object[]{expected, actual}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCommandCompletionCode", (Object)("" + result));
        }
        return result;
    }

    public synchronized void checkXACommandCompletionStatus(int expected, Conversation conversation) throws XAException, Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkXACommandCompletionStatus", (Object)new Object[]{expected, conversation});
        }
        this.checkReleased();
        if (this.receivedData != null) {
            short exceptionType = this.getCommandCompletionCode(expected);
            if (exceptionType != 0) {
                throw this.getException(conversation);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No exception");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkXACommandCompletionStatus");
        }
    }

    public synchronized Exception getException(Conversation conversation) {
        short fapLevel;
        HandshakeProperties handshakeProperties;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getException", (Object)conversation);
        }
        this.checkReleased();
        Exception topException = null;
        if (this.receivedBuffer != null) {
            int numberOfExceptions = this.getShort();
            Throwable link = null;
            for (int x = 0; x < numberOfExceptions; ++x) {
                short exceptionId = this.getShort();
                Exception e = this.parseSingleException(exceptionId);
                if (topException == null) {
                    topException = e;
                    link = topException;
                    continue;
                }
                link.initCause(e);
                link = e;
            }
        }
        if ((handshakeProperties = conversation.getHandshakeProperties()) != null && ((CATHandshakeProperties)handshakeProperties).isFapLevelKnown() && (fapLevel = ((CATHandshakeProperties)handshakeProperties).getFapLevel()) >= 9) {
            int reason = this.getInt();
            String[] inserts = Reasonable.DEFAULT_INSERTS;
            int numberOfInserts = this.getShort();
            if (numberOfInserts > 0) {
                inserts = new String[numberOfInserts];
                for (int i = 0; i < numberOfInserts; ++i) {
                    inserts[i] = this.getString();
                }
            }
            this.setReasonableInformation(topException, reason, inserts);
        }
        if (TraceComponent.isAnyTracingEnabled() && topException != null) {
            CommsLightTrace.traceException(tc, topException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getException", topException);
        }
        return topException;
    }

    private void setReasonableInformation(Exception exception, int reason, String[] inserts) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReasonableInformation", (Object)new Object[]{exception, reason, inserts});
        }
        boolean injectedReason = reason == 1;
        boolean injectedInserts = inserts == Reasonable.DEFAULT_INSERTS;
        for (Throwable nextThrowable = exception; !(nextThrowable == null || injectedReason && injectedInserts); nextThrowable = nextThrowable.getCause()) {
            if (nextThrowable instanceof Reasonable || nextThrowable instanceof SIException || nextThrowable instanceof SIErrorException) {
                block12: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Attempting to add reasonable information for exception of type: " + nextThrowable.getClass()));
                    }
                    if (!injectedReason) {
                        try {
                            Method setReasonMethod = nextThrowable.getClass().getMethod("setExceptionReason", Integer.TYPE);
                            setReasonMethod.invoke((Object)nextThrowable, reason);
                            injectedReason = true;
                        }
                        catch (NoSuchMethodException setReasonMethod) {
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setReasonableInformation"), (String)"5-006-0009", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block12;
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                        }
                    }
                }
                if (injectedInserts) continue;
                try {
                    Method setInsertsMethod = nextThrowable.getClass().getMethod("setExceptionInserts", String[].class);
                    setInsertsMethod.invoke((Object)nextThrowable, new Object[]{inserts});
                    injectedInserts = true;
                }
                catch (NoSuchMethodException setInsertsMethod) {
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setReasonableInformation"), (String)"5-006-0010", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                }
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception (" + exception + ") is not a type which can have a reason or inserts set on it."));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReasonableInformation");
        }
    }

    public synchronized int getReceivedDataSegmentType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReceivedDataSegmentType");
        }
        this.checkReleased();
        int segmentType = -1;
        if (this.receivedData != null) {
            segmentType = this.receivedData.getSegmentType();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReceivedDataSegmentType", (Object)segmentType);
        }
        return segmentType;
    }

    public synchronized int peekInt() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"peekInt");
        }
        this.checkReleased();
        int result = 0;
        if (this.receivedBuffer != null) {
            int currentPosition = this.receivedBuffer.position();
            result = this.receivedBuffer.getInt();
            this.receivedBuffer.position(currentPosition);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"peekInt", (Object)result);
        }
        return result;
    }

    public synchronized long peekLong() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"peekLong");
        }
        this.checkReleased();
        long result = 0L;
        if (this.receivedBuffer != null) {
            int currentPosition = this.receivedBuffer.position();
            result = this.receivedBuffer.getLong();
            this.receivedBuffer.position(currentPosition);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"peekLong", (Object)result);
        }
        return result;
    }

    public synchronized void skip(int lengthToSkip) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"skip", (Object)lengthToSkip);
        }
        this.checkReleased();
        if (this.receivedBuffer != null) {
            this.receivedBuffer.position(this.receivedBuffer.position() + lengthToSkip);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"skip");
        }
    }

    public synchronized void rewind() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rewind");
        }
        this.checkReleased();
        if (this.receivedBuffer != null) {
            this.receivedBuffer.rewind();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rewind");
        }
    }

    @Override
    public synchronized void release() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"release");
        }
        super.release();
        if (this.poolManager != null) {
            this.poolManager.release(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"release");
        }
    }

    public synchronized void release(boolean freeBuffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"release", (Object)freeBuffers);
        }
        if (freeBuffers) {
            this.release();
        } else {
            super.releasePreservingBuffers();
            if (this.poolManager != null) {
                this.poolManager.release(this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"release");
        }
    }

    public List<DataSlice> encodeFast(AbstractMessage message, CommsConnection commsConnection, Conversation conversation) throws MessageEncodeFailedException, SIConnectionDroppedException, IncorrectMessageTypeException, UnsupportedEncodingException, MessageCopyFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodeFast", (Object)new Object[]{CommsLightTrace.msgToString(message), commsConnection, CommsLightTrace.minimalToString(conversation)});
        }
        if (!message.isControlMessage()) {
            boolean requiresJMS;
            short clientCapabilities = ((CATHandshakeProperties)conversation.getHandshakeProperties()).getCapabilites();
            boolean requiresJMF = (clientCapabilities & 0x20) != 0;
            boolean bl = requiresJMS = (clientCapabilities & 0x10) != 0;
            if (requiresJMF || requiresJMS) {
                message = ((JsMessage)message).makeInboundJmsMessage();
            }
            if (requiresJMF) {
                message = ((JsMessage)message).transcribeToJmf();
            }
        }
        List messageParts = null;
        try {
            messageParts = message.encodeFast((Object)commsConnection);
        }
        catch (MessageEncodeFailedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a MessageEncodeFailedException from MFP:", (Object)((Object)e));
            }
            if (e.getCause() != null) {
                if (e.getCause() instanceof SIConnectionDroppedException) {
                    throw new SIConnectionDroppedException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"CONVERSATION_CLOSED_SICO0065", null, null));
                }
                if (e.getCause() instanceof IllegalStateException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"The linked exception IS an IllegalStateException");
                    }
                    if (conversation.isClosed()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"The conversation was closed - rethrowing as SIConnectionDroppedException");
                        }
                        throw new SIConnectionDroppedException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"CONVERSATION_CLOSED_SICO0065", null, null));
                    }
                }
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            CommsLightTrace.traceMessageId(tc, "EncodeMsgTrace", message);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodeFast", (Object)messageParts);
        }
        return messageParts;
    }

    private Exception parseSingleException(int exceptionType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseSingleException");
        }
        short dataId = 0;
        int reasonCode = 0;
        String probeId = null;
        String message = "";
        int numberOfDataItems = this.getShort();
        Object returningException = null;
        block38: for (int x = 0; x < numberOfDataItems; ++x) {
            dataId = this.getShort();
            switch (dataId) {
                case 2: {
                    message = this.getString();
                    continue block38;
                }
                case 1: {
                    probeId = this.getString();
                    continue block38;
                }
                case 3: {
                    this.getShort();
                    reasonCode = this.getInt();
                    continue block38;
                }
            }
        }
        if (probeId != null) {
            message = TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"CORE_EXCEPTION_SICO8007", (Object[])new Object[]{message, probeId}, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Exception Id, Message, ProbeID, Reason", (Object)new Object[]{"" + exceptionType, message, probeId, "" + reasonCode});
        }
        switch (exceptionType) {
            case 257: {
                returningException = new XAException(message);
                ((XAException)returningException).errorCode = reasonCode;
                break;
            }
            case 2: {
                returningException = new SIIncorrectCallException(message);
                break;
            }
            case 3: {
                returningException = new SIInvalidDestinationPrefixException(message);
                break;
            }
            case 4: {
                returningException = new SIDiscriminatorSyntaxException(message);
                break;
            }
            case 5: {
                returningException = new SISelectorSyntaxException(message);
                break;
            }
            case 6: {
                returningException = new SIInsufficientDataForFactoryTypeException(message);
                break;
            }
            case 7: {
                returningException = new SIAuthenticationException(message);
                break;
            }
            case 8: {
                returningException = new SINotPossibleInCurrentConfigurationException(message);
                break;
            }
            case 9: {
                returningException = new SINotAuthorizedException(message);
                break;
            }
            case 10: {
                returningException = new SISessionUnavailableException(message);
                break;
            }
            case 11: {
                returningException = new SISessionDroppedException(message);
                break;
            }
            case 12: {
                returningException = new SIDurableSubscriptionAlreadyExistsException(message);
                break;
            }
            case 13: {
                returningException = new SIDurableSubscriptionMismatchException(message);
                break;
            }
            case 14: {
                returningException = new SIDurableSubscriptionNotFoundException(message);
                break;
            }
            case 15: {
                returningException = new SIConnectionUnavailableException(message);
                break;
            }
            case 16: {
                returningException = new SIConnectionDroppedException(message);
                break;
            }
            case 17: {
                returningException = new SIDataGraphFormatMismatchException(message);
                break;
            }
            case 18: {
                returningException = new SIDataGraphSchemaNotFoundException(message);
                break;
            }
            case 19: {
                returningException = new SIDestinationLockedException(message);
                break;
            }
            case 20: {
                returningException = new SITemporaryDestinationNotFoundException(message);
                break;
            }
            case 21: {
                returningException = new SIMessageException(message);
                break;
            }
            case 22: {
                returningException = new SIResourceException(message);
                break;
            }
            case 23: {
                returningException = new SILimitExceededException(message);
                break;
            }
            case 24: {
                returningException = new SIConnectionLostException(message);
                break;
            }
            case 25: {
                returningException = new SIRollbackException(message);
                break;
            }
            case 26: {
                returningException = new SINotSupportedException(message);
                break;
            }
            case 27: {
                returningException = new SIMessageDomainNotSupportedException(message);
                break;
            }
            case 28: {
                returningException = new SIDataGraphException(message);
                break;
            }
            case 31: {
                returningException = new CommsSIMessageNotLockedException(message);
                break;
            }
            case 29: {
                returningException = new SIErrorException(message);
                break;
            }
            case 30: {
                returningException = new SICommandInvocationFailedException(message);
                break;
            }
            default: {
                message = TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"UNKNOWN_CORE_EXCP_SICO8002", (Object[])new Object[]{message}, null);
                returningException = new SIErrorException(message);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseSingleException");
        }
        return returningException;
    }

    private void addException(Throwable e, short exceptionId, String probeId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addException", (Object)new Object[]{e, exceptionId, probeId});
        }
        String exceptionMessage = null;
        exceptionMessage = exceptionId == 256 ? e.toString() : e.getMessage();
        short noOfDataItemsReturned = 0;
        if (exceptionMessage != null) {
            noOfDataItemsReturned = (short)(noOfDataItemsReturned + 1);
        }
        if (probeId != null) {
            noOfDataItemsReturned = (short)(noOfDataItemsReturned + 1);
        }
        if (e instanceof XAException) {
            noOfDataItemsReturned = (short)(noOfDataItemsReturned + 1);
        }
        this.putShort(exceptionId);
        this.putShort(noOfDataItemsReturned);
        if (exceptionMessage != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Adding message: " + exceptionMessage));
            }
            this.putShort((short)2);
            this.putString(exceptionMessage);
        }
        if (probeId != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Adding probe ID: " + probeId));
            }
            this.putShort((short)1);
            this.putString(probeId);
        }
        if (e instanceof XAException) {
            int reasonCode = ((XAException)e).errorCode;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Adding reason code: " + reasonCode));
            }
            this.putShort((short)3);
            this.putShort(4);
            this.putInt(reasonCode);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addException");
        }
    }

    private short getExceptionId(Throwable exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExceptionId");
        }
        int exceptionId = 256;
        if (exception instanceof SIInvalidDestinationPrefixException) {
            exceptionId = 3;
        } else if (exception instanceof SIDiscriminatorSyntaxException) {
            exceptionId = 4;
        } else if (exception instanceof SISelectorSyntaxException) {
            exceptionId = 5;
        } else if (exception instanceof SIInsufficientDataForFactoryTypeException) {
            exceptionId = 6;
        } else if (exception instanceof SIIncorrectCallException) {
            exceptionId = 2;
        } else if (exception instanceof SIAuthenticationException) {
            exceptionId = 7;
        } else if (exception instanceof SINotAuthorizedException) {
            exceptionId = 9;
        } else if (exception instanceof SINotPossibleInCurrentConfigurationException) {
            exceptionId = 8;
        } else if (exception instanceof SISessionDroppedException) {
            exceptionId = 11;
        } else if (exception instanceof SISessionUnavailableException) {
            exceptionId = 10;
        } else if (exception instanceof SIDurableSubscriptionAlreadyExistsException) {
            exceptionId = 12;
        } else if (exception instanceof SIDurableSubscriptionMismatchException) {
            exceptionId = 13;
        } else if (exception instanceof SIDurableSubscriptionNotFoundException) {
            exceptionId = 14;
        } else if (exception instanceof SIConnectionDroppedException) {
            exceptionId = 16;
        } else if (exception instanceof SIConnectionUnavailableException) {
            exceptionId = 15;
        } else if (exception instanceof SIDataGraphFormatMismatchException) {
            exceptionId = 17;
        } else if (exception instanceof SIDataGraphSchemaNotFoundException) {
            exceptionId = 18;
        } else if (exception instanceof SIDestinationLockedException) {
            exceptionId = 19;
        } else if (exception instanceof SITemporaryDestinationNotFoundException) {
            exceptionId = 20;
        } else if (exception instanceof SIMessageException) {
            exceptionId = 21;
        } else if (exception instanceof SILimitExceededException) {
            exceptionId = 23;
        } else if (exception instanceof SIConnectionLostException) {
            exceptionId = 24;
        } else if (exception instanceof SIRollbackException) {
            exceptionId = 25;
        } else if (exception instanceof SIResourceException) {
            exceptionId = 22;
        } else if (exception instanceof SIMessageDomainNotSupportedException) {
            exceptionId = 27;
        } else if (exception instanceof SINotSupportedException) {
            exceptionId = 26;
        } else if (exception instanceof SIDataGraphException) {
            exceptionId = 28;
        } else if (exception instanceof SICommandInvocationFailedException) {
            exceptionId = 30;
        } else if (exception instanceof SIMessageNotLockedException) {
            exceptionId = 31;
        } else if (exception instanceof SIErrorException) {
            exceptionId = 29;
        } else if (exception instanceof SIException) {
            exceptionId = 1;
        } else if (exception instanceof XAException) {
            exceptionId = 257;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExceptionId", (Object)("" + exceptionId));
        }
        return (short)exceptionId;
    }

    public Map<String, String> getMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMap");
        }
        int len = this.getShort();
        HashMap<String, String> rc = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            rc.put(this.getString(), this.getString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMap", (Object)("rc=" + rc));
        }
        return rc;
    }

    public static int calculateEncodedStringLength(String s) {
        int length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"calculateEncodedStringLength", (Object)s);
        }
        if (s == null) {
            length = 3;
        } else {
            byte[] stringAsBytes = s.getBytes(StandardCharsets.UTF_8);
            length = stringAsBytes.length + 2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"calculateEncodedStringLength", (Object)length);
        }
        return length;
    }

    public synchronized void putBoolean(boolean b) {
        this.put(b ? (byte)0 : 1);
    }

    public synchronized boolean getBoolean() {
        byte value = this.get();
        if (value == 0) {
            return true;
        }
        if (value == 1) {
            return false;
        }
        throw new IllegalStateException("Unexpected byte: " + value);
    }

    static class CommsSIMessageNotLockedException
    extends SIMessageNotLockedException {
        public static final long serialVersionUID = 1913042103164814385L;

        public CommsSIMessageNotLockedException(String msg) {
            super(msg);
        }

        public SIMessageHandle[] getUnlockedMessages() {
            return new SIMessageHandle[0];
        }
    }
}

