/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFTupleType;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class JSTuple
extends JSType
implements JMFTupleType {
    private static TraceComponent tc = JmfTr.register(JSTuple.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private JSType[] fields;
    private JSVariant[] dominated;

    public JSTuple() {
    }

    @Override
    public int getFieldCount() {
        return this.fields == null ? 0 : this.fields.length;
    }

    @Override
    public JMFType getField(int position) {
        if (position >= this.getFieldCount()) {
            throw new IllegalArgumentException("Invalid tuple field");
        }
        return this.fields[position];
    }

    @Override
    public void addField(JMFType field) {
        if (field == null) {
            throw new NullPointerException("Tuple field cannot be null");
        }
        JSType newField = (JSType)field;
        if (this.fields == null) {
            this.fields = new JSType[1];
        } else {
            JSType[] oldFields = this.fields;
            this.fields = new JSType[oldFields.length + 1];
            System.arraycopy(oldFields, 0, this.fields, 0, oldFields.length);
        }
        newField.parent = this;
        newField.siblingPosition = this.fields.length - 1;
        this.fields[newField.siblingPosition] = newField;
    }

    @Override
    BigInteger setMultiChoiceCount() {
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                this.multiChoiceCount = this.multiChoiceCount.multiply(this.fields[i].setMultiChoiceCount());
            }
        }
        return this.multiChoiceCount;
    }

    public JSVariant[] getDominatedVariants() {
        if (this.dominated == null) {
            ArrayList dom = new ArrayList();
            this.getDominatedVariants(dom);
            this.dominated = dom.toArray(new JSVariant[0]);
        }
        return this.dominated;
    }

    private void getDominatedVariants(List dom) {
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                JSType field = this.fields[i];
                if (field instanceof JSVariant) {
                    dom.add(field);
                    continue;
                }
                if (!(field instanceof JSTuple)) continue;
                ((JSTuple)field).getDominatedVariants(dom);
            }
        }
    }

    @Override
    public void format(StringBuffer fmt, Set done, Set todo, int indent) {
        this.formatName(fmt, indent);
        fmt.append("[");
        if (this.fields != null) {
            fmt.append("\n");
            for (int i = 0; i < this.fields.length; ++i) {
                if (i > 0) {
                    fmt.append(",\n");
                }
                this.fields[i].format(fmt, done, todo, indent + 2);
            }
            fmt.append("\n");
            this.indent(fmt, indent);
        }
        fmt.append("]");
    }

    JSTuple(byte[] frame, int[] limits) {
        int count = JSType.getCount(frame, limits);
        this.fields = new JSType[count];
        for (int i = 0; i < count; ++i) {
            this.fields[i] = JSType.createJSType(frame, limits);
            this.fields[i].parent = this;
            this.fields[i].siblingPosition = i;
        }
    }

    @Override
    public int encodedTypeLength() {
        int ans = 3;
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                ans += this.fields[i].encodedTypeLength();
            }
        }
        return ans;
    }

    @Override
    public void encodeType(byte[] frame, int[] limits) {
        JSType.setByte(frame, limits, (byte)3);
        JSType.setCount(frame, limits, this.getFieldCount());
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].encodeType(frame, limits);
            }
        }
    }

    @Override
    public void updateAssociations(JMFType type) {
        super.updateAssociations(type);
        if (this.getFieldCount() != ((JSTuple)type).getFieldCount()) {
            throw new IllegalStateException();
        }
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].updateAssociations(((JSTuple)type).getField(i));
            }
        }
    }
}

