/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.intf.CacheStatisticsListener;

public class CacheStatisticsListenerImpl
implements CacheStatisticsListener {
    private static TraceComponent tc = Tr.register(CacheStatisticsListenerImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private long memoryCacheHits = 0L;
    private long diskCacheHits = 0L;
    private long cacheRemoves = 0L;
    private long cacheLruRemoves = 0L;
    private long overflowEntriesFromMemory = 0L;
    private long explicitInvalidationsFromMemory = 0L;
    private long explicitInvalidationsFromDisk = 0L;
    private long explicitInvalidationsLocal = 0L;
    private long explicitInvalidationsRemote = 0L;
    private long timeoutInvalidationsFromMemory = 0L;
    private long timeoutInvalidationsFromDisk = 0L;
    private long garbageCollectorInvalidationsFromDisk = 0L;
    private long overflowInvalidationsFromDisk = 0L;
    private long depIdsOffloadedToDisk = 0L;
    private long depIdBasedInvalidationsFromDisk = 0L;
    private long templatesOffloadedToDisk = 0L;
    private long templateBasedInvalidationsFromDisk = 0L;
    private long objectsReadFromDisk = 0L;
    private long objectsReadFromDisk4K = 0L;
    private long objectsReadFromDisk40K = 0L;
    private long objectsReadFromDisk400K = 0L;
    private long objectsReadFromDisk4000K = 0L;
    private long objectsReadFromDiskSize = 0L;
    private long objectsWriteToDisk = 0L;
    private long objectsWriteToDisk4K = 0L;
    private long objectsWriteToDisk40K = 0L;
    private long objectsWriteToDisk400K = 0L;
    private long objectsWriteToDisk4000K = 0L;
    private long objectsWriteToDiskSize = 0L;
    private long objectsDeleteFromDisk = 0L;
    private long objectsDeleteFromDisk4K = 0L;
    private long objectsDeleteFromDisk40K = 0L;
    private long objectsDeleteFromDisk400K = 0L;
    private long objectsDeleteFromDisk4000K = 0L;
    private long objectsDeleteFromDiskSize = 0L;
    private long remoteInvalidationNotifications = 0L;
    private long remoteUpdateNotifications = 0L;
    private long remoteObjectUpdates = 0L;
    private long remoteObjectUpdateSize = 0L;
    private long remoteObjectHits = 0L;
    private long remoteObjectFetchSize = 0L;
    private long remoteObjectMisses = 0L;
    private long objectsAsyncLruToDisk = 0L;
    private final Object diskReadMonitor = new Object();
    private final String cacheName;

    public CacheStatisticsListenerImpl(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public final void localCacheHit(Object id, int locality) {
        ++this.cacheHits;
        if (locality == 1) {
            ++this.memoryCacheHits;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": Local cache Hit: " + id + " memoryCacheHits=" + this.memoryCacheHits + " cacheHits=" + this.cacheHits), (Object[])new Object[0]);
            }
        } else {
            ++this.diskCacheHits;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": Local cache Hit: " + id + " diskCacheHits=" + this.diskCacheHits + " cacheHits=" + this.cacheHits), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public final void cacheMiss(Object id) {
        ++this.cacheMisses;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": Cache Miss: id=" + id + " cacheMisses=" + this.cacheMisses), (Object[])new Object[0]);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public final void remove(Object id, int cause, int locality, int source) {
        switch (cause) {
            case 1: {
                ++this.cacheRemoves;
                if (locality == 3) {
                    ++this.explicitInvalidationsFromDisk;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(this.cacheName + "Remove id=" + id + " explicitInvalidationsFromDisk=" + this.explicitInvalidationsFromDisk), (Object[])new Object[0]);
                    }
                } else {
                    ++this.explicitInvalidationsFromMemory;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(this.cacheName + "Remove id=" + id + " explicitInvalidationsFromMemory=" + this.explicitInvalidationsFromMemory), (Object[])new Object[0]);
                    }
                }
                if (source == 2) {
                    ++this.explicitInvalidationsRemote;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)(this.cacheName + "Remove id=" + id + " explicitInvalidationsRemote=" + this.explicitInvalidationsRemote), (Object[])new Object[0]);
                    break;
                }
                ++this.explicitInvalidationsLocal;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)(this.cacheName + "Remove id=" + id + " explicitInvalidationsLocal=" + this.explicitInvalidationsLocal), (Object[])new Object[0]);
                break;
            }
            case 2: {
                ++this.cacheLruRemoves;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)(this.cacheName + "Remove id=" + id + " cacheLruRemoves=" + this.cacheLruRemoves), (Object[])new Object[0]);
                break;
            }
            case 3: {
                ++this.cacheRemoves;
                if (locality == 3) {
                    ++this.timeoutInvalidationsFromDisk;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)(this.cacheName + "Remove id=" + id + " timeoutInvalidationsFromDisk=" + this.timeoutInvalidationsFromDisk), (Object[])new Object[0]);
                    break;
                }
                ++this.timeoutInvalidationsFromMemory;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)(this.cacheName + "Remove id=" + id + " timeoutInvalidationsFromMemory=" + this.timeoutInvalidationsFromMemory), (Object[])new Object[0]);
                break;
            }
            case 7: {
                ++this.garbageCollectorInvalidationsFromDisk;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)(this.cacheName + "Remove id=" + id + " garbageCollectorInvalidationsFromDisk=" + this.garbageCollectorInvalidationsFromDisk), (Object[])new Object[0]);
                break;
            }
            case 8: {
                ++this.overflowInvalidationsFromDisk;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)(this.cacheName + "Remove id=" + id + " overflowInvalidationsFromDisk=" + this.overflowInvalidationsFromDisk), (Object[])new Object[0]);
                break;
            }
        }
    }

    @Override
    public final void depIdsOffloadedToDisk(Object did) {
        ++this.depIdsOffloadedToDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": dependency ID offload to disk  did=" + did + " depIdsOffloadedToDisk=" + this.depIdsOffloadedToDisk), (Object[])new Object[0]);
        }
    }

    @Override
    public final void depIdBasedInvalidationsFromDisk(Object did) {
        ++this.depIdBasedInvalidationsFromDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": dependency ID based invalidation  did=" + did + " depIdBasedInvalidationsFromDisk=" + this.depIdBasedInvalidationsFromDisk), (Object[])new Object[0]);
        }
    }

    @Override
    public final void templatesOffloadedToDisk(Object template) {
        ++this.templatesOffloadedToDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": template offload to disk template=" + template + " templatesOffloadedToDisk=" + this.templatesOffloadedToDisk), (Object[])new Object[0]);
        }
    }

    @Override
    public final void templateBasedInvalidationsFromDisk(Object template) {
        ++this.templateBasedInvalidationsFromDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": template based invalidation  template=" + template + " templateBasedInvalidationsFromDisk=" + this.templateBasedInvalidationsFromDisk), (Object[])new Object[0]);
        }
    }

    @Override
    public final void remoteInvalidationNotifications(Object id) {
        ++this.remoteInvalidationNotifications;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": remote invalidation notification id=" + id + " remoteInvalidationNotifications=" + this.remoteInvalidationNotifications), (Object[])new Object[0]);
        }
    }

    @Override
    public final void remoteUpdateNotifications(Object id) {
        ++this.remoteUpdateNotifications;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": remote update notification id=" + id + " remoteUpdateNotifications=" + this.remoteUpdateNotifications), (Object[])new Object[0]);
        }
    }

    @Override
    public final void remoteUpdateNotifications(int numNotifications) {
        this.remoteUpdateNotifications += (long)numNotifications;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": remote update notification numNotifications=" + numNotifications + " remoteUpdateNotifications=" + this.remoteUpdateNotifications), (Object[])new Object[0]);
        }
    }

    @Override
    public final void remoteObjectUpdates(Object id, int valueSize) {
        ++this.remoteObjectUpdates;
        this.remoteObjectUpdateSize += (long)valueSize;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": remote object update id=" + id + " valueSize=" + valueSize + " remoteObjectUpdates=" + this.remoteObjectUpdates + " remoteObjectUpdateSize=" + this.remoteObjectUpdateSize), (Object[])new Object[0]);
        }
    }

    @Override
    public final void remoteObjectHits(Object id, int valueSize) {
        ++this.cacheHits;
        ++this.remoteObjectHits;
        this.remoteObjectFetchSize += (long)valueSize;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": remote object hit id=" + id + " valueSize=" + valueSize + " cacheHits=" + this.cacheHits + " remoteObjectHits=" + this.remoteObjectHits + " remoteObjectFetchSize=" + this.remoteObjectFetchSize), (Object[])new Object[0]);
        }
    }

    @Override
    public final void remoteObjectMisses(Object id) {
        ++this.cacheMisses;
        ++this.remoteObjectMisses;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": remote object miss id=" + id + " cacheMisses=" + this.cacheMisses + " remoteObjectMisses=" + this.remoteObjectMisses), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void readEntryFromDisk(Object id, int valueSize) {
        Object object = this.diskReadMonitor;
        synchronized (object) {
            ++this.objectsReadFromDisk;
            this.objectsReadFromDiskSize += (long)valueSize;
            if (valueSize <= 4000) {
                ++this.objectsReadFromDisk4K;
            } else if (valueSize <= 40000) {
                ++this.objectsReadFromDisk40K;
            } else if (valueSize <= 400000) {
                ++this.objectsReadFromDisk400K;
            } else if (valueSize <= 4000000) {
                ++this.objectsReadFromDisk4000K;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": read entry from disk id=" + id + " valueSize=" + valueSize + " objectsReadFromDisk=" + this.objectsReadFromDisk + " objectsReadFromDiskSize" + this.objectsReadFromDiskSize), (Object[])new Object[0]);
        }
    }

    @Override
    public final void writeEntryToDisk(Object id, int valueSize) {
        ++this.objectsWriteToDisk;
        this.objectsWriteToDiskSize += (long)valueSize;
        if (valueSize <= 4000) {
            ++this.objectsWriteToDisk4K;
        } else if (valueSize <= 40000) {
            ++this.objectsWriteToDisk40K;
        } else if (valueSize <= 400000) {
            ++this.objectsWriteToDisk400K;
        } else if (valueSize <= 4000000) {
            ++this.objectsWriteToDisk4000K;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": write entry to disk id=" + id + " valueSize=" + valueSize + " objectsWriteToDisk=" + this.objectsWriteToDisk + " objectsWriteToDiskSize=" + this.objectsWriteToDiskSize), (Object[])new Object[0]);
        }
    }

    @Override
    public final void deleteEntryFromDisk(Object id, int valueSize) {
        ++this.objectsDeleteFromDisk;
        this.objectsDeleteFromDiskSize += (long)valueSize;
        if (valueSize <= 4000) {
            ++this.objectsDeleteFromDisk4K;
        } else if (valueSize <= 40000) {
            ++this.objectsDeleteFromDisk40K;
        } else if (valueSize <= 400000) {
            ++this.objectsDeleteFromDisk400K;
        } else if (valueSize <= 4000000) {
            ++this.objectsDeleteFromDisk4000K;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": delete entry from disk id=" + id + " valueSize=" + valueSize + " objectsDeleteFromDisk=" + this.objectsDeleteFromDisk + " objectsDeleteFromDiskSize=" + this.objectsDeleteFromDiskSize), (Object[])new Object[0]);
        }
    }

    @Override
    public final void objectsAsyncLruToDisk() {
        ++this.objectsAsyncLruToDisk;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": objectsAsyncLruToDisk=" + this.objectsAsyncLruToDisk), (Object[])new Object[0]);
        }
    }

    @Override
    public final void overflowEntriesFromMemory() {
        ++this.overflowEntriesFromMemory;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.cacheName + ": overflowEntriesFromMemory=" + this.overflowEntriesFromMemory), (Object[])new Object[0]);
        }
    }

    @Override
    public final void reset() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cacheRemoves = 0L;
        this.cacheLruRemoves = 0L;
        this.overflowEntriesFromMemory = 0L;
        this.memoryCacheHits = 0L;
        this.diskCacheHits = 0L;
        this.explicitInvalidationsFromMemory = 0L;
        this.explicitInvalidationsFromDisk = 0L;
        this.explicitInvalidationsLocal = 0L;
        this.explicitInvalidationsRemote = 0L;
        this.timeoutInvalidationsFromMemory = 0L;
        this.timeoutInvalidationsFromDisk = 0L;
        this.garbageCollectorInvalidationsFromDisk = 0L;
        this.overflowInvalidationsFromDisk = 0L;
        this.depIdsOffloadedToDisk = 0L;
        this.depIdBasedInvalidationsFromDisk = 0L;
        this.templatesOffloadedToDisk = 0L;
        this.templateBasedInvalidationsFromDisk = 0L;
        this.objectsReadFromDisk = 0L;
        this.objectsReadFromDisk4K = 0L;
        this.objectsReadFromDisk40K = 0L;
        this.objectsReadFromDisk400K = 0L;
        this.objectsReadFromDisk4000K = 0L;
        this.objectsReadFromDiskSize = 0L;
        this.objectsWriteToDisk = 0L;
        this.objectsWriteToDisk4K = 0L;
        this.objectsWriteToDisk40K = 0L;
        this.objectsWriteToDisk400K = 0L;
        this.objectsWriteToDisk4000K = 0L;
        this.objectsWriteToDiskSize = 0L;
        this.objectsDeleteFromDisk = 0L;
        this.objectsDeleteFromDisk4K = 0L;
        this.objectsDeleteFromDisk40K = 0L;
        this.objectsDeleteFromDisk400K = 0L;
        this.objectsDeleteFromDisk4000K = 0L;
        this.objectsDeleteFromDiskSize = 0L;
        this.remoteInvalidationNotifications = 0L;
        this.remoteUpdateNotifications = 0L;
        this.remoteObjectUpdates = 0L;
        this.remoteObjectUpdateSize = 0L;
        this.remoteObjectHits = 0L;
        this.remoteObjectFetchSize = 0L;
        this.remoteObjectMisses = 0L;
        this.objectsAsyncLruToDisk = 0L;
    }

    @Override
    public final void resetMemory() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cacheRemoves = 0L;
        this.cacheLruRemoves = 0L;
        this.overflowEntriesFromMemory = 0L;
        this.memoryCacheHits = 0L;
        this.explicitInvalidationsFromMemory = 0L;
        this.explicitInvalidationsLocal = 0L;
        this.explicitInvalidationsRemote = 0L;
        this.timeoutInvalidationsFromMemory = 0L;
        this.remoteInvalidationNotifications = 0L;
        this.remoteUpdateNotifications = 0L;
        this.remoteObjectUpdates = 0L;
        this.remoteObjectUpdateSize = 0L;
        this.remoteObjectHits = 0L;
        this.remoteObjectFetchSize = 0L;
        this.remoteObjectMisses = 0L;
    }

    @Override
    public final void resetDisk() {
        this.diskCacheHits = 0L;
        this.explicitInvalidationsFromDisk = 0L;
        this.timeoutInvalidationsFromDisk = 0L;
        this.garbageCollectorInvalidationsFromDisk = 0L;
        this.overflowInvalidationsFromDisk = 0L;
        this.depIdsOffloadedToDisk = 0L;
        this.depIdBasedInvalidationsFromDisk = 0L;
        this.templatesOffloadedToDisk = 0L;
        this.templateBasedInvalidationsFromDisk = 0L;
        this.objectsReadFromDisk = 0L;
        this.objectsReadFromDisk4K = 0L;
        this.objectsReadFromDisk40K = 0L;
        this.objectsReadFromDisk400K = 0L;
        this.objectsReadFromDisk4000K = 0L;
        this.objectsReadFromDiskSize = 0L;
        this.objectsWriteToDisk = 0L;
        this.objectsWriteToDisk4K = 0L;
        this.objectsWriteToDisk40K = 0L;
        this.objectsWriteToDisk400K = 0L;
        this.objectsWriteToDisk4000K = 0L;
        this.objectsWriteToDiskSize = 0L;
        this.objectsDeleteFromDisk = 0L;
        this.objectsDeleteFromDisk4K = 0L;
        this.objectsDeleteFromDisk40K = 0L;
        this.objectsDeleteFromDisk400K = 0L;
        this.objectsDeleteFromDisk4000K = 0L;
        this.objectsDeleteFromDiskSize = 0L;
        this.objectsAsyncLruToDisk = 0L;
    }

    @Override
    public long getCacheHitsCount() {
        return this.cacheHits;
    }

    @Override
    public long getCacheLruRemovesCount() {
        return this.cacheLruRemoves;
    }

    @Override
    public long getCacheMissesCount() {
        return this.cacheMisses;
    }

    @Override
    public long getCacheRemovesCount() {
        return this.cacheRemoves;
    }

    @Override
    public long getDepIdBasedInvalidationsFromDiskCount() {
        return this.depIdBasedInvalidationsFromDisk;
    }

    @Override
    public long getDepIdsOffloadedToDiskCount() {
        return this.depIdsOffloadedToDisk;
    }

    @Override
    public long getDiskCacheHitsCount() {
        return this.diskCacheHits;
    }

    @Override
    public long getExplicitInvalidationsFromDiskCount() {
        return this.explicitInvalidationsFromDisk;
    }

    @Override
    public long getExplicitInvalidationsFromMemoryCount() {
        return this.explicitInvalidationsFromMemory;
    }

    @Override
    public long getExplicitInvalidationsLocalCount() {
        return this.explicitInvalidationsLocal;
    }

    @Override
    public long getExplicitInvalidationsRemoteCount() {
        return this.explicitInvalidationsRemote;
    }

    @Override
    public long getGarbageCollectorInvalidationsFromDiskCount() {
        return this.garbageCollectorInvalidationsFromDisk;
    }

    @Override
    public long getMemoryCacheHitsCount() {
        return this.memoryCacheHits;
    }

    @Override
    public long getObjectsAsyncLruToDiskCount() {
        return this.objectsAsyncLruToDisk;
    }

    @Override
    public long getObjectsDeleteFromDiskCount() {
        return this.objectsDeleteFromDisk;
    }

    @Override
    public long getObjectsDeleteFromDisk4000KCount() {
        return this.objectsDeleteFromDisk4000K;
    }

    @Override
    public long getObjectsDeleteFromDisk400KCount() {
        return this.objectsDeleteFromDisk400K;
    }

    @Override
    public long getObjectsDeleteFromDisk40KCount() {
        return this.objectsDeleteFromDisk40K;
    }

    @Override
    public long getObjectsDeleteFromDisk4KCount() {
        return this.objectsDeleteFromDisk4K;
    }

    @Override
    public long getObjectsDeleteFromDiskSizeCount() {
        return this.objectsDeleteFromDiskSize;
    }

    @Override
    public long getObjectsReadFromDiskCount() {
        return this.objectsReadFromDisk;
    }

    @Override
    public long getObjectsReadFromDisk4000KCount() {
        return this.objectsReadFromDisk4000K;
    }

    @Override
    public long getObjectsReadFromDisk400KCount() {
        return this.objectsReadFromDisk400K;
    }

    @Override
    public long getObjectsReadFromDisk40KCount() {
        return this.objectsReadFromDisk40K;
    }

    @Override
    public long getObjectsReadFromDisk4KCount() {
        return this.objectsReadFromDisk4K;
    }

    @Override
    public long getObjectsReadFromDiskSizeCount() {
        return this.objectsReadFromDiskSize;
    }

    @Override
    public long getObjectsWriteToDiskCount() {
        return this.objectsWriteToDisk;
    }

    @Override
    public long getObjectsWriteToDisk4000KCount() {
        return this.objectsWriteToDisk4000K;
    }

    @Override
    public long getObjectsWriteToDisk400KCount() {
        return this.objectsWriteToDisk400K;
    }

    @Override
    public long getObjectsWriteToDisk40KCount() {
        return this.objectsWriteToDisk40K;
    }

    @Override
    public long getObjectsWriteToDisk4KCount() {
        return this.objectsWriteToDisk4K;
    }

    @Override
    public long getObjectsWriteToDiskSizeCount() {
        return this.objectsWriteToDiskSize;
    }

    @Override
    public long getOverflowEntriesFromMemoryCount() {
        return this.overflowEntriesFromMemory;
    }

    @Override
    public long getOverflowInvalidationsFromDiskCount() {
        return this.overflowInvalidationsFromDisk;
    }

    @Override
    public long getRemoteInvalidationNotificationsCount() {
        return this.remoteInvalidationNotifications;
    }

    @Override
    public long getRemoteObjectFetchSizeCount() {
        return this.remoteObjectFetchSize;
    }

    @Override
    public long getRemoteObjectHitsCount() {
        return this.remoteObjectHits;
    }

    @Override
    public long getRemoteObjectMissesCount() {
        return this.remoteObjectMisses;
    }

    @Override
    public long getRemoteObjectUpdatesCount() {
        return this.remoteObjectUpdates;
    }

    @Override
    public long getRemoteObjectUpdateSizeCount() {
        return this.remoteObjectUpdateSize;
    }

    @Override
    public long getRemoteUpdateNotificationsCount() {
        return this.remoteUpdateNotifications;
    }

    @Override
    public long getTemplateBasedInvalidationsFromDiskCount() {
        return this.templateBasedInvalidationsFromDisk;
    }

    @Override
    public long getTemplatesOffloadedToDiskCount() {
        return this.templatesOffloadedToDisk;
    }

    @Override
    public long getTimeoutInvalidationsFromDiskCount() {
        return this.timeoutInvalidationsFromDisk;
    }

    @Override
    public long getTimeoutInvalidationsFromMemoryCount() {
        return this.timeoutInvalidationsFromMemory;
    }
}

