/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl.ute;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.service.JmsServiceFacade;
import com.ibm.ws.sib.api.jms.ute.UTEHelper;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;

public class UTEHelperImpl
implements UTEHelper {
    private static TraceComponent tcInt = Tr.register(UTEHelperImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private Administrator admin = null;
    private SICoreConnection coreConnection = null;

    @Override
    public SICoreConnectionFactory setupJmsTestEnvironment() {
        return this.setupJmsTestEnvironment(true);
    }

    @Override
    public void createDestination(DestinationDefinition dd) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tcInt, (String)"createDestination(DestinationDefinition)");
        }
        try {
            Reliability maxRel;
            Reliability defRel = dd.getDefaultReliability();
            if (defRel == null) {
                dd.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
            }
            if ((maxRel = dd.getMaxReliability()) == null) {
                dd.setMaxReliability(Reliability.ASSURED_PERSISTENT);
            }
            LocalizationDefinition dloc = null;
            this.admin.createDestinationLocalization(dd, dloc);
        }
        catch (Exception e) {
            if (tcInt.isEntryEnabled()) {
                SibTr.debug((TraceComponent)tcInt, (String)"Exception creating Destination Localisation", (Object)e);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tcInt, (String)"createDestination(DestinationDefinition)");
            }
            throw new RuntimeException("Unable to create Destination Localization", e);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tcInt, (String)"createDestination(DestinationDefinition)");
        }
    }

    @Override
    public void createDestination(Destination dest) throws JMSException {
        this.createDestination(dest, Reliability.ASSURED_PERSISTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDestination(Destination dest, Reliability defaultReliability) throws JMSException {
        block16: {
            try {
                if (tcInt.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tcInt, (String)"createDestination(Destination)");
                }
                DestinationType destType = null;
                String name = null;
                try {
                    if (dest instanceof JmsQueue) {
                        destType = DestinationType.QUEUE;
                        name = ((JmsQueue)dest).getQueueName();
                    } else if (dest instanceof JmsTopic) {
                        destType = DestinationType.TOPICSPACE;
                        name = ((JmsTopic)dest).getTopicSpace();
                    } else {
                        destType = null;
                        name = null;
                    }
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tcInt, (String)("    name: " + name));
                        SibTr.debug((TraceComponent)tcInt, (String)("destType: " + destType));
                    }
                    if (destType != null) {
                        this.createDestination(name, destType, defaultReliability);
                        break block16;
                    }
                    throw new JMSException("Could not create Destination - destType was null");
                }
                catch (JMSException e) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tcInt, (String)"JMSException during createDestination", (Object)((Object)e));
                    }
                    throw e;
                }
                catch (Exception f) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tcInt, (String)"Exception during createDestionation", (Object)f);
                    }
                    JMSException jmse = new JMSException("Exception from createDestination");
                    jmse.setLinkedException(f);
                    jmse.initCause((Throwable)f);
                    throw jmse;
                }
            }
            finally {
                if (tcInt.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tcInt, (String)"createDestination(Destination)");
                }
            }
        }
    }

    @Override
    public void deleteDestination(Destination dest) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tcInt, (String)"deleteDestination(Destination)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tcInt, (String)("dest: " + dest));
        }
        String name = ((JmsDestinationImpl)dest).getDestName();
        try {
            SIDestinationAddress sida = JmsServiceFacade.getSIDestinationAddressFactory().createSIDestinationAddress(name, null);
            DestinationConfiguration dc = this.coreConnection.getDestinationConfiguration(sida);
            if (dc != null) {
                String uuid = dc.getUUID();
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tcInt, (String)("delete name: " + name));
                }
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tcInt, (String)("delete UUID: " + uuid));
                }
                this.admin.deleteDestinationLocalization(uuid, null);
            } else if (tcInt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tcInt, (String)"No object was returned from getDestinationConfiguration");
            }
        }
        catch (SINotPossibleInCurrentConfigurationException f) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tcInt, (String)("Destination does not exist: " + name), (Object)((Object)f));
            }
        }
        catch (Exception e) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tcInt, (String)"Exception deleting", (Object)e);
            }
            JMSException jmse = new JMSException("Exception received while deleting");
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            if (tcInt.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tcInt, (String)"deleteDestination(Destination)");
            }
            throw jmse;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tcInt, (String)"deleteDestination(Destination)");
        }
    }

    public void enableDestinationCreation(SICoreConnectionFactory siccf) {
        block7: {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tcInt, (String)"enableDestinationCreation");
            }
            try {
                if (this.admin == null) {
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tcInt, (String)"Setting up destination definition objects.");
                    }
                    this.admin = ((SIMPAdmin)siccf).getAdministrator();
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tcInt, (String)"DestinationDefinition objects complete");
                    }
                }
            }
            catch (Exception e) {
                if (!tcInt.isDebugEnabled()) break block7;
                SibTr.debug((TraceComponent)tcInt, (String)"Exception enabling destination creation", (Object)e);
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tcInt, (String)"enableDestinationCreation");
        }
    }

    private void createDestination(String name, DestinationType destType, Reliability defaultReliability) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tcInt, (String)"createDestination(String, DestinationType)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tcInt, (String)("name: " + name));
            SibTr.debug((TraceComponent)tcInt, (String)("type: " + destType));
        }
        try {
            try {
                SIDestinationAddress sida = JmsServiceFacade.getSIDestinationAddressFactory().createSIDestinationAddress(name, null);
                DestinationConfiguration dc = this.coreConnection.getDestinationConfiguration(sida);
                if (dc != null) {
                    String uuid = dc.getUUID();
                    if (tcInt.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tcInt, (String)("delete UUID: " + uuid));
                    }
                    this.admin.deleteDestinationLocalization(uuid, null);
                } else if (tcInt.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tcInt, (String)"No object was returned from getDestinationConfiguration");
                }
            }
            catch (SINotPossibleInCurrentConfigurationException sida) {
                // empty catch block
            }
            DestinationDefinition adminDDF = null;
            adminDDF.setMaxReliability(Reliability.ASSURED_PERSISTENT);
            adminDDF.setDefaultReliability(defaultReliability);
            String excDestinationName = "_SYSTEM.Exception.Destination." + this.getMEName();
            adminDDF.setExceptionDestination(excDestinationName);
            LocalizationDefinition dloc = null;
            dloc.setDestinationHighMsgs(30000L);
            this.admin.createDestinationLocalization(adminDDF, dloc);
        }
        catch (Exception se) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tcInt, (String)"Exception creating", (Object)se);
            }
            JMSException jmse = new JMSException("Exception received creating destination");
            jmse.setLinkedException(se);
            jmse.initCause((Throwable)se);
            if (tcInt.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tcInt, (String)"createDestination(String, DestinationDefinition)");
            }
            throw jmse;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tcInt, (String)"createDestination(String, DestinationDefinition)");
        }
    }

    @Override
    public String getMEName() {
        return null;
    }

    @Override
    public SICoreConnectionFactory setupJmsTestEnvironment(boolean coldStart) {
        return null;
    }

    @Override
    public void stopME() {
    }
}

