/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.jandex.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.jandex.internal.SparseIndex;
import com.ibm.ws.annocache.jandex.internal.SparseIndexReader;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Jandex_Utils {
    static final long serialVersionUID = 7786824230471416122L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Indexer createIndexer() {
        return new Indexer();
    }

    public static void updateIndexer(Indexer outputIndexer, String classPath, InputStream classInputStream) throws IOException {
        outputIndexer.index(classInputStream);
    }

    public static Index completeIndexer(Indexer indexer) {
        return indexer.complete();
    }

    public static Index basicReadIndex(String indexPath) throws IOException {
        File indexFile = new File(indexPath);
        byte[] indexBytes = UtilImpl_FileUtils.readFully(indexFile);
        ByteArrayInputStream indexInput = new ByteArrayInputStream(indexBytes);
        return Jandex_Utils.basicReadIndex(indexInput);
    }

    public static Index basicReadIndex(InputStream indexInputStream) throws IOException {
        IndexReader reader = new IndexReader(indexInputStream);
        return reader.read();
    }

    public static SparseIndex basicReadSparseIndex(String indexPath) throws IOException {
        File indexFile = new File(indexPath);
        byte[] indexBytes = UtilImpl_FileUtils.readFully(indexFile);
        ByteArrayInputStream indexInput = new ByteArrayInputStream(indexBytes);
        return Jandex_Utils.basicReadSparseIndex(indexInput);
    }

    public static SparseIndex basicReadSparseIndex(InputStream indexInputStream) throws IOException {
        SparseIndexReader reader = new SparseIndexReader(indexInputStream);
        return reader.getIndex();
    }

    public static void writeIndex(String indexOutputPath, Index index) {
        try {
            Jandex_Utils.basicWriteIndex(indexOutputPath, index);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.jandex.internal.Jandex_Utils", (String)"93", null, (Object[])new Object[]{indexOutputPath, index});
            throw new RuntimeException("Failed to write index [ " + indexOutputPath + " ]");
        }
    }

    public static void basicWriteIndex(String indexOutputPath, Index index) throws IOException {
        try (FileOutputStream indexOutputStream = new FileOutputStream(indexOutputPath);){
            Jandex_Utils.basicWriteIndex(indexOutputStream, index, "Write [ " + indexOutputPath + " ]");
        }
    }

    public static void basicWriteIndex(OutputStream indexOutputStream, Index index, String writeCase) throws IOException {
        IndexWriter indexWriter = new IndexWriter(indexOutputStream);
        indexWriter.write(index);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Index createIndex(String archiveSourcePath) {
        FileInputStream pathInputStream;
        File pathFile = new File(archiveSourcePath);
        if (!pathFile.exists()) {
            throw new IllegalArgumentException("Target [ " + archiveSourcePath + " ] does not exist");
        }
        if (pathFile.isDirectory()) {
            throw new IllegalArgumentException("Target [ " + archiveSourcePath + " ] is a directory");
        }
        Indexer indexer = Jandex_Utils.createIndexer();
        try {
            pathInputStream = new FileInputStream(archiveSourcePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            void e;
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.annocache.jandex.internal.Jandex_Utils", (String)"131", null, (Object[])new Object[]{archiveSourcePath});
            throw new RuntimeException("Failed to open [ " + archiveSourcePath + " ]", (Throwable)e);
        }
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream2332 = new ZipInputStream(pathInputStream);
            while ((zipEntry = zipInputStream2332.getNextEntry()) != null) {
                String zipEntryName;
                if (zipEntry.isDirectory() || !(zipEntryName = zipEntry.getName()).endsWith(".class")) continue;
                Jandex_Utils.updateIndexer(indexer, zipEntry.getName(), zipInputStream2332);
            }
        }
        catch (IOException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.annocache.jandex.internal.Jandex_Utils", (String)"153", null, (Object[])new Object[]{archiveSourcePath});
                throw new RuntimeException("Failed to process [ " + archiveSourcePath + " ]", e);
            }
            catch (Throwable throwable) {
                try {
                    pathInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    void e2;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.jandex.internal.Jandex_Utils", (String)"159", null, (Object[])new Object[]{archiveSourcePath});
                    throw new RuntimeException("Failed to open [ " + archiveSourcePath + " ]", (Throwable)e2);
                }
            }
        }
        try {
            pathInputStream.close();
            return Jandex_Utils.completeIndexer(indexer);
        }
        catch (IOException zipInputStream2332) {
            FFDCFilter.processException((Throwable)zipInputStream2332, (String)"com.ibm.ws.annocache.jandex.internal.Jandex_Utils", (String)"159", null, (Object[])new Object[]{archiveSourcePath});
            throw new RuntimeException("Failed to open [ " + archiveSourcePath + " ]", (Throwable)e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.jandex.internal.Jandex_Utils", Jandex_Utils.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }
}

