/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.cache.CacheEntry;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.ExternalInvalidation;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentComposerMemento;
import com.ibm.ws.cache.web.ExternalCacheFragment;
import com.ibm.ws.cache.web.ExternalCacheServices;

public class JSPCache
implements com.ibm.ws.cache.intf.JSPCache {
    private DCache cache = null;
    private RemoteServices remoteServices = null;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private ExternalCacheServices externalCacheServices = null;
    private int defaultPriority = CacheConfig.DEFAULT_PRIORITY;
    private static TraceComponent tc = Tr.register(JSPCache.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");

    public void setCache(DCache cache) {
        this.cache = cache;
    }

    public void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        this.batchUpdateDaemon = batchUpdateDaemon;
    }

    public void setRemoteServices(RemoteServices remoteServices) {
        this.remoteServices = remoteServices;
    }

    public void setExternalCacheServices(com.ibm.ws.cache.intf.ExternalCacheServices externalCacheServices) {
        this.externalCacheServices = (ExternalCacheServices)externalCacheServices;
    }

    public void setDefaultPriority(int defaultPriority) {
        if (defaultPriority < 0) {
            throw new IllegalArgumentException("defaultPriority must be nonnegative");
        }
        this.defaultPriority = defaultPriority;
    }

    public void start() {
        if (this.cache == null || this.batchUpdateDaemon == null || this.remoteServices == null) {
            throw new IllegalStateException("cache, batchUpdateDaemon, and remoteServices must all be set before start()");
        }
    }

    public void setExternalCacheFragment(String id, ExternalCacheFragment externalCacheFragment) {
        this.remoteServices.setExternalCacheFragment(id, (ExternalInvalidation)externalCacheFragment);
    }

    public void setValue(EntryInfo entryInfo, FragmentComposerMemento memento, ExternalCacheFragment externalCacheFragment) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setValue", (Object[])new Object[0]);
        }
        memento.setExternalCacheFragment(externalCacheFragment);
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        this.cache.setValue(entryInfo, (Object)memento, false);
        if (externalCacheFragment != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding ECF to BatchUpdateDaemon", (Object[])new Object[0]);
            }
            this.batchUpdateDaemon.pushExternalCacheFragment((ExternalInvalidation)externalCacheFragment, this.cache);
        }
        memento.setExternalCacheFragment(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setValue");
        }
    }

    public void setValidatorExpirationTime(EntryInfo entryInfo, FragmentComposerMemento memento) {
        this.cache.setValue(entryInfo, (Object)memento, true);
    }

    public void updateStatisticsForVBC(CacheEntry cacheEntry, boolean directive) {
        this.cache.updateStatisticsForVBC(cacheEntry, directive);
    }

    public CacheEntry getEntry(String id) {
        CacheEntry ce = this.cache.getEntry(id);
        if (ce != null) {
            if (ce.getId() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getEntry(String): ce.getId is null, returning null.", (Object[])new Object[0]);
                }
                ce = null;
            } else if (!ce.getId().equals(id)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getEntry(String): ce.getId:" + ce.getId() + " does not equal id:" + id + ", returning null."), (Object[])new Object[0]);
                }
                ce = null;
            }
        }
        return ce;
    }

    public CacheEntry getEntry(EntryInfo entryInfo) {
        CacheEntry ce = this.cache.getEntry((com.ibm.websphere.cache.EntryInfo)entryInfo);
        this.validationCheck(entryInfo, ce);
        return ce;
    }

    public CacheEntry getEntry(EntryInfo ei, boolean ignoreCounting) {
        CacheEntry ce = this.cache.getEntry((com.ibm.websphere.cache.EntryInfo)ei, true, ignoreCounting);
        this.validationCheck(ei, ce);
        return ce;
    }

    private void validationCheck(EntryInfo entryInfo, CacheEntry ce) {
        if (ce != null) {
            if (ce.getId() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getEntry(EntryInfo): ce.getId is null, returning null.", (Object[])new Object[0]);
                }
                ce = null;
            } else if (!ce.getId().equals(entryInfo.getId())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getEntry(EntryInfo): ce.getId:" + ce.getId() + " does not equal entryInfo.getId:" + entryInfo.getId() + ", returning null."), (Object[])new Object[0]);
                }
                ce = null;
            }
        }
    }

    public boolean isValid(String id) {
        return this.cache.isValid(id);
    }

    public Object getValue(EntryInfo entryInfo, boolean askPermission) {
        return this.cache.getValue((com.ibm.websphere.cache.EntryInfo)entryInfo, askPermission);
    }

    public void invalidateById(String id, boolean waitOnInvalidation) {
        this.cache.invalidateById(id, waitOnInvalidation);
    }

    public void invalidateByTemplate(String template, boolean waitOnInvalidation) {
        this.cache.invalidateByTemplate(template, waitOnInvalidation);
    }

    public boolean shouldPull(int share, String id) {
        return this.cache.shouldPull(share, (Object)id);
    }

    public void preInvoke(String cacheGroup, CacheProxyRequest request, CacheProxyResponse response) {
        this.externalCacheServices.preInvoke(cacheGroup, request, response);
    }

    public void postInvoke(String cacheGroup, CacheProxyRequest request, CacheProxyResponse response) {
        this.externalCacheServices.postInvoke(cacheGroup, request, response);
    }

    public boolean isCascadeCachespecProperties() {
        return this.cache.getCacheConfig().isCascadeCachespecProperties();
    }

    public boolean isAutoFlushIncludes() {
        return this.cache.getCacheConfig().isAutoFlushIncludes();
    }

    public boolean alwaysSetSurrogateControlHdr() {
        return this.cache.getCacheConfig().alwaysSetSurrogateControlHdr();
    }

    public int[] getFilteredStatusCodes() {
        return this.cache.getCacheConfig().getFilteredStatusCodes();
    }

    public DCache getCache() {
        return this.cache;
    }
}

