/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.smallrye.metrics.adapters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics50.helper.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricRegistry;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SRSharedMetricRegistriesAdapter {
    private static final TraceComponent tc = Tr.register(SRSharedMetricRegistriesAdapter.class, null, null);
    private static SRSharedMetricRegistriesAdapter instance;
    private static Method getOrCreateMethod;
    private static Method getOrCreateMethodAppNameResolver;
    private static Method setAppNameResolverMethod;
    private static Method getRegistryScopeNamesMethod;
    private final Class<?> srSharedMetricRegistryClass = Util.SR_SHARED_METRIC_REGISTRIES_CLASS;
    static final long serialVersionUID = 3066501568025555351L;

    private SRSharedMetricRegistriesAdapter() {
        if (this.srSharedMetricRegistryClass == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The SmallRye SharedMetricRegistries class was not resolved.", (Object[])new Object[0]);
            }
        } else {
            try {
                getOrCreateMethod = this.srSharedMetricRegistryClass.getMethod("getOrCreate", String.class);
                getOrCreateMethodAppNameResolver = this.srSharedMetricRegistryClass.getMethod("getOrCreate", String.class, Util.SR_APPLICATION_NAME_RESOLVER_INTERFACE);
                setAppNameResolverMethod = this.srSharedMetricRegistryClass.getMethod("setAppNameResolver", Util.SR_APPLICATION_NAME_RESOLVER_INTERFACE);
                getRegistryScopeNamesMethod = this.srSharedMetricRegistryClass.getMethod("getRegistryScopeNames", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.adapters.SRSharedMetricRegistriesAdapter", (String)"59", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    public Set<String> getRegistryScopeNames() {
        if (this.srSharedMetricRegistryClass == null || getRegistryScopeNamesMethod == null) {
            if (getRegistryScopeNamesMethod == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to load by reflection the expected SharedMetricRegistries.getRegistryScopeNames() method", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            return (Set)getRegistryScopeNamesMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.adapters.SRSharedMetricRegistriesAdapter", (String)"81", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public static synchronized SRSharedMetricRegistriesAdapter getInstance() {
        if (instance == null) {
            instance = new SRSharedMetricRegistriesAdapter();
        }
        return instance;
    }

    public MetricRegistry getOrCreate(String scope) {
        if (this.srSharedMetricRegistryClass == null || getOrCreateMethod == null) {
            if (getOrCreateMethod == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to load by reflection the expected SharedMetricRegistries.getOrCreate(String) method", (Object[])new Object[0]);
            }
            return null;
        }
        MetricRegistry metricRegistry = null;
        try {
            Object metricRegistryObject = getOrCreateMethod.invoke(null, scope);
            if (metricRegistryObject != null) {
                metricRegistry = (MetricRegistry)metricRegistryObject;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to retrieve MetricRegistry for scope " + scope), (Object[])new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.adapters.SRSharedMetricRegistriesAdapter", (String)"127", (Object)this, (Object[])new Object[]{scope});
        }
        return metricRegistry;
    }

    public void setAppNameResolver(Object o) {
        if ((this.srSharedMetricRegistryClass == null || setAppNameResolverMethod == null) && setAppNameResolverMethod == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unable to load by reflection the expected SharedMetricRegistries.setAppNameResolver(AppNameResolver) method", (Object[])new Object[0]);
        }
        try {
            setAppNameResolverMethod.invoke(null, Util.SR_APPLICATION_NAME_RESOLVER_INTERFACE.cast(o));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.adapters.SRSharedMetricRegistriesAdapter", (String)"156", (Object)this, (Object[])new Object[]{o});
        }
    }

    public MetricRegistry getOrCreate(String scope, Object o) {
        if (this.srSharedMetricRegistryClass == null || getOrCreateMethodAppNameResolver == null) {
            if (getOrCreateMethodAppNameResolver == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to load by reflection the expected SharedMetricRegistries.getOrCreate(String, AppNameResolver) method", (Object[])new Object[0]);
            }
            return null;
        }
        MetricRegistry metricRegistry = null;
        try {
            Object metricRegistryObject = getOrCreateMethodAppNameResolver.invoke(null, scope, Util.SR_APPLICATION_NAME_RESOLVER_INTERFACE.cast(o));
            if (metricRegistryObject != null) {
                metricRegistry = (MetricRegistry)metricRegistryObject;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to retrieve MetricRegistry for scope " + scope), (Object[])new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.adapters.SRSharedMetricRegistriesAdapter", (String)"199", (Object)this, (Object[])new Object[]{scope, o});
        }
        return metricRegistry;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        getOrCreateMethod = null;
        getOrCreateMethodAppNameResolver = null;
        setAppNameResolverMethod = null;
        getRegistryScopeNamesMethod = null;
    }
}

