/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.servlet.CacheHook;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentComposer;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import java.io.IOException;

public class Servlet30AsyncListener
implements AsyncListener {
    private static TraceComponent tc = Tr.register(Servlet30AsyncListener.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");

    public void onStartAsync(AsyncEvent event) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.hashCode() + " onStartAsync"), (Object[])new Object[]{event});
        }
        CacheProxyRequest request = this.getCacheProxyRequest(event);
        CacheProxyResponse response = this.getCacheProxyResponse(event);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.hashCode() + " request=" + request + " response= " + response), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(this.hashCode() + " FC=" + request.getFragmentComposer()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.hashCode() + " onStartAsync"));
        }
    }

    public void onComplete(AsyncEvent event) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.hashCode() + " onComplete"), (Object[])new Object[]{event});
        }
        this.postProcessResponse(event, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.hashCode() + " onComplete"));
        }
    }

    public void onError(AsyncEvent event) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.hashCode() + " onError"), (Object[])new Object[]{event});
        }
        this.postProcessResponse(event, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.hashCode() + " onError"));
        }
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.hashCode() + " onTimeout"), (Object[])new Object[]{event});
        }
        this.postProcessResponse(event, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.hashCode() + " onTimeout"));
        }
    }

    public void postProcessResponse(AsyncEvent event, boolean errorOrTimeout) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.hashCode() + " postProcessResponse"), (Object[])new Object[]{errorOrTimeout});
        }
        CacheProxyRequest request = this.getCacheProxyRequest(event);
        CacheProxyResponse response = this.getCacheProxyResponse(event);
        FragmentComposer fc = request.getFragmentComposer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.hashCode() + " request=" + request + "  fc=" + fc), (Object[])new Object[0]);
        }
        if (errorOrTimeout) {
            fc.setCacheType(0);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.hashCode() + " fc should NOT be cached setting cacheType to NOT_CACHED"), (Object[])new Object[0]);
            }
        }
        if (null != fc && fc.isAsyncDispatch()) {
            if (!errorOrTimeout && fc.shouldCacheOutput()) {
                CacheHook.putInCache(fc);
            }
            CacheHook.postProcess(request, response, fc, request.getCaching(), errorOrTimeout);
            if (!errorOrTimeout) {
                request.reset();
                response.finished();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.hashCode() + " postProcessResponse"));
        }
    }

    private CacheProxyRequest getCacheProxyRequest(AsyncEvent event) {
        return (CacheProxyRequest)event.getSuppliedRequest();
    }

    private CacheProxyResponse getCacheProxyResponse(AsyncEvent event) {
        return (CacheProxyResponse)event.getSuppliedResponse();
    }
}

