/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;

public class LocalTransactionProxy
extends Transaction
implements SIUncoordinatedTransaction {
    private static final TraceComponent tc = SibTr.register(LocalTransactionProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private boolean valid = true;

    public LocalTransactionProxy(Conversation con, ConnectionProxy cp) {
        super(con, cp);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public synchronized void commit() throws SIIncorrectCallException, SIRollbackException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commit");
        }
        if (!this.valid) {
            throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
        }
        this.valid = false;
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putInt(this.getTransactionId());
        CommsByteBuffer reply = null;
        try {
            reply = this.jfapExchange(request, 81, this.lowestPriority, true);
            short err = reply.getCommandCompletionCode(209);
            if (err != 0) {
                this.checkFor_SIIncorrectCallException(reply, err);
                this.checkFor_SIRollbackException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
        }
        catch (SIConnectionDroppedException e) {
            throw new SIConnectionLostException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reply != null) {
                reply.release();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws SIIncorrectCallException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback");
        }
        if (!this.valid) {
            throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1022", null, null));
        }
        this.valid = false;
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putInt(this.getTransactionId());
        CommsByteBuffer reply = null;
        try {
            reply = this.jfapExchange(request, 82, this.lowestPriority, true);
            this.informConsumersOfRollback();
            short err = reply.getCommandCompletionCode(210);
            if (err != 0) {
                this.checkFor_SIIncorrectCallException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
        }
        catch (SIConnectionDroppedException e) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection failure during rollback.");
            }
        }
        finally {
            if (reply != null) {
                reply.release();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    @Override
    public synchronized boolean isValid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isValid");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isValid", (Object)("" + this.valid));
        }
        return this.valid;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/LocalTransactionProxy.java, SIB.comms, WASX.SIB, uu1215.01 1.40");
        }
    }
}

