/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.SibRaMessagingEngineListener;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaResourceAdapterImpl;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.IllegalStateException;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

final class SibRaStaticDestinationEndpointActivation
extends SibRaEndpointActivation {
    private static final Random _random = new Random();
    private SibRaMessagingEngineConnection _remoteConnection;
    private boolean _remoteDestination;
    private boolean _remoteMessagingEngine;
    private Timer _timer;
    private int RETRY_INTERVAL = 30000;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaStaticDestinationEndpointActivation.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaStaticDestinationEndpointActivation.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";

    SibRaStaticDestinationEndpointActivation(SibRaResourceAdapterImpl resourceAdapter, MessageEndpointFactory messageEndpointFactory, SibRaEndpointConfiguration endpointConfiguration, SibRaEndpointInvoker endpointInvoker) throws ResourceException {
        super(resourceAdapter, messageEndpointFactory, endpointConfiguration, endpointInvoker);
        String methodName = "SibRaStaticDestinationEndpointActivation";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaStaticDestinationEndpointActivation", (Object)new Object[]{resourceAdapter, messageEndpointFactory, endpointConfiguration, endpointInvoker});
        }
        this._timer = resourceAdapter.getBootstrapContext().createTimer();
        JsMessagingEngine[] localMessagingEngines = SibRaEngineComponent.getMessagingEngines((String)this._endpointConfiguration.getBusName());
        if (0 == localMessagingEngines.length) {
            this._remoteDestination = true;
            this._remoteMessagingEngine = true;
            this.createRemoteListener(true);
        } else {
            JsMessagingEngine[] activeMessagingEngines = SibRaEngineComponent.registerMessagingEngineListener((SibRaMessagingEngineListener)this, (String)this._endpointConfiguration.getBusName());
            for (int i = 0; i < activeMessagingEngines.length; ++i) {
                JsMessagingEngine messagingEngine = activeMessagingEngines[i];
                if (!this.isListenerRequired(messagingEngine)) continue;
                this.createListener(messagingEngine);
            }
            if (this._connections.size() == 0) {
                SibTr.warning((TraceComponent)TRACE, (String)"NO_ACTIVE_MES_CWSIV0759", (Object)new Object[]{this._endpointConfiguration.getBusName()});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"SibRaStaticDestinationEndpointActivation");
        }
    }

    @Override
    protected synchronized void addMessagingEngine(JsMessagingEngine messagingEngine) throws ResourceException {
        String methodName = "addMessagingEngine";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine", (Object)messagingEngine);
        }
        if (this.isListenerRequired(messagingEngine)) {
            this.createListener(messagingEngine);
            SibTr.info((TraceComponent)TRACE, (String)"NEW_CONSUMER_CWSIV0764", (Object)new Object[]{this._endpointConfiguration.getBusName(), messagingEngine.getName(), this._endpointConfiguration.getDestination().getDestinationName()});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deactivate() {
        String methodName = "deactivate";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
        super.deactivate();
        SibRaStaticDestinationEndpointActivation sibRaStaticDestinationEndpointActivation = this;
        synchronized (sibRaStaticDestinationEndpointActivation) {
            if (this._remoteConnection != null) {
                this._remoteConnection.close();
            }
        }
        this._timer.cancel();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
    }

    private boolean isListenerRequired(JsMessagingEngine messagingEngine) throws ResourceException {
        String methodName = "isListenerRequired";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"isListenerRequired", (Object)messagingEngine);
        }
        boolean listenerRequired = false;
        Set requiredMessagingEngines = this.getRequiredMessagingEngines(messagingEngine);
        if (requiredMessagingEngines.size() > 0) {
            if (requiredMessagingEngines.contains(messagingEngine.getUuid().toString())) {
                listenerRequired = true;
            }
        } else if (this._connections.size() == 0) {
            listenerRequired = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"isListenerRequired", (Object)listenerRequired);
        }
        return listenerRequired;
    }

    private static String validateDestination(JsMessagingEngine messagingEngine, String busName, String destinationName, DestinationType destinationType) throws NotSupportedException, ResourceAdapterInternalException {
        String uuid;
        block11: {
            String methodName = "validateDestination";
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((TraceComponent)TRACE, (String)"validateDestination", (Object)new Object[]{messagingEngine, busName, destinationName, destinationType});
            }
            String resolvedBusName = busName == null || "".equals(busName) ? messagingEngine.getBusName() : busName;
            try {
                BaseDestinationDefinition destinationDefinition = messagingEngine.getSIBDestination(busName, destinationName);
                if (destinationDefinition.isForeign()) {
                    throw new NotSupportedException(NLS.getFormattedMessage("FOREIGN_DESTINATION_CWSIV0754", new Object[]{destinationName, resolvedBusName}, null));
                }
                if (destinationDefinition.isLocal()) {
                    DestinationDefinition localDefinition = (DestinationDefinition)destinationDefinition;
                    if (destinationType.equals(localDefinition.getDestinationType())) {
                        uuid = destinationDefinition.getUUID().toString();
                        break block11;
                    }
                    throw new NotSupportedException(NLS.getFormattedMessage("INCORRECT_TYPE_CWSIV0755", new Object[]{destinationName, resolvedBusName, destinationType, localDefinition.getDestinationType()}, null));
                }
                if (destinationDefinition.isAlias()) {
                    DestinationAliasDefinition aliasDefinition = (DestinationAliasDefinition)destinationDefinition;
                    uuid = SibRaStaticDestinationEndpointActivation.validateDestination(messagingEngine, aliasDefinition.getTargetBus(), aliasDefinition.getTargetName(), destinationType);
                    break block11;
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNKNOWN_TYPE_CWSIV0756", new Object[]{destinationName, resolvedBusName}, null));
            }
            catch (SIBExceptionDestinationNotFound exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "validateDestination"), (String)FFDC_PROBE_1);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new NotSupportedException(NLS.getFormattedMessage("NOT_FOUND_CWSIV0757", new Object[]{destinationName, resolvedBusName}, null), (Throwable)exception);
            }
            catch (SIBExceptionBase exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "validateDestination"), (String)FFDC_PROBE_2);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIV0758", new Object[]{destinationName, resolvedBusName, exception}, null), (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"validateDestination", (Object)uuid);
        }
        return uuid;
    }

    private Set getRequiredMessagingEngines(JsMessagingEngine messagingEngine) throws NotSupportedException, ResourceAdapterInternalException {
        String methodName = "getRequiredMessagingEngines";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getRequiredMessagingEngines");
        }
        HashSet<String> requiredMessagingEngines = new HashSet<String>();
        JsMessagingEngine[] localMessagingEngines = SibRaEngineComponent.getMessagingEngines((String)this._endpointConfiguration.getBusName());
        String destinationUuid = SibRaStaticDestinationEndpointActivation.validateDestination(messagingEngine, this._endpointConfiguration.getDestination().getBusName(), this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getDestinationType());
        if (DestinationType.TOPICSPACE == this._endpointConfiguration.getDestinationType()) {
            if (this._endpointConfiguration.isDurableSubscription()) {
                this._remoteDestination = true;
                for (int i = 0; i < localMessagingEngines.length; ++i) {
                    if (!localMessagingEngines[i].getName().equals(this._endpointConfiguration.getDurableSubscriptionHome())) continue;
                    requiredMessagingEngines.add(localMessagingEngines[i].getUuid().toString());
                    this._remoteDestination = false;
                    break;
                }
            } else {
                this._remoteDestination = false;
            }
        } else {
            Set destinationLocalisations;
            try {
                destinationLocalisations = messagingEngine.getSIBDestinationLocalitySet(this._endpointConfiguration.getDestination().getBusName(), destinationUuid);
            }
            catch (SIBExceptionBase exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "getRequiredMessagingEngines"), (String)FFDC_PROBE_3, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DESTINATION_LOCALITY_CWSIV0753", new Object[]{exception, destinationUuid}, null), (Throwable)exception);
            }
            this._remoteDestination = true;
            for (int i = 0; i < localMessagingEngines.length; ++i) {
                String meUuid = localMessagingEngines[i].getUuid().toString();
                if (!destinationLocalisations.contains(meUuid)) continue;
                requiredMessagingEngines.add(meUuid);
                this._remoteDestination = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getRequiredMessagingEngines", requiredMessagingEngines);
        }
        return requiredMessagingEngines;
    }

    private void createListener(JsMessagingEngine messagingEngine) throws ResourceException {
        String methodName = "createListener";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createListener", (Object)messagingEngine);
        }
        SibRaMessagingEngineConnection connection = this.getConnection(messagingEngine);
        this.createListener(connection);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createListener");
        }
    }

    private void createListener(final SibRaMessagingEngineConnection connection) throws ResourceException {
        String methodName = "createListener";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createListener", (Object)connection);
        }
        SIDestinationAddress destination = this._endpointConfiguration.getDestination();
        try {
            connection.createListener(destination, this._messageEndpointFactory);
        }
        catch (IllegalStateException exception) {
            throw exception;
        }
        catch (ResourceException exception) {
            if (this._remoteDestination) {
                SibTr.warning((TraceComponent)TRACE, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"ATTACH_FAILED_CWSIV0769", (Object)new Object[]{destination.getDestinationName(), this._endpointConfiguration.getBusName(), this, exception});
                this._timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            SibRaStaticDestinationEndpointActivation.this.createListener(connection);
                        }
                        catch (ResourceException resourceException) {
                            // empty catch block
                        }
                    }
                }, this.RETRY_INTERVAL);
            }
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createListener");
        }
    }

    @Override
    public synchronized void messagingEngineStopping(JsMessagingEngine messagingEngine, int mode) {
        String methodName = "messagingEngineStopping";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping", (Object)new Object[]{messagingEngine, mode});
        }
        super.messagingEngineStopping(messagingEngine, mode);
        try {
            Set requiredMessagingEngines = this.getRequiredMessagingEngines(messagingEngine);
            JsMessagingEngine[] activeMessagingEngines = SibRaEngineComponent.getActiveMessagingEngines((String)this._endpointConfiguration.getBusName());
            if (requiredMessagingEngines.size() == 0 && this._connections.size() == 0) {
                if (activeMessagingEngines.length > 0) {
                    int randomIndex = _random.nextInt(activeMessagingEngines.length);
                    this.createListener(activeMessagingEngines[randomIndex]);
                } else {
                    SibTr.info((TraceComponent)TRACE, (String)"LAST_ME_CWSIV0768", (Object)new Object[]{messagingEngine.getName(), messagingEngine.getBus(), this});
                }
            }
        }
        catch (ResourceException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "messagingEngineStopping"), (String)FFDC_PROBE_4, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"MESSAGING_ENGINE_STOPPING_CWSIV0765", (Object)new Object[]{exception, messagingEngine.getName(), messagingEngine.getBusName()});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping");
        }
    }

    public synchronized void messagingEngineInitializing(JsMessagingEngine messagingEngine) {
        String methodName = "messagingEngineInitializing";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineInitializing", (Object)messagingEngine);
        }
        if (this._remoteMessagingEngine && messagingEngine.getBusName().equals(this._endpointConfiguration.getBusName())) {
            SibTr.info((TraceComponent)TRACE, (String)"ME_INITIALIZING_CWSIV0778", (Object)new Object[]{messagingEngine.getName(), this._endpointConfiguration.getBusName(), this});
            this._remoteMessagingEngine = false;
            if (this._remoteConnection != null) {
                this._remoteConnection.close();
            }
            this._timer.cancel();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineInitializing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagingEngineDestroyed(JsMessagingEngine messagingEngine) {
        JsMessagingEngine[] localMessagingEngines;
        String methodName = "messagingEngineDestroyed";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineDestroyed", (Object)messagingEngine);
        }
        if (0 == (localMessagingEngines = SibRaEngineComponent.getMessagingEngines((String)this._endpointConfiguration.getBusName())).length) {
            SibTr.info((TraceComponent)TRACE, (String)"ME_DESTROYED_CWSIV0779", (Object)new Object[]{messagingEngine.getName(), this._endpointConfiguration.getBusName(), this});
            this._remoteDestination = true;
            SibRaStaticDestinationEndpointActivation sibRaStaticDestinationEndpointActivation = this;
            synchronized (sibRaStaticDestinationEndpointActivation) {
                this._remoteMessagingEngine = true;
            }
            this.createRemoteListenerDeactivateOnException(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineDestroyed");
        }
    }

    public void messagingEngineReloaded(JsMessagingEngine engine) {
        String methodName = "messagingEngineReloaded";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineReloaded", (Object)engine);
        }
        boolean engineStarted = false;
        JsMessagingEngine[] engines = SibRaEngineComponent.getActiveMessagingEngines((String)engine.getBusName());
        for (int i = 0; i < engines.length; ++i) {
            if (!engines[i].equals(engine)) continue;
            engineStarted = true;
            break;
        }
        if (engineStarted) {
            try {
                if (!this._connections.containsKey(engine.getUuid().toString()) && this.isListenerRequired(engine)) {
                    this.createListener(engine);
                }
            }
            catch (ResourceException exception) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                SibTr.error((TraceComponent)TRACE, (String)"RELOAD_FAILED_CWSIV0773", (Object)new Object[]{exception, engine.getName(), engine.getBusName(), this});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineReloaded");
        }
    }

    @Override
    void sessionError(SibRaMessagingEngineConnection connection, ConsumerSession session, Throwable throwable) {
        String methodName = "sessionError";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"sessionError", (Object)new Object[]{connection, session});
        }
        SIDestinationAddress destination = session.getDestinationAddress();
        if (this._remoteDestination) {
            SibTr.warning((TraceComponent)TRACE, (String)"CONSUMER_FAILED_CWSIV0770", (Object)new Object[]{destination.getDestinationName(), this._endpointConfiguration.getBusName(), this, throwable});
            try {
                this.createListener(connection);
            }
            catch (ResourceException resourceException) {}
        } else if (SibRaEngineComponent.isMessagingEngineReloading((String)connection.getConnection().getMeUuid())) {
            SibTr.warning((TraceComponent)TRACE, (String)"FAILURE_DURING_RELOAD_CWSIV0774", (Object)new Object[]{throwable, destination.getDestinationName(), connection.getConnection().getMeName(), destination.getBusName(), this});
            this.closeConnection(connection.getConnection().getMeUuid());
        } else {
            SibTr.error((TraceComponent)TRACE, (String)"SESSION_ERROR_CWSIV0766", (Object)new Object[]{throwable, destination.getDestinationName(), connection.getConnection().getMeName(), destination.getBusName(), this});
            this.deactivate();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"sessionError");
        }
    }

    @Override
    synchronized void connectionError(SibRaMessagingEngineConnection connection, SIException exception) {
        String methodName = "connectionError";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connectionError", (Object)new Object[]{connection, exception});
        }
        if (this._remoteMessagingEngine) {
            if (connection.equals(this._remoteConnection)) {
                SibTr.warning((TraceComponent)TRACE, (String)"CONNECTION_ERROR_CWSIV0776", (Object)new Object[]{connection.getConnection().getMeName(), this._endpointConfiguration.getBusName(), this, exception});
                this._remoteConnection.close();
                this._remoteConnection = null;
                this.scheduleCreateRemoteListener();
            } else if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Connection " + connection + " not equal to current remote connection " + this._remoteConnection));
            }
        } else {
            SibTr.error((TraceComponent)TRACE, (String)"CONNECTION_ERROR_CWSIV0767", (Object)new Object[]{exception, connection.getConnection().getMeName(), this});
            this.deactivate();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"connectionError");
        }
    }

    @Override
    synchronized void messagingEngineTerminated(SibRaMessagingEngineConnection connection) {
        String methodName = "messagingEngineTerminated";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineTerminated", (Object)connection);
        }
        if (connection.equals(this._remoteConnection)) {
            SibTr.warning((TraceComponent)TRACE, (String)"ME_TERMINATED_CWSIV0780", (Object)new Object[]{connection.getConnection().getMeName(), this._endpointConfiguration.getBusName(), this});
            this._remoteConnection.close();
            this._remoteConnection = null;
            this.scheduleCreateRemoteListener();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineTerminated");
        }
    }

    @Override
    synchronized void messagingEngineQuiescing(SibRaMessagingEngineConnection connection) {
        String methodName = "messagingEngineQuiescing";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineQuiescing", (Object)connection);
        }
        if (connection.equals(this._remoteConnection)) {
            SibTr.warning((TraceComponent)TRACE, (String)"ME_QUIESCING_CWSIV0781", (Object)new Object[]{connection.getConnection().getMeName(), this._endpointConfiguration.getBusName(), this});
            this._remoteConnection.close();
            this._remoteConnection = null;
            this.scheduleCreateRemoteListener();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineQuiescing");
        }
    }

    private synchronized void createRemoteListener(boolean initialAttempt) throws ResourceException {
        String methodName = "createRemoteListener";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createRemoteListener", (Object)initialAttempt);
        }
        if (this._remoteMessagingEngine) {
            try {
                this._remoteConnection = new SibRaMessagingEngineConnection((SibRaEndpointActivation)this, this._endpointConfiguration.getBusName());
                this.createListener(this._remoteConnection);
            }
            catch (SIResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "createRemoteListener"), (String)FFDC_PROBE_5, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                if (!initialAttempt) {
                    SibTr.warning((TraceComponent)TRACE, (String)"CONNECT_FAILED_CWSIV0775", (Object)new Object[]{this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName(), this, exception});
                }
                this.scheduleCreateRemoteListener();
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "createRemoteListener"), (String)FFDC_PROBE_6, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONNECT_FAILED_CWSIV0782", new Object[]{this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName(), this, exception}, null), (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createRemoteListener");
        }
    }

    private void scheduleCreateRemoteListener() {
        String methodName = "scheduleCreateRemoteListener";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"scheduleCreateRemoteListener");
        }
        this._timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SibRaStaticDestinationEndpointActivation.this.createRemoteListenerDeactivateOnException(false);
                SibRaStaticDestinationEndpointActivation sibRaStaticDestinationEndpointActivation = SibRaStaticDestinationEndpointActivation.this;
                synchronized (sibRaStaticDestinationEndpointActivation) {
                    if (SibRaStaticDestinationEndpointActivation.this._remoteConnection != null) {
                        SibTr.info((TraceComponent)TRACE, (String)"CONNECTED_CWSIV0777", (Object)new Object[]{SibRaStaticDestinationEndpointActivation.this._remoteConnection.getConnection().getMeName(), SibRaStaticDestinationEndpointActivation.this._endpointConfiguration.getDestination().getDestinationName(), SibRaStaticDestinationEndpointActivation.this._endpointConfiguration.getBusName(), SibRaStaticDestinationEndpointActivation.this});
                    }
                }
            }
        }, this.RETRY_INTERVAL);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"scheduleCreateRemoteListener");
        }
    }

    private void createRemoteListenerDeactivateOnException(boolean initialAttempt) {
        String methodName = "createRemoteListenerDeactivateOnException";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createRemoteListenerDeactivateOnException", (Object)initialAttempt);
        }
        try {
            this.createRemoteListener(initialAttempt);
        }
        catch (ResourceException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "createRemoteListenerDeactivateOnException"), (String)FFDC_PROBE_7, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"CONNECT_FAILED_CWSIV0783", (Object)new Object[]{this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName(), this, exception});
            this.deactivate();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createRemoteListenerDeactivateOnException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator generator = super.getStringGenerator();
        SibRaStaticDestinationEndpointActivation sibRaStaticDestinationEndpointActivation = this;
        synchronized (sibRaStaticDestinationEndpointActivation) {
            generator.addField("remoteConnection", this._remoteConnection);
        }
        generator.addField("remoteDestination", this._remoteDestination);
        generator.addField("timer", this._timer);
        return generator;
    }
}

