/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LaunchManifest {
    static List<RequiredBundle> parseRequireBundle(String header) {
        header = header + ",";
        ArrayList<RequiredBundle> bundles = new ArrayList<RequiredBundle>();
        ArrayList<String> symbolicNames = new ArrayList<String>();
        ArrayList<String> attributes = new ArrayList<String>();
        boolean quoted = false;
        boolean symbolicNameAllowed = true;
        int strLen = header.length();
        int pos = 0;
        for (int i = 0; i < strLen; ++i) {
            String str;
            char c = header.charAt(i);
            if (c == ';') {
                str = header.substring(pos, i);
                pos = i + 1;
                if (str.contains(":=")) {
                    symbolicNameAllowed = false;
                    continue;
                }
                if (str.contains("=")) {
                    attributes.add(str);
                    symbolicNameAllowed = false;
                    continue;
                }
                if (!symbolicNameAllowed) continue;
                symbolicNames.add(str);
                continue;
            }
            if (c == ',' && !quoted) {
                str = header.substring(pos, i);
                pos = i + 1;
                if (str.contains(":=")) {
                    symbolicNameAllowed = false;
                } else if (str.contains("=")) {
                    attributes.add(str);
                    symbolicNameAllowed = false;
                } else if (symbolicNameAllowed) {
                    symbolicNames.add(str);
                }
                symbolicNameAllowed = true;
                quoted = false;
                HashMap<String, String> attributeMap = new HashMap<String, String>();
                for (String attrib : attributes) {
                    int index = attrib.indexOf(61);
                    String key = attrib.substring(0, index).trim();
                    String value = attrib.substring(index + 1).trim();
                    if (value.charAt(0) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    attributeMap.put(key, value);
                }
                for (String name : symbolicNames) {
                    bundles.add(new RequiredBundle(name.trim(), attributeMap));
                }
                symbolicNames.clear();
                attributes.clear();
                continue;
            }
            if (c != '\"') continue;
            quoted = !quoted;
        }
        return bundles;
    }

    static List<String> parseHeaderList(String header) {
        ArrayList<String> headerList = new ArrayList<String>();
        if (null != header) {
            Collections.addAll(headerList, header.split(","));
        }
        return headerList;
    }

    static final class RequiredBundle {
        private final String symbolicName;
        private final Map<String, String> attributes;

        public RequiredBundle(String name, Map<String, String> attributeMap) {
            this.symbolicName = name;
            this.attributes = attributeMap;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public String getAttribute(String name) {
            return this.attributes.get(name);
        }

        public String toString() {
            return this.symbolicName + ":" + this.attributes;
        }
    }
}

