/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.DeleteNode;
import com.ibm.ws.sib.msgstore.gbs.DeleteStack;
import com.ibm.ws.sib.msgstore.gbs.GBSDeleteFringe;
import com.ibm.ws.sib.msgstore.gbs.GBSInsertFringe;
import com.ibm.ws.sib.msgstore.gbs.GBSIterator;
import com.ibm.ws.sib.msgstore.gbs.GBSNode;
import com.ibm.ws.sib.msgstore.gbs.GBSTreeException;
import com.ibm.ws.sib.msgstore.gbs.InsertNodes;
import com.ibm.ws.sib.msgstore.gbs.InsertStack;
import com.ibm.ws.sib.msgstore.gbs.NodeInsertPoint;
import com.ibm.ws.sib.msgstore.gbs.OptimisticDepthException;
import com.ibm.ws.sib.msgstore.gbs.SearchComparator;
import com.ibm.ws.sib.msgstore.gbs.SearchNode;
import java.util.Comparator;

public class GBSTree {
    public static final int GBS_TREE = 12;
    public static final int T_TREE = 15;
    private Comparator _insertComparator;
    private Comparator _deleteComparator;
    private SearchComparator _localComparator;
    private GBSNode _dummyTopNode;
    private GBSNode _nodePool;
    private int _population;
    private volatile int _vno;
    private volatile int _xno;
    private volatile int _optimisticFinds;
    private int _pessimisticFinds;
    private volatile int _optimisticInserts;
    private volatile int _optimisticInsertSurprises;
    private int _pessimisticInserts;
    private volatile int _optimisticDeletes;
    private volatile int _optimisticDeleteSurprises;
    private int _pessimisticDeletes;
    private volatile int _nullPointerExceptions;
    private volatile int _optimisticDepthExceptions;
    private final int _nodeWidth;
    private final int _nodeMidPoint;
    private final int _kFactor;
    private final int _tZeroDepth;
    private static final boolean pessimisticNeeded = false;
    private static final boolean optimisticWorked = true;
    static final int maxDepth = 47;
    private static final int[] _t0_d = new int[]{-1, -1, 0, -1, 1, -1, 2, -1, 2, -1, -1, -1, 3, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, 4};
    private static ThreadLocal _searchNode = new ThreadLocal();
    private static ThreadLocal _insertStack = new ThreadLocal();
    private static ThreadLocal _deleteStack = new ThreadLocal();

    public GBSTree(int kFactor, int nodeWidth, Comparator insertComparator, Comparator keyComparator) {
        this._tZeroDepth = this.calcTZeroDepth(kFactor);
        this._kFactor = kFactor;
        this._nodeWidth = nodeWidth;
        this._nodeMidPoint = (nodeWidth - 1) / 2;
        this._insertComparator = insertComparator;
        this._deleteComparator = insertComparator;
        if (insertComparator == null) {
            throw new IllegalArgumentException("insertComparator is null.");
        }
        if (keyComparator == null) {
            throw new IllegalArgumentException("keyComparator is null.");
        }
        this._localComparator = new SearchComparator(keyComparator);
        this._dummyTopNode = new GBSNode(this, 0);
        if (nodeWidth < 3 || nodeWidth > 2000) {
            String x = "Invalid node width (" + nodeWidth + ").\nMinimum required is 3.\nMaximum (arbitrary) limit is 2000.";
            throw new IllegalArgumentException(x);
        }
    }

    public int treeType() {
        return 12;
    }

    public int nodeWidth() {
        return this._nodeWidth;
    }

    public int size() {
        return this._population;
    }

    public int optimisticFinds() {
        return this._optimisticFinds;
    }

    public int optimisticInserts() {
        return this._optimisticInserts;
    }

    public int optimisticInsertSurprises() {
        return this._optimisticInsertSurprises;
    }

    public int optimisticDeletes() {
        return this._optimisticDeletes;
    }

    public int optimisticDeleteSurprises() {
        return this._optimisticDeleteSurprises;
    }

    public int pessimisticFinds() {
        return this._pessimisticFinds;
    }

    public int pessimisticInserts() {
        return this._pessimisticInserts;
    }

    public int pessimisticDeletes() {
        return this._pessimisticDeletes;
    }

    public int nullPointerExceptions() {
        return this._nullPointerExceptions;
    }

    public int optimisticDepthExceptions() {
        return this._optimisticDepthExceptions;
    }

    int nodeMidPoint() {
        return this._nodeMidPoint;
    }

    public int kFactor() {
        return this._kFactor;
    }

    public GBSNode root() {
        return this.dummyTopNode().rightChild();
    }

    GBSNode dummyTopNode() {
        return this._dummyTopNode;
    }

    private void setRoot(GBSNode x) {
        this.dummyTopNode().setRightChild(x);
    }

    public void testSetRoot(GBSNode x) {
        this.setRoot(x);
    }

    private void addFirstNode(Object new1) {
        GBSNode p = this.getNode(new1);
        this.setRoot(p);
    }

    public Comparator insertComparator() {
        return this._insertComparator;
    }

    public Comparator deleteComparator() {
        return this._deleteComparator;
    }

    private SearchComparator searchComparator(int type) {
        return this._localComparator.getSingleton(type);
    }

    void releaseNode(GBSNode p) {
        p.setRightChild(this._nodePool);
        this._nodePool = p;
    }

    GBSNode getNode(Object newKey) {
        GBSNode p;
        if (this._nodePool == null) {
            p = new GBSNode(this, newKey);
        } else {
            p = this._nodePool;
            this._nodePool = p.rightChild();
            p.reset(newKey);
        }
        return p;
    }

    public void prePopulate(int x) {
        for (int i = 0; i < x; ++i) {
            GBSNode p = new GBSNode(this);
            this.releaseNode(p);
        }
    }

    public int vno() {
        return this._vno;
    }

    public int xno() {
        return this._xno;
    }

    int tZeroDepth() {
        return this._tZeroDepth;
    }

    public int maximumFringeImbalance() {
        int maxBal;
        GBSNode q = this.root();
        if (q.leftChild() == null) {
            maxBal = this.kFactor() - 1;
            if (maxBal < 3) {
                maxBal = 3;
            }
        } else {
            maxBal = this.kFactor() % 3 == 0 ? this.kFactor() + 2 : this.kFactor() + 1;
        }
        return maxBal;
    }

    private int calcTZeroDepth(int proposedK) {
        int d = -1;
        if (proposedK >= 0 && proposedK < _t0_d.length) {
            d = _t0_d[proposedK];
        }
        if (d < 0) {
            String x = "K Factor (" + proposedK + ") is invalid.\nValid K factors are: " + this.kFactorString() + ".";
            throw new IllegalArgumentException(x);
        }
        return d;
    }

    private String kFactorString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        boolean first1 = true;
        for (int i = 0; i < _t0_d.length; ++i) {
            if (_t0_d[i] < 0) continue;
            if (!first1) {
                buf.append(", ");
            }
            buf.append(i + "");
            first1 = false;
        }
        buf.append("}");
        return buf.toString();
    }

    static boolean checkForPossibleIndexChange(int v1, int v2, Throwable exc, String msg) {
        if (v1 != v2) {
            return false;
        }
        GBSTreeException x = new GBSTreeException(msg + ", v1 = " + v1, exc);
        throw x;
    }

    public Iterator iterator() {
        GBSIterator x;
        GBSIterator q = x = new GBSIterator(this);
        return q;
    }

    public Object searchEqual(Object searchKey) {
        SearchComparator comp = this.searchComparator(1);
        Object p = this.find(comp, searchKey);
        return p;
    }

    public Object searchGreater(Object searchKey) {
        SearchComparator comp = this.searchComparator(2);
        Object p = this.find(comp, searchKey);
        return p;
    }

    public Object searchGreaterOrEqual(Object searchKey) {
        SearchComparator comp = this.searchComparator(3);
        Object p = this.find(comp, searchKey);
        return p;
    }

    private SearchNode getSearchNode() {
        Object x = _searchNode.get();
        SearchNode g = null;
        if (x != null) {
            g = (SearchNode)x;
            g.reset();
        } else {
            g = new SearchNode();
            x = g;
            _searchNode.set(x);
        }
        return g;
    }

    private Object find(SearchComparator comp, Object searchKey) {
        SearchNode point = this.getSearchNode();
        Object ret = null;
        boolean gotit = this.optimisticFind(comp, searchKey, point);
        if (!gotit) {
            this.pessimisticFind(comp, searchKey, point);
        }
        if (point.wasFound()) {
            ret = point.foundNode().key(point.foundIndex());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean optimisticFind(SearchComparator comp, Object searchKey, SearchNode point) {
        point.reset();
        int v1 = this._vno;
        if (this.root() != null) {
            if ((v1 & 1) != 0) {
                return false;
            }
            SearchNode searchNode = point;
            synchronized (searchNode) {
            }
            try {
                this.internalFind(comp, searchKey, point);
            }
            catch (NullPointerException npe) {
                ++this._nullPointerExceptions;
                return GBSTree.checkForPossibleIndexChange(v1, this._vno, npe, "optimisticInsert");
            }
            catch (OptimisticDepthException ode) {
                ++this._optimisticDepthExceptions;
                return GBSTree.checkForPossibleIndexChange(v1, this._vno, ode, "optimisticInsert");
            }
            if (v1 != this._vno) {
                return false;
            }
        }
        ++this._optimisticFinds;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pessimisticFind(SearchComparator comp, Object searchKey, SearchNode point) {
        point.reset();
        GBSTree gBSTree = this;
        synchronized (gBSTree) {
            this.internalFind(comp, searchKey, point);
            ++this._pessimisticFinds;
        }
    }

    private void internalFind(SearchComparator comp, Object searchKey, SearchNode point) {
        GBSNode p = this.root();
        GBSNode l = null;
        GBSNode r = null;
        while (p != null) {
            int xcc = comp.compare(searchKey, p.middleKey());
            if (xcc == 0) {
                point.setFound(p, p.middleIndex());
                p = null;
                continue;
            }
            if (xcc < 0) {
                if (p.leftChild() != null) {
                    l = p;
                    p = p.leftChild();
                    continue;
                }
                this.leftSearch(comp, p, r, searchKey, point);
                p = null;
                continue;
            }
            if (p.rightChild() != null) {
                r = p;
                p = p.rightChild();
                continue;
            }
            this.rightSearch(comp, p, l, searchKey, point);
            p = null;
        }
    }

    synchronized Object iteratorFind(DeleteStack stack, SearchComparator comp, Object searchKey, SearchNode point) {
        point.reset();
        GBSNode p = this.root();
        GBSNode l = null;
        GBSNode r = null;
        int lx = 0;
        int rx = 0;
        Object ret = null;
        stack.start(this.dummyTopNode(), "GBSTree.iteratorFind");
        while (p != null) {
            int xcc = comp.compare(searchKey, p.middleKey());
            if (xcc == 0) {
                point.setFound(p, p.middleIndex());
                p = null;
                continue;
            }
            if (xcc < 0) {
                if (p.leftChild() != null) {
                    stack.push(2, p, "GBSTree.iteratorFind(1)");
                    l = p;
                    lx = stack.index();
                    p = p.leftChild();
                    continue;
                }
                this.leftSearch(comp, p, r, searchKey, point);
                if (point.wasFound() && point.foundNode() == r) {
                    stack.reset(rx - 1);
                }
                p = null;
                continue;
            }
            if (p.rightChild() != null) {
                stack.push(4, p, "GBSTree.iteratorFind(2)");
                r = p;
                rx = stack.index();
                p = p.rightChild();
                continue;
            }
            this.rightSearch(comp, p, l, searchKey, point);
            if (point.wasFound() && point.foundNode() == l) {
                stack.reset(lx - 1);
            }
            p = null;
        }
        if (point.wasFound()) {
            ret = point.foundNode().key(point.foundIndex());
            point.setLocation(ret);
        }
        return ret;
    }

    private void leftSearch(SearchComparator comp, GBSNode p, GBSNode r, Object searchKey, SearchNode point) {
        if (r == null) {
            int idx = p.searchLeft(comp, searchKey);
            if (idx >= 0) {
                point.setFound(p, idx);
            }
        } else {
            int xcc = comp.compare(searchKey, r.rightMostKey());
            if (xcc == 0) {
                point.setFound(r, r.rightMostIndex());
            } else if (xcc > 0) {
                int idx = p.searchLeft(comp, searchKey);
                if (idx >= 0) {
                    point.setFound(p, idx);
                }
            } else {
                int idx = r.searchRight(comp, searchKey);
                if (idx >= 0) {
                    point.setFound(r, idx);
                }
            }
        }
    }

    private void rightSearch(SearchComparator comp, GBSNode p, GBSNode l, Object searchKey, SearchNode point) {
        int idx;
        int xcc = comp.compare(searchKey, p.rightMostKey());
        if (xcc == 0) {
            point.setFound(p, 0);
        } else if (xcc < 0) {
            int idx2 = p.searchRight(comp, searchKey);
            if (idx2 >= 0) {
                point.setFound(p, idx2);
            }
        } else if (l != null && (idx = l.searchLeft(comp, searchKey)) >= 0) {
            point.setFound(l, idx);
        }
    }

    private InsertStack getInsertStack() {
        Object x = _insertStack.get();
        InsertStack g = null;
        if (x != null) {
            g = (InsertStack)x;
            g.reset();
        } else {
            g = new InsertStack(this);
            x = g;
            _insertStack.set(x);
        }
        return g;
    }

    public boolean insert(Object new1) {
        InsertStack stack = this.getInsertStack();
        if (this.root() == null) {
            this.pessimisticInsert(stack, new1);
        } else {
            boolean didit = this.optimisticInsert(stack, new1);
            if (!didit) {
                this.pessimisticInsert(stack, new1);
            }
        }
        boolean result = !stack.isDuplicate();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean optimisticInsert(InsertStack stack, Object new1) {
        InsertNodes point = stack.insertNodes();
        int v1 = this._vno;
        if (this.root() == null) {
            return false;
        }
        if ((v1 & 1) != 0) {
            return false;
        }
        Object object = stack;
        synchronized (object) {
        }
        try {
            this.findInsert(point, stack, new1);
        }
        catch (NullPointerException npe) {
            ++this._nullPointerExceptions;
            return GBSTree.checkForPossibleIndexChange(v1, this._vno, npe, "optimisticInsert");
        }
        catch (OptimisticDepthException ode) {
            ++this._optimisticDepthExceptions;
            return GBSTree.checkForPossibleIndexChange(v1, this._vno, ode, "optimisticInsert");
        }
        object = this;
        synchronized (object) {
            if (v1 != this._vno) {
                ++this._optimisticInsertSurprises;
                return false;
            }
            ++this._optimisticInserts;
            if (point.isDuplicate()) {
                stack.markDuplicate();
            } else {
                ++this._vno;
                if ((this._vno & 1) == 1) {
                    this.finishInsert(point, stack, new1);
                    ++this._population;
                }
                InsertStack insertStack = stack;
                synchronized (insertStack) {
                }
                ++this._vno;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean pessimisticInsert(InsertStack stack, Object new1) {
        ++this._vno;
        if ((this._vno & 1) == 1) {
            if (this.root() == null) {
                this.addFirstNode(new1);
                ++this._population;
            } else {
                InsertNodes point = stack.insertNodes();
                this.findInsert(point, stack, new1);
                if (point.isDuplicate()) {
                    stack.markDuplicate();
                } else {
                    this.finishInsert(point, stack, new1);
                    ++this._population;
                }
            }
        }
        InsertStack insertStack = stack;
        synchronized (insertStack) {
        }
        ++this._vno;
        ++this._pessimisticInserts;
        return true;
    }

    private void findInsert(InsertNodes point, InsertStack stack, Object new1) {
        block3: {
            Comparator comp = this.insertComparator();
            NodeInsertPoint ip = stack.nodeInsertPoint();
            GBSNode l_last = null;
            GBSNode r_last = null;
            GBSNode p = this.root();
            stack.start(this.dummyTopNode(), "GBSTree.findInsert");
            while (true) {
                int xcc;
                if ((xcc = comp.compare(new1, p.middleKey())) <= 0) {
                    GBSNode leftChild = p.leftChild();
                    if (leftChild != null) {
                        l_last = p;
                        stack.balancedPush(2, p);
                        p = leftChild;
                        continue;
                    }
                    this.leftAdd(p, r_last, new1, ip, point);
                    break block3;
                }
                GBSNode rightChild = p.rightChild();
                if (rightChild == null) break;
                r_last = p;
                stack.balancedPush(4, p);
                p = rightChild;
            }
            this.rightAdd(p, l_last, new1, ip, point);
        }
    }

    private void leftAdd(GBSNode p, GBSNode r, Object new1, NodeInsertPoint ip, InsertNodes point) {
        if (r == null) {
            this.leftAddNoPredecessor(p, new1, ip, point);
        } else {
            this.leftAddWithPredecessor(p, r, new1, ip, point);
        }
    }

    private void leftAddNoPredecessor(GBSNode p, Object new1, NodeInsertPoint ip, InsertNodes point) {
        p.findInsertPointInLeft(new1, ip);
        point.setInsert(p, ip);
    }

    private void leftAddWithPredecessor(GBSNode p, GBSNode r, Object new1, NodeInsertPoint ip, InsertNodes point) {
        Comparator comp = r.insertComparator();
        int xcc = comp.compare(new1, r.rightMostKey());
        if (xcc > 0) {
            p.findInsertPointInLeft(new1, ip);
            point.setInsert(p, ip);
        } else {
            r.findInsertPointInRight(new1, ip);
            if (ip.isDuplicate()) {
                point.setInsert(r, ip);
            } else {
                point.setInsertAndPosition(p, -1, r, ip.insertPoint());
                point.setRight();
            }
        }
    }

    private void rightAdd(GBSNode p, GBSNode l, Object new1, NodeInsertPoint ip, InsertNodes point) {
        if (l == null) {
            this.rightAddNoSuccessor(p, new1, ip, point);
        } else {
            this.rightAddWithSuccessor(p, l, new1, ip, point);
        }
    }

    private void rightAddNoSuccessor(GBSNode p, Object new1, NodeInsertPoint ip, InsertNodes point) {
        if (p.lessThanHalfFull()) {
            point.setInsert(p, p.rightMostIndex());
        } else {
            p.findInsertPointInRight(new1, ip);
            point.setInsert(p, ip);
        }
    }

    private void rightAddWithSuccessor(GBSNode p, GBSNode l, Object new1, NodeInsertPoint ip, InsertNodes point) {
        Comparator comp = l.insertComparator();
        int xcc = comp.compare(new1, l.leftMostKey());
        if (xcc < 0) {
            if (p.lessThanHalfFull()) {
                point.setInsert(p, p.rightMostIndex());
            } else {
                p.findInsertPointInRight(new1, ip);
                point.setInsert(p, ip);
            }
        } else {
            l.findInsertPointInLeft(new1, ip);
            if (ip.isDuplicate()) {
                point.setInsert(l, ip);
            } else {
                point.setInsertAndPosition(p, p.rightMostIndex(), l, ip.insertPoint());
                point.setLeft();
            }
        }
    }

    private void finishInsert(InsertNodes point, InsertStack stack, Object new1) {
        Object insertKey = new1;
        if (point.positionNode() != null) {
            GBSNode p = point.positionNode();
            int ix = point.positionIndex();
            insertKey = point.rightSide() ? p.insertByRightShift(ix, insertKey) : p.insertByLeftShift(ix, insertKey);
        }
        Object migrateKey = null;
        migrateKey = point.insertIndex() == point.insertNode().topMostIndex() ? insertKey : point.insertNode().insertByRightShift(point.insertIndex(), insertKey);
        this.insertFringeMigrate(stack, point.insertNode(), migrateKey);
    }

    private void insertFringeMigrate(InsertStack stack, GBSNode p, Object mkey) {
        GBSNode endp = p;
        int endIndex = stack.index();
        int maxBal = this.maximumFringeImbalance();
        stack.setMigratingKey(mkey);
        if (mkey != null) {
            stack.processSubFringe(p);
            endp = stack.lastNode();
            endIndex = stack.lastIndex();
        }
        if (stack.migrating()) {
            ++this._xno;
            endp.addRightLeaf(stack.migratingKey());
        }
        this.insertCheckFringeBalance(stack, endp, endIndex, maxBal);
    }

    private void insertCheckFringeBalance(InsertStack stack, GBSNode endp, int endIndex, int maxBal) {
        GBSNode fpoint = null;
        int fDepth = 0;
        int fpidx = 0;
        if (endp.isFull() && endp.leftChild() == null) {
            GBSNode q;
            fDepth = 1;
            int j = endIndex;
            while (j > 0 && (q = stack.node(j)).leftChild() == null) {
                ++fDepth;
                fpoint = q;
                fpidx = j--;
            }
            if (fDepth >= maxBal) {
                ++this._xno;
                GBSInsertFringe.singleInstance().balance(this.kFactor(), stack, fpoint, fpidx, maxBal);
            }
        }
    }

    public boolean delete(Object deleteKey) {
        return this.internalDelete(deleteKey);
    }

    private DeleteStack getDeleteStack() {
        Object x = _deleteStack.get();
        DeleteStack g = null;
        if (x != null) {
            g = (DeleteStack)x;
            g.reset();
        } else {
            g = new DeleteStack(this);
            x = g;
            _deleteStack.set(x);
        }
        return g;
    }

    private boolean internalDelete(Object deleteKey) {
        boolean deleted = false;
        if (this.root() != null) {
            DeleteNode point;
            DeleteStack stack = this.getDeleteStack();
            boolean didit = this.optimisticDelete(stack, deleteKey);
            if (!didit) {
                this.pessimisticDelete(stack, deleteKey);
            }
            if ((point = stack.deleteNode()).wasFound()) {
                deleted = true;
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean optimisticDelete(DeleteStack stack, Object deleteKey) {
        DeleteNode point = stack.deleteNode();
        int v1 = this._vno;
        if ((v1 & 1) != 0) {
            return false;
        }
        Object object = stack;
        synchronized (object) {
        }
        try {
            this.findDelete(point, stack, deleteKey);
        }
        catch (NullPointerException npe) {
            ++this._nullPointerExceptions;
            return GBSTree.checkForPossibleIndexChange(v1, this._vno, npe, "optimisticDelete");
        }
        catch (OptimisticDepthException ode) {
            ++this._optimisticDepthExceptions;
            return GBSTree.checkForPossibleIndexChange(v1, this._vno, ode, "optimisticDelete");
        }
        object = this;
        synchronized (object) {
            if (v1 != this._vno) {
                ++this._optimisticDeleteSurprises;
                return false;
            }
            ++this._optimisticDeletes;
            if (point.wasFound()) {
                ++this._vno;
                if ((this._vno & 1) == 1) {
                    this.finishDelete(point, stack, deleteKey);
                    if (this._population <= 0) {
                        throw new GBSTreeException("_population = " + this._population);
                    }
                    --this._population;
                }
                DeleteStack deleteStack = stack;
                synchronized (deleteStack) {
                }
                ++this._vno;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean pessimisticDelete(DeleteStack stack, Object deleteKey) {
        ++this._pessimisticDeletes;
        if (this.root() != null) {
            stack.reset();
            DeleteNode point = stack.deleteNode();
            ++this._vno;
            if ((this._vno & 1) == 1) {
                this.findDelete(point, stack, deleteKey);
                if (point.wasFound()) {
                    this.finishDelete(point, stack, deleteKey);
                    if (this._population <= 0) {
                        throw new GBSTreeException("_population = " + this._population);
                    }
                    --this._population;
                }
                DeleteStack deleteStack = stack;
                synchronized (deleteStack) {
                }
                ++this._vno;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iteratorSpecialDelete(Iterator iter, GBSNode node, int index) {
        ++this._vno;
        if ((this._vno & 1) == 1) {
            node.deleteByLeftShift(index);
            node.adjustMedian();
            --this._population;
        }
        Iterator iterator = iter;
        synchronized (iterator) {
        }
        ++this._vno;
    }

    private void finishDelete(DeleteNode point, DeleteStack stack, Object deleteKey) {
        this.adjustTarget(point);
        point.deleteNode().deleteByLeftShift(point.deleteIndex());
        this.deleteFringeMigrate(stack, point.deleteNode());
    }

    private void adjustTarget(DeleteNode point) {
        int s = point.targetType();
        GBSNode t = point.targetNode();
        GBSNode d = point.deleteNode();
        switch (s) {
            case 0: {
                break;
            }
            case 1: {
                int tx = point.targetIndex();
                t.addLeftMostKeyByDelete(tx, d.rightMostKey());
                break;
            }
            case 2: {
                int tx = point.targetIndex();
                t.addRightMostKeyByDelete(tx, d.leftMostKey());
                break;
            }
            case 3: {
                t.overlayRightMostKey(d.leftMostKey());
                break;
            }
            case 4: {
                t.overlayLeftMostKey(d.rightMostKey());
                break;
            }
            default: {
                throw new RuntimeException("s = " + s);
            }
        }
    }

    private void findDelete(DeleteNode point, DeleteStack stack, Object deleteKey) {
        Comparator comp = this.deleteComparator();
        GBSNode l_last = null;
        GBSNode r_last = null;
        GBSNode p = this.root();
        stack.start(this.dummyTopNode(), "GBSTree.findDelete");
        while (p != null) {
            int xcc = comp.compare(deleteKey, p.middleKey());
            if (xcc == 0) {
                this.midDelete(stack, p, point);
                p = null;
                continue;
            }
            if (xcc < 0) {
                if (p.leftChild() != null) {
                    l_last = p;
                    stack.push(2, p, "GBSTree.findDelete(1)");
                    p = p.leftChild();
                    continue;
                }
                this.leftDelete(p, r_last, deleteKey, point);
                p = null;
                continue;
            }
            if (p.rightChild() != null) {
                r_last = p;
                stack.push(4, p, "GBSTree.findDelete(2)");
                p = p.rightChild();
                continue;
            }
            this.rightDelete(p, l_last, deleteKey, point);
            p = null;
        }
    }

    private void midDelete(DeleteStack stack, GBSNode p, DeleteNode point) {
        point.setDelete(p, p.middleIndex());
        GBSNode q = p.lowerPredecessor(stack);
        if (q != null) {
            point.setDelete(q, q.rightMostIndex());
            point.setTarget(p, p.middleIndex(), 1);
        } else {
            q = p.lowerSuccessor(stack);
            if (q != null) {
                point.setDelete(q, 0);
                point.setTarget(p, p.middleIndex(), 2);
            }
        }
    }

    private void leftDelete(GBSNode p, GBSNode r, Object deleteKey, DeleteNode point) {
        if (r == null) {
            this.leftDeleteNoPredecessor(p, deleteKey, point);
        } else {
            this.leftDeleteWithPredecessor(p, r, deleteKey, point);
        }
    }

    private void leftDeleteNoPredecessor(GBSNode p, Object deleteKey, DeleteNode point) {
        int idx = p.findDeleteInLeft(deleteKey);
        if (idx >= 0) {
            point.setDelete(p, idx);
        }
    }

    private void leftDeleteWithPredecessor(GBSNode p, GBSNode r, Object deleteKey, DeleteNode point) {
        Comparator comp = p.deleteComparator();
        int xcc = comp.compare(deleteKey, r.rightMostKey());
        if (xcc == 0) {
            point.setDelete(p, 0);
            point.setTarget(r, r.rightMostIndex(), 3);
        } else if (xcc > 0) {
            int ix = p.findDeleteInLeft(deleteKey);
            if (ix >= 0) {
                point.setDelete(p, ix);
            }
        } else {
            int ix = r.findDeleteInRight(deleteKey);
            if (ix >= 0) {
                point.setTarget(r, ix, 2);
                point.setDelete(p, 0);
            }
        }
    }

    private void rightDelete(GBSNode p, GBSNode l, Object deleteKey, DeleteNode point) {
        if (l == null) {
            this.rightDeleteNoSuccessor(p, deleteKey, point);
        } else {
            this.rightDeleteWithSuccessor(p, l, deleteKey, point);
        }
    }

    private void rightDeleteNoSuccessor(GBSNode p, Object deleteKey, DeleteNode point) {
        int idx = p.findDeleteInRight(deleteKey);
        if (idx >= 0) {
            point.setDelete(p, idx);
        }
    }

    private void rightDeleteWithSuccessor(GBSNode p, GBSNode l, Object deleteKey, DeleteNode point) {
        Comparator comp = p.deleteComparator();
        int xcc = comp.compare(deleteKey, l.leftMostKey());
        if (xcc == 0) {
            point.setDelete(p, p.rightMostIndex());
            point.setTarget(l, 0, 4);
        } else if (xcc < 0) {
            int ix = p.findDeleteInRight(deleteKey);
            if (ix >= 0) {
                point.setDelete(p, ix);
            }
        } else {
            int ix = l.findDeleteInLeft(deleteKey);
            if (ix >= 0) {
                point.setDelete(p, p.rightMostIndex());
                point.setTarget(l, ix, 1);
            }
        }
    }

    private void deleteFringeMigrate(DeleteStack stack, GBSNode p) {
        GBSNode endp = p;
        int endIndex = stack.index();
        stack.add(0, p);
        int maxBal = this.maximumFringeImbalance();
        stack.processSubFringe(p);
        endp = stack.lastNode();
        endIndex = stack.lastIndex();
        this.deleteCheckFringeBalance(stack, endp, endIndex, maxBal);
    }

    private void deleteCheckFringeBalance(DeleteStack stack, GBSNode endp, int endIndex, int maxBal) {
        int t0_depth;
        int t;
        int fDepth = 0;
        fDepth = 0;
        if (endp.leftChild() == null) {
            GBSNode q;
            fDepth = 1;
            for (int j = endIndex; j > 0 && (q = stack.node(j)).leftChild() == null; --j) {
                ++fDepth;
            }
        }
        if ((t = (t0_depth = this.tZeroDepth())) < 1) {
            t = 1;
        }
        if (stack.maxDepth() >= t && endp.population() == endp.width() - 1) {
            int j = 1;
            if (this.kFactor() % 3 == 0) {
                j = 2;
            }
            if (fDepth == j) {
                ++this._xno;
                GBSDeleteFringe.singleInstance().balance(this.tZeroDepth(), stack);
            }
        } else if (endp.population() != 0) {
            endp.adjustMedian();
        } else {
            ++this._xno;
            GBSNode p = stack.node(endIndex);
            if (p.leftChild() == endp) {
                p.setLeftChild(null);
            } else {
                p.setRightChild(null);
            }
        }
    }

    public static interface Iterator {
        public Object next();

        public boolean remove();

        public void reset();
    }
}

