/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi;

import com.ibm.ws.xml.ParserFactory;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PluginParser
implements ContentHandler {
    private HashMap<String, Set<String>> uriGroups = new HashMap(3);
    private HashMap<String, Set<String>> vhostUris = new HashMap(3);
    private HashSet<String> curUris;

    public void parse(WsResource pluginCfgXml) throws IOException {
        if (pluginCfgXml != null && pluginCfgXml.exists()) {
            try (BufferedInputStream iStream = new BufferedInputStream(pluginCfgXml.get());){
                XMLReader xmlReader = ParserFactory.createXMLReader();
                xmlReader.setContentHandler(this);
                InputSource is = new InputSource(iStream);
                is.setSystemId(pluginCfgXml.asFile().getAbsolutePath());
                xmlReader.parse(is);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("UriGroup")) {
            this.curUris = null;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("Uri")) {
            this.curUris.add(atts.getValue("Name"));
        } else if (qName.equals("UriGroup")) {
            String uriGroup = atts.getValue("Name");
            this.curUris = new HashSet(5);
            this.uriGroups.put(uriGroup, this.curUris);
        } else if (qName.equals("Route")) {
            String uriGroup = atts.getValue("UriGroup");
            String vhostGroup = atts.getValue("VirtualHostGroup");
            this.vhostUris.put(vhostGroup, this.uriGroups.get(uriGroup));
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public HashMap<String, Set<String>> getVhostUris() {
        return this.vhostUris;
    }
}

