/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.library.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.internal.ClassLoadingServiceImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.library.internal.LibraryGeneration;
import com.ibm.ws.library.internal.LibraryPackageExporter;
import com.ibm.ws.library.spi.SpiLibrary;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.library.LibraryChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SharedLibraryImpl
implements Library,
SpiLibrary {
    private static final TraceComponent tc = Tr.register(SharedLibraryImpl.class, (String)"SharedLibrary", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private volatile boolean deleted;
    private volatile ServiceTracker<LibraryChangeListener, LibraryChangeListener> libraryListenersTracker = null;
    private volatile ServiceRegistration<Library> libraryReg = null;
    final BundleContext ctx;
    private final ClassLoadingService classLoadingService;
    private final ConfigurationAdmin configAdmin;
    private final String resolvedBasePath;
    final Object generationLock = new Object(){
        static final long serialVersionUID = 2483639803450672373L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.library.internal.SharedLibraryImpl$1", 1.class, (String)"SharedLibrary", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    };
    private volatile LibraryGeneration currentGeneration = null;
    private LibraryGeneration nextGeneration = null;
    final ArtifactContainerFactory artifactContainerFactory;
    private final LibraryPackageExporter packageExporter;
    static final long serialVersionUID = -2820082183656396262L;

    SharedLibraryImpl(BundleContext ctx, ClassLoadingService classLoadingService, ConfigurationAdmin configAdmin, String resolvedBasePath, ArtifactContainerFactory artifactContainerFactory, LibraryPackageExporter packageExporter) {
        this.ctx = ctx;
        this.classLoadingService = classLoadingService;
        this.configAdmin = configAdmin;
        this.resolvedBasePath = resolvedBasePath;
        this.artifactContainerFactory = artifactContainerFactory;
        this.packageExporter = packageExporter;
    }

    boolean isDeleted() {
        return this.deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void update(Dictionary<String, Object> props) {
        LibraryGeneration nextGen;
        if (this.deleted) {
            return;
        }
        String instancePid = (String)props.get("service.pid");
        String instanceId = (String)props.get("id");
        if (instanceId == null) {
            Tr.error((TraceComponent)tc, (String)"cls.library.id.missing", (Object[])new Object[0]);
        }
        if (this.libraryListenersTracker == null) {
            Filter listenerFilter = null;
            try {
                listenerFilter = FrameworkUtil.createFilter((String)("(&(objectClass=" + LibraryChangeListener.class.getName() + ")(|" + FilterUtils.createPropertyFilter((String)"library", (String)instanceId) + "(libraryRef=*" + instancePid + "*)))"));
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.library.internal.SharedLibraryImpl", (String)"115", (Object)this, (Object[])new Object[]{props});
                Tr.error((TraceComponent)tc, (String)"cls.library.id.invalid", (Object[])new Object[]{instanceId, e.toString()});
            }
            ServiceTracker tracker = new ServiceTracker(this.ctx, listenerFilter, null);
            tracker.open();
            this.libraryListenersTracker = tracker;
        }
        Object object = this.generationLock;
        synchronized (object) {
            nextGen = this.nextGeneration;
            if (nextGen != null) {
                this.nextGeneration = null;
                nextGen.cancel();
            }
            this.nextGeneration = nextGen = new LibraryGeneration(this, instanceId, props);
        }
        nextGen.fetchFilesets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        this.deleted = true;
        if (this.libraryListenersTracker != null) {
            this.libraryListenersTracker.close();
            this.libraryListenersTracker = null;
        }
        Object object = this.generationLock;
        synchronized (object) {
            LibraryGeneration libGen = this.nextGeneration;
            if (libGen != null) {
                this.nextGeneration = null;
                libGen.cancel();
            }
            if ((libGen = this.currentGeneration) != null) {
                this.currentGeneration = null;
                libGen.cancel();
            }
        }
        if (this.libraryReg != null) {
            this.libraryReg.unregister();
            this.libraryReg = null;
        }
        this.packageExporter.delete(this);
    }

    @Override
    public String id() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen != null ? currentGen.getLibraryId() : null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoadingService.getSharedLibraryClassLoader(this);
    }

    @Override
    public ClassLoader getSpiClassLoader(String ownerId) {
        return ((ClassLoadingServiceImpl)this.classLoadingService).getSharedLibrarySpiClassLoader(this, ownerId);
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getApiTypeVisibility();
    }

    public String toString() {
        LibraryGeneration currentGen = this.currentGeneration;
        String genStr = currentGen == null ? "<uninitialized>" : currentGen.getLibraryId();
        return String.format("Shared Library %s @ %x", genStr, this.hashCode());
    }

    @Override
    public Collection<File> getFiles() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getFiles();
    }

    @Override
    public Collection<File> getFolders() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getFolders();
    }

    @Override
    public Collection<Fileset> getFilesets() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getFilesets();
    }

    @Override
    public Collection<ArtifactContainer> getContainers() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getContainers();
    }

    void setLibraryServiceProperties(Dictionary<String, Object> svcProps) {
        ServiceRegistration svcReg;
        if (this.deleted) {
            return;
        }
        if (this.libraryReg == null) {
            svcReg = this.libraryReg = this.ctx.registerService(Library.class, (Object)this, svcProps);
        } else {
            svcReg = this.libraryReg;
            svcReg.setProperties(svcProps);
            this.packageExporter.refreshExporters(this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("svc prop keys are " + Arrays.toString(svcReg.getReference().getPropertyKeys())), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    void notifyListeners() {
        if (this.deleted) {
            return;
        }
        ServiceTracker<LibraryChangeListener, LibraryChangeListener> ls = this.libraryListenersTracker;
        if (ls == null) {
            return;
        }
        for (LibraryChangeListener listener : ls.getTracked().values()) {
            if (this.deleted) {
                return;
            }
            if (listener == null) continue;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("notifying listener: " + listener), (Object[])new Object[0]);
                }
                listener.libraryNotification();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.library.internal.SharedLibraryImpl", (String)"273", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("caught exception from listener: " + listener), (Object[])new Object[]{e});
            }
        }
    }

    Collection<File> retrieveClasspaths(ClasspathType type, String libraryId, String[] pids, String displayId) {
        ArrayList<File> result = new ArrayList<File>();
        if (pids == null || pids.length == 0) {
            return result;
        }
        for (String pid : pids) {
            try {
                Configuration config = this.configAdmin.getConfiguration(pid, this.ctx.getBundle().getLocation());
                Dictionary configProps = config.getProperties();
                if (configProps == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(type.debugLabel + ": configuration not found for " + pid), (Object[])new Object[0]);
                    }
                    config.delete();
                    continue;
                }
                String name = (String)configProps.get(type.attrKey);
                if (name != null && !name.isEmpty()) {
                    String path;
                    File f;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(type.debugLabel + ": configuration found" + name), (Object[])new Object[0]);
                    }
                    if (type.accept(f = new File(path = this.normalizePath(name)))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(type.debugLabel + ": added path" + path), (Object[])new Object[0]);
                        }
                        result.add(f);
                        continue;
                    }
                    type.warn(displayId, libraryId, path);
                    continue;
                }
                type.warn(displayId, libraryId, name);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.library.internal.SharedLibraryImpl", (String)"352", (Object)this, (Object[])new Object[]{type, libraryId, pids, displayId});
            }
        }
        return result;
    }

    private String normalizePath(String path) {
        String result = PathUtils.slashify((String)path);
        if (!PathUtils.pathIsAbsolute((String)result)) {
            result = this.resolvedBasePath + result;
        }
        result = PathUtils.normalize((String)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishGeneration(LibraryGeneration libraryGeneration) {
        Object object = this.generationLock;
        synchronized (object) {
            if (libraryGeneration.isCancelled()) {
                return;
            }
            LibraryGeneration libGen = this.currentGeneration;
            this.currentGeneration = libraryGeneration;
            if (libGen != null) {
                libGen.cancel();
            }
        }
        this.setLibraryServiceProperties(libraryGeneration.getProperties());
        this.notifyListeners();
    }

    static enum ClasspathType {
        FOLDER("Folders", "dir", "cls.library.folder.invalid", true, false),
        FILE("Files", "name", "cls.library.file.invalid", false, true),
        PATH("Paths", "name", "cls.library.path.invalid", true, true);

        final String debugLabel;
        final String attrKey;
        private final String messageId;
        private final boolean allowFolders;
        private final boolean allowFiles;

        boolean accept(File f) {
            if (!f.exists()) {
                return false;
            }
            if (!this.allowFiles) {
                return f.isDirectory();
            }
            if (!this.allowFolders) {
                return !f.isDirectory();
            }
            return true;
        }

        void warn(String displayId, String libraryId, String fileName) {
            if (tc.isWarningEnabled() && !"global".equals(libraryId)) {
                Tr.warning((TraceComponent)tc, (String)this.messageId, (Object[])new Object[]{displayId, fileName});
            }
        }

        private ClasspathType(String debugLabel, String attrKey, String messageId, boolean allowFolders, boolean allowFiles) {
            this.debugLabel = debugLabel;
            this.attrKey = attrKey;
            this.messageId = messageId;
            this.allowFolders = allowFolders;
            this.allowFiles = allowFiles;
        }
    }
}

