/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;

public abstract class JFapByteBuffer {
    private static final TraceComponent tc = SibTr.register(JFapByteBuffer.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    public static final int ENTIRE_BUFFER = -1;
    public static final int DEFAULT_BUFFER_SIZE = 200;
    private static WsByteBufferPool poolMan = WsByteBufferPool.getInstance();
    private boolean valid;
    private boolean released = false;
    private ArrayList<WsByteBuffer> dataList = new ArrayList();
    protected WsByteBuffer receivedBuffer = null;
    protected ReceivedData receivedData = null;

    public JFapByteBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.reset();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public JFapByteBuffer(ReceivedData _receivedData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this.receivedData);
        }
        this.reset(_receivedData);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public JFapByteBuffer(WsByteBuffer _buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this.receivedData);
        }
        this.reset(_buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public synchronized void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset");
        }
        this.valid = true;
        this.released = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    public synchronized void reset(ReceivedData _receivedData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset", (Object)_receivedData);
        }
        this.receivedBuffer = _receivedData.getBuffer();
        this.receivedData = _receivedData;
        this.receivedBuffer.flip();
        this.valid = false;
        this.released = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    public synchronized void reset(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset", (Object)buffer);
        }
        this.receivedBuffer = buffer;
        this.receivedBuffer.flip();
        this.valid = false;
        this.released = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    public synchronized void put(byte item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)item);
        }
        this.checkValid();
        this.getCurrentByteBuffer(1).put(item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put");
        }
    }

    public synchronized void putShort(short item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putShort", (Object)item);
        }
        this.checkValid();
        this.getCurrentByteBuffer(2).putShort(item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putShort");
        }
    }

    public synchronized void putInt(int item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putInt", (Object)item);
        }
        this.checkValid();
        this.getCurrentByteBuffer(4).putInt(item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putInt");
        }
    }

    public synchronized void putLong(long item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putLong", (Object)item);
        }
        this.checkValid();
        this.getCurrentByteBuffer(4).putLong(item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putLong");
        }
    }

    public synchronized void put(byte[] item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)item);
        }
        this.checkValid();
        this.getCurrentByteBuffer(item.length).put(item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put");
        }
    }

    public synchronized void wrap(byte[] item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"wrap", (Object)item);
        }
        this.wrap(item, 0, item.length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"wrap");
        }
    }

    public synchronized void wrap(byte[] item, int offset, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"wrap", (Object)new Object[]{item, offset, length});
        }
        if (this.dataList.size() > 0) {
            WsByteBuffer lastBuffer = this.dataList.get(this.dataList.size() - 1);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Last buffer:", (Object)lastBuffer);
            }
            lastBuffer.flip();
        }
        WsByteBuffer newBuffer = poolMan.wrap(item, offset, length);
        newBuffer = newBuffer.slice();
        newBuffer.position(newBuffer.limit());
        this.dataList.add(newBuffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"wrap");
        }
    }

    public synchronized void setReadOnly() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReadOnly");
        }
        for (int x = 0; x < this.dataList.size(); ++x) {
            WsByteBuffer buff = this.dataList.get(x);
            buff.setReadOnly(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReadOnly");
        }
    }

    public synchronized long prepareForTransmission() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepareForTransmission");
        }
        this.checkValid();
        this.valid = false;
        if (this.dataList.size() > 0) {
            WsByteBuffer buff = this.dataList.get(this.dataList.size() - 1);
            buff.flip();
        }
        long sendAmount = 0L;
        for (int x = 0; x < this.dataList.size(); ++x) {
            WsByteBuffer buff = this.dataList.get(x);
            sendAmount += (long)buff.remaining();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepareForTransmission", (Object)sendAmount);
        }
        return sendAmount;
    }

    public synchronized WsByteBuffer[] getBuffersForTransmission() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBufferForTransmission");
        }
        this.checkNotValid();
        WsByteBuffer[] bufferArray = new WsByteBuffer[this.dataList.size()];
        for (int x = 0; x < this.dataList.size(); ++x) {
            bufferArray[x] = this.dataList.get(x);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBufferForTransmission", this.dataList);
        }
        return bufferArray;
    }

    public synchronized byte get() {
        this.checkReleased();
        return this.receivedBuffer.get();
    }

    public synchronized byte[] get(int numberOfBytes) {
        this.checkReleased();
        byte[] bytes = new byte[numberOfBytes];
        this.receivedBuffer.get(bytes);
        return bytes;
    }

    public synchronized short getShort() {
        this.checkReleased();
        return this.receivedBuffer.getShort();
    }

    public synchronized int getInt() {
        this.checkReleased();
        return this.receivedBuffer.getInt();
    }

    public synchronized long getLong() {
        this.checkReleased();
        return this.receivedBuffer.getLong();
    }

    public synchronized boolean hasRemaining() {
        this.checkReleased();
        return this.receivedBuffer.hasRemaining();
    }

    public synchronized void release() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"release");
        }
        this.released = true;
        this.valid = false;
        if (this.receivedBuffer != null) {
            this.receivedBuffer.release();
            this.receivedBuffer = null;
        }
        if (this.receivedData != null) {
            this.receivedData.release();
            this.receivedData = null;
        }
        if (this.dataList != null) {
            for (int x = 0; x < this.dataList.size(); ++x) {
                this.dataList.get(x).release();
            }
            this.dataList.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"release");
        }
    }

    public synchronized void releasePreservingBuffers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"releasePreservingBuffers");
        }
        this.released = true;
        this.valid = false;
        if (this.receivedData != null) {
            this.receivedData.release();
            this.receivedData = null;
        }
        this.receivedBuffer = null;
        this.dataList.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"releasePreservingBuffers");
        }
    }

    protected void checkValid() throws SIErrorException {
        if (!this.valid) {
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"BUFFER_NOT_VALID_SICJ0074", null, null));
        }
    }

    protected void checkNotValid() throws SIErrorException {
        if (this.valid) {
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"BUFFER_NOT_PREPARED_SICJ0075", null, null));
        }
    }

    protected void checkReleased() throws SIErrorException {
        if (this.released) {
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"BUFFER_ALREADY_RELEASED_SICJ0076", null, null));
        }
    }

    protected WsByteBuffer getCurrentByteBuffer(int sizeNeeded) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCurrentByteBuffer", (Object)sizeNeeded);
        }
        WsByteBuffer byteBuffer = null;
        if (this.dataList.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating first buffer");
            }
            this.dataList = new ArrayList();
            byteBuffer = this.createNewWsByteBuffer(sizeNeeded);
            this.dataList.add(byteBuffer);
        } else {
            byteBuffer = this.dataList.get(this.dataList.size() - 1);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Last buffer: ", (Object)byteBuffer);
            }
            if (byteBuffer.remaining() < sizeNeeded) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No room in buffer, creating a new one");
                }
                byteBuffer.flip();
                byteBuffer = this.createNewWsByteBuffer(sizeNeeded);
                this.dataList.add(byteBuffer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCurrentByteBuffer", (Object)byteBuffer);
        }
        return byteBuffer;
    }

    private WsByteBuffer createNewWsByteBuffer(int sizeNeeded) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createNewWsByteBuffer", (Object)sizeNeeded);
        }
        if (sizeNeeded < 200) {
            sizeNeeded = 200;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Allocating a buffer of size: " + sizeNeeded));
        }
        WsByteBuffer buffer = poolMan.allocate(sizeNeeded);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createNewWsByteBuffer", (Object)buffer);
        }
        return buffer;
    }

    public synchronized void prepareForReception() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepareForReception");
        }
        long length = this.prepareForTransmission();
        WsByteBuffer newBuffer = this.createNewWsByteBuffer((int)length);
        for (int x = 0; x < this.dataList.size(); ++x) {
            WsByteBuffer buff = this.dataList.get(x);
            newBuffer.put(buff);
        }
        this.reset(newBuffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepareForReception");
        }
    }

    public String toString() {
        return "JFapByteBuffer@" + Integer.toHexString(System.identityHashCode(this)) + ": { valid=" + this.valid + ", released=" + this.released + ", dataList=" + this.dataList + ", receivedData=" + this.receivedData + ", receivedBuffer=" + this.receivedBuffer + " }";
    }

    public synchronized void dump(Object _this, TraceComponent _tc, int bytesToDump) {
        int bytesRemainingToDump = bytesToDump;
        if (this.receivedBuffer != null) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Buffer contains a single underlying WsByteBuffer:");
            JFapByteBuffer.dump(_this, _tc, this.receivedBuffer, bytesRemainingToDump, false);
        } else {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Buffer contains " + this.dataList.size() + " underlying WsByteBuffer(s):"));
            for (int x = 0; x < this.dataList.size(); ++x) {
                WsByteBuffer buff = this.dataList.get(x);
                JFapByteBuffer.dump(_this, _tc, buff, bytesRemainingToDump, true);
                if (bytesToDump == -1) continue;
                bytesRemainingToDump = buff.remaining() >= bytesRemainingToDump ? 0 : (bytesRemainingToDump -= buff.remaining());
                if (bytesRemainingToDump <= 0) break;
            }
        }
    }

    public synchronized String getDumpReceivedBytes(int bytesToDump) {
        String dump = null;
        if (this.receivedBuffer != null) {
            dump = JFapByteBuffer.getDumpBytes(this.receivedBuffer, bytesToDump, false);
        }
        return dump;
    }

    public static void dump(Object _this, TraceComponent _tc, WsByteBuffer buffer, int bytesToDump, boolean rewind) {
        StringBuffer sb = new StringBuffer();
        sb.append("\nBuffer hashcode:  ");
        sb.append(Integer.toHexString(System.identityHashCode(buffer)));
        sb.append("\nBuffer position:  ");
        sb.append(buffer.position());
        sb.append("\nBuffer remaining: ");
        sb.append(buffer.remaining());
        sb.append("\n");
        SibTr.debug((Object)_this, (TraceComponent)_tc, (String)sb.toString());
        SibTr.debug((Object)_this, (TraceComponent)_tc, (String)JFapByteBuffer.getDumpBytes(buffer, bytesToDump, rewind));
    }

    private static String getDumpBytes(WsByteBuffer buffer, int bytesToDump, boolean rewind) {
        int start;
        int pos = buffer.position();
        if (rewind) {
            buffer.rewind();
        }
        byte[] data = null;
        int count = bytesToDump;
        if (count > buffer.remaining() || count == -1) {
            count = buffer.remaining();
        }
        if (buffer.hasArray()) {
            data = buffer.array();
            start = buffer.arrayOffset() + buffer.position();
        } else {
            data = new byte[count];
            buffer.get(data);
            start = 0;
        }
        String strData = "Dumping " + count + " bytes of buffer data:\r\n";
        if (count > 0) {
            strData = strData + SibTr.formatBytes((byte[])data, (int)start, (int)count);
        }
        if (rewind) {
            buffer.position(pos);
        }
        return strData;
    }
}

