/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.ws.http.channel.internal.values.AccessLogData;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class AccessLogElapsedTime
extends AccessLogData {
    private static ThreadLocal<Long> elapsedTime = new ThreadLocal();

    public AccessLogElapsedTime() {
        super("%D");
    }

    @Override
    public boolean set(StringBuilder accessLogEntry, HttpResponseMessage response, HttpRequestMessage request, Object data) {
        long startTime = AccessLogElapsedTime.getStartTime(response, request, data);
        if (startTime != 0L) {
            long elapsedTimeInMicroseconds = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime);
            elapsedTime.set(elapsedTimeInMicroseconds);
            accessLogEntry.append(elapsedTimeInMicroseconds);
        } else {
            elapsedTime.set(-1L);
            accessLogEntry.append("-");
        }
        return true;
    }

    public static long getStartTime(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        return Objects.nonNull(request) ? request.getStartTime() : 0L;
    }

    public static long getElapsedTimeForJSON(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        return elapsedTime.get();
    }
}

