/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import javax.servlet.Servlet;
import javax.servlet.ServletException;

public class UnavailableException
extends ServletException {
    private final Servlet servlet;
    private final boolean permanent;
    private final int seconds;

    public UnavailableException(Servlet servlet, String msg) {
        super(msg);
        this.servlet = servlet;
        this.permanent = true;
        this.seconds = -1;
    }

    public UnavailableException(int seconds, Servlet servlet, String msg) {
        super(msg);
        this.servlet = servlet;
        this.seconds = seconds <= 0 ? -1 : seconds;
        this.permanent = false;
    }

    public UnavailableException(String msg) {
        super(msg);
        this.servlet = null;
        this.permanent = true;
        this.seconds = -1;
    }

    public UnavailableException(String msg, int seconds) {
        super(msg);
        this.servlet = null;
        this.seconds = seconds <= 0 ? -1 : seconds;
        this.permanent = false;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public int getUnavailableSeconds() {
        return this.permanent ? -1 : this.seconds;
    }
}

