/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.KeyAlgorithmChecker;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.common.http.SocialLoginWrapperException;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.common.jwk.impl.Jose4jEllipticCurveJWK;
import com.ibm.ws.security.common.jwk.impl.Jose4jRsaJWK;
import com.ibm.ws.security.common.jwk.impl.PemKeyUtil;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.ws.security.common.ssl.NoSSLSocketFactoryException;
import com.ibm.ws.security.common.ssl.SecuritySSLUtils;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwKRetriever {
    private static final TraceComponent tc = Tr.register(JwKRetriever.class, null, null);
    static final String PEM_BEGIN_TOKEN = "-----BEGIN";
    static final String PEM_END_TOKEN = "--END--";
    static final String JWKS = "keys";
    static final String JSON_START = "{";
    String configId = null;
    String sslConfigurationName = null;
    boolean defaultSSLConfig = false;
    String jwkEndpointUrl = null;
    String sigAlg = null;
    JWKSet jwkSet = null;
    SSLSupport sslSupport = null;
    String keyFileName = null;
    boolean hostNameVerificationEnabled = true;
    String jwkClientId = null;
    String jwkClientSecret = null;
    @Sensitive
    String keyLocation = null;
    @Sensitive
    String keyText = null;
    String locationUsed = null;
    public HttpUtils httpUtils;
    static final long serialVersionUID = -3823779430622606765L;

    public JwKRetriever(JWKSet jwkSet) {
        this.jwkSet = jwkSet;
        this.httpUtils = new HttpUtils();
    }

    protected void setHttpUtils(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    public JwKRetriever(String configId, String sslConfigurationName, String jwkEndpointUrl, JWKSet jwkSet, SSLSupport sslSupport, boolean hnvEnabled, String jwkClientId, @Sensitive String jwkClientSecret, String signatureAlgorithm) {
        this(configId, sslConfigurationName, jwkEndpointUrl, jwkSet, sslSupport, hnvEnabled, jwkClientId, jwkClientSecret, signatureAlgorithm, null, null);
    }

    public JwKRetriever(String configId, String sslConfigurationName, String jwkEndpointUrl, JWKSet jwkSet, SSLSupport sslSupport, boolean hnvEnabled, String jwkClientId, @Sensitive String jwkClientSecret, String signatureAlgorithm, @Sensitive String keyText, @Sensitive String keyLocation) {
        this.configId = configId;
        this.sslConfigurationName = sslConfigurationName;
        this.jwkEndpointUrl = jwkEndpointUrl;
        this.jwkSet = jwkSet;
        this.sslSupport = sslSupport;
        this.hostNameVerificationEnabled = hnvEnabled;
        this.jwkClientId = jwkClientId;
        this.jwkClientSecret = jwkClientSecret;
        this.sigAlg = signatureAlgorithm;
        this.keyText = keyText;
        this.keyLocation = keyLocation;
        this.httpUtils = new HttpUtils();
    }

    public void defaultssl() {
        this.defaultSSLConfig = true;
    }

    public boolean isdefaultssl() {
        return this.defaultSSLConfig;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.sigAlg = signatureAlgorithm;
    }

    public void setKeyText(@Sensitive String keyText) {
        this.keyText = keyText;
    }

    public void setKeyLocation(@Sensitive String keyLocation) {
        this.keyLocation = keyLocation;
    }

    @Sensitive
    public PrivateKey getPrivateKeyFromJwk(String kid, boolean useSystemPropertiesForHttpClientConnections) throws IOException {
        return (PrivateKey)this.getKeyFromJwk(kid, null, null, useSystemPropertiesForHttpClientConnections, JwkKeyType.PRIVATE);
    }

    public PublicKey getPublicKeyFromJwk(String kid, String x5t, boolean useSystemPropertiesForHttpClientConnections) throws IOException {
        return this.getPublicKeyFromJwk(kid, x5t, null, useSystemPropertiesForHttpClientConnections);
    }

    public PublicKey getPublicKeyFromJwk(String kid, String x5t, String use, boolean useSystemPropertiesForHttpClientConnections) throws IOException {
        return (PublicKey)this.getKeyFromJwk(kid, x5t, use, useSystemPropertiesForHttpClientConnections, JwkKeyType.PUBLIC);
    }

    @Sensitive
    Key getKeyFromJwk(String kid, String x5t, String use, boolean useSystemPropertiesForHttpClientConnections, JwkKeyType keyType) throws IOException {
        Key key = null;
        boolean isHttp = this.remoteHttpCall(this.jwkEndpointUrl, this.keyText, this.keyLocation);
        key = isHttp ? this.getJwkRemote(kid, x5t, use, useSystemPropertiesForHttpClientConnections, keyType) : this.getJwkLocal(kid, x5t, this.keyText, this.keyLocation, use, keyType);
        return key;
    }

    @Sensitive
    private Key getJwkFromJWKSet(@Sensitive String setId, String kid, String x5t, String use, @Sensitive String keyText, JwkKeyType keyType) {
        boolean isKeyIdentifierUsed = kid != null || x5t != null;
        Key key = null;
        if (kid != null) {
            key = this.jwkSet.getKeyBySetIdAndKid(setId, kid, keyType);
        } else if (x5t != null) {
            key = this.jwkSet.getKeyBySetIdAndx5t(setId, x5t, keyType);
        } else if (use != null) {
            key = this.jwkSet.getKeyBySetIdAndUse(setId, use, keyType);
        }
        if (key != null) {
            return key;
        }
        if (keyText != null) {
            key = this.jwkSet.getKeyBySetIdAndKeyText(setId, keyText, keyType);
        }
        if (key == null && !isKeyIdentifierUsed) {
            key = this.jwkSet.getKeyBySetId(setId, keyType);
        }
        return key;
    }

    protected boolean remoteHttpCall(String jwksUri, @Sensitive String keyText, @Sensitive String keyLocation) {
        boolean isHttp = true;
        if (jwksUri == null) {
            if (keyText != null) {
                isHttp = false;
            } else if (keyLocation != null && !keyLocation.startsWith("http")) {
                isHttp = false;
            }
        }
        return isHttp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensitive
    @FFDCIgnore(value={Exception.class})
    protected Key getKeyFromFile(@Sensitive String location, String kid, String x5t, String use, JwkKeyType keyType) {
        Key key;
        block15: {
            key = null;
            String keyString = null;
            String classLoadingCacheSelector = null;
            String fileSystemCacheSelector = null;
            File jwkFile = null;
            try {
                String keyFile;
                classLoadingCacheSelector = Thread.currentThread().getContextClassLoader().toString() + location;
                if (location.startsWith("file:")) {
                    URI uri = new URI(location);
                    keyFile = uri.getPath();
                } else {
                    keyFile = location;
                }
                jwkFile = new File(keyFile);
                fileSystemCacheSelector = jwkFile.getCanonicalPath();
                JWKSet jWKSet = this.jwkSet;
                synchronized (jWKSet) {
                    key = this.getJwkFromJWKSet(fileSystemCacheSelector, kid, x5t, use, null, keyType);
                    if (key == null) {
                        key = this.getJwkFromJWKSet(classLoadingCacheSelector, kid, x5t, use, null, keyType);
                    }
                    if (key == null) {
                        try (InputStream is = null;){
                            is = this.getInputStream(jwkFile, fileSystemCacheSelector, location, classLoadingCacheSelector);
                            if (is != null) {
                                keyString = this.getKeyAsString(is);
                                this.parseJwk(keyString, null, this.jwkSet, this.sigAlg);
                                key = this.getJwkFromJWKSet(this.locationUsed, kid, x5t, use, keyString, keyType);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug((TraceComponent)tc, (String)("Caught exception opening file from location [" + location + "]: " + e), (Object[])new Object[0]);
            }
        }
        return key;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    protected InputStream getInputStream(final @Sensitive File f, @Sensitive String fileSystemSelector, @Sensitive String location, @Sensitive String classLoadingSelector) throws IOException {
        if (f != null) {
            FileInputStream is = null;
            try {
                is = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = 692077785079817151L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    @Sensitive
                    public Object run() throws Exception {
                        if (f.exists()) {
                            return new FileInputStream(f);
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.jwk.impl.JwKRetriever$1", 1.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (is != null) {
                this.locationUsed = fileSystemSelector;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("input stream obtained from file system and locationUsed set to: " + this.getSafeTraceableString(this.locationUsed)), (Object[])new Object[0]);
                }
                return is;
            }
        }
        URL u = Thread.currentThread().getContextClassLoader().getResource(location);
        this.locationUsed = classLoadingSelector;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("input stream obtained from classloader and  locationUsed set to: " + this.getSafeTraceableString(this.locationUsed)), (Object[])new Object[0]);
        }
        if (u != null) {
            return u.openStream();
        }
        return null;
    }

    @Trivial
    private String getSafeTraceableString(@Sensitive String input) {
        if (input == null || !input.contains(PEM_BEGIN_TOKEN)) {
            return input;
        }
        return this.locationUsed.substring(0, this.locationUsed.indexOf(PEM_BEGIN_TOKEN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensitive
    protected Key getJwkLocal(String kid, String x5t, @Sensitive String keyText, @Sensitive String location, String use, JwkKeyType keyType) {
        if (keyText == null && location != null) {
            return this.getKeyFromFile(location, kid, x5t, use, keyType);
        }
        if (keyText != null) {
            JWKSet jWKSet = this.jwkSet;
            synchronized (jWKSet) {
                Key key = this.getJwkFromJWKSet(keyText, kid, x5t, use, keyText, keyType);
                if (key == null) {
                    this.parseJwk(keyText, null, this.jwkSet, this.sigAlg);
                    key = this.getJwkFromJWKSet(keyText, kid, x5t, use, keyText, keyType);
                }
                return key;
            }
        }
        return null;
    }

    @Sensitive
    protected String getKeyAsString(InputStream fis) {
        StringBuilder sb = new StringBuilder();
        try {
            InputStreamReader r = new InputStreamReader(fis, StandardCharsets.UTF_8);
            int ch = r.read();
            while (ch >= 0) {
                sb.append((char)ch);
                ch = r.read();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.common.jwk.impl.JwKRetriever", (String)"370", (Object)this, (Object[])new Object[]{fis});
        }
        return sb.toString();
    }

    protected boolean isPEM(@Sensitive String key) {
        return key != null && key.startsWith(PEM_BEGIN_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensitive
    protected Key getJwkRemote(String kid, String x5t, String use, boolean useSystemPropertiesForHttpClientConnections, JwkKeyType keyType) throws IOException {
        this.locationUsed = this.jwkEndpointUrl;
        if (this.locationUsed == null) {
            this.locationUsed = this.keyLocation;
        }
        if (this.locationUsed == null || !this.locationUsed.startsWith("http")) {
            return null;
        }
        Key key = null;
        JWKSet jWKSet = this.jwkSet;
        synchronized (jWKSet) {
            key = this.getJwkFromJWKSet(this.locationUsed, kid, x5t, use, null, keyType);
            if (key == null) {
                key = this.doJwkRemote(kid, x5t, use, useSystemPropertiesForHttpClientConnections, keyType);
            }
        }
        return key;
    }

    @FFDCIgnore(value={IOException.class, Exception.class})
    protected Key doJwkRemote(String kid, String x5t, String use, boolean useSystemPropertiesForHttpClientConnections, JwkKeyType keyType) throws IOException {
        String jsonString;
        block6: {
            jsonString = null;
            this.locationUsed = this.jwkEndpointUrl;
            if (this.locationUsed == null) {
                this.locationUsed = this.keyLocation;
            }
            try {
                HttpClient client;
                boolean bJwk;
                SSLSocketFactory sslSocketFactory = null;
                if (this.locationUsed != null && this.locationUsed.toLowerCase().startsWith("https")) {
                    sslSocketFactory = this.getSSLSocketFactory(this.locationUsed, this.sslConfigurationName, this.sslSupport);
                }
                if (!(bJwk = this.parseJwk(jsonString = this.getHTTPRequestAsString(client = this.createHTTPClient(sslSocketFactory, this.locationUsed, this.hostNameVerificationEnabled, useSystemPropertiesForHttpClientConnections), this.locationUsed), null, this.jwkSet, this.sigAlg)) && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No JWK can be found through '" + this.locationUsed + "'"), (Object[])new Object[0]);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)("Fail to retrieve remote key: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return this.getJwkFromJWKSet(this.locationUsed, kid, x5t, use, jsonString, keyType);
    }

    private String logCWWKS6049E(String url, int iStatusCode, String errMsg) {
        String defaultMessage = "CWWKS6049E: A JSON Web Key (JWK) was not returned from the URL [" + url + "]. The response status was [" + iStatusCode + "] and the content returned was [" + errMsg + "].";
        String message = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages", (String)"JWT_JWK_RETRIEVE_FAILED", (Object[])new Object[]{url, iStatusCode, errMsg}, (String)defaultMessage);
        Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        return message;
    }

    @FFDCIgnore(value={SocialLoginWrapperException.class, IOException.class})
    protected String getHTTPRequestAsString(HttpClient client, String url) throws Exception, IOException {
        String jsonString = null;
        try {
            jsonString = this.httpUtils.getHttpJsonRequest(client, url);
        }
        catch (IOException ioex) {
            this.logCWWKS6049E(url, 0, "IOException: " + ioex.getMessage() + " " + ioex.getCause());
            throw ioex;
        }
        catch (SocialLoginWrapperException sle) {
            Throwable cause = sle.getCause();
            if (cause != null && cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new Exception(this.logCWWKS6049E(url, sle.getStatusCode(), sle.getNlsMessage()), sle);
        }
        return jsonString;
    }

    public boolean parseJwk(@Sensitive String keyText, FileInputStream inputStream, JWKSet jwkset, String signatureAlgorithm) {
        boolean bJwk = false;
        if (keyText != null) {
            bJwk = this.parseKeyText(keyText, this.locationUsed, jwkset, signatureAlgorithm);
        } else if (inputStream != null) {
            String keyAsString = this.getKeyAsString(inputStream);
            bJwk = this.parseKeyText(keyAsString, this.locationUsed, jwkset, signatureAlgorithm);
        }
        return bJwk;
    }

    protected boolean parseKeyText(@Sensitive String keyText, String location, JWKSet jwkset, String signatureAlgorithm) {
        HashSet<JWK> jwks = new HashSet<JWK>();
        JWK jwk = null;
        if (this.isPEM(keyText) && this.isPemSupportedAlgorithm(signatureAlgorithm)) {
            jwk = this.parsePEMFormat(keyText, signatureAlgorithm);
        } else {
            JSONObject jsonObject = this.parseJsonObject(keyText);
            if (jsonObject != null && (jwk = this.parseJwkFormat(jsonObject, signatureAlgorithm)) == null && jsonObject.containsKey((Object)JWKS)) {
                jwks.addAll(this.parseJwksFormat(jsonObject, signatureAlgorithm));
            }
        }
        if (jwk != null) {
            jwks.add(jwk);
        }
        for (JWK aJwk : jwks) {
            if (this.isPEM(keyText)) {
                this.jwkSet.addPemKey(location, keyText, jwk);
            }
            if (location != null) {
                this.jwkSet.add(location, aJwk);
            }
            if (keyText == null) continue;
            this.jwkSet.add(keyText, aJwk);
        }
        return !jwks.isEmpty();
    }

    boolean isPemSupportedAlgorithm(String signatureAlgorithm) {
        return KeyAlgorithmChecker.isRSAlgorithm((String)signatureAlgorithm) || KeyAlgorithmChecker.isESAlgorithm((String)signatureAlgorithm);
    }

    @Sensitive
    @FFDCIgnore(value={Exception.class})
    private JWK parsePEMFormat(@Sensitive String keyText, String signatureAlgorithm) {
        JWK jwk;
        block4: {
            jwk = null;
            try {
                PemKeyUtil.KeyType keyType = PemKeyUtil.getKeyType(keyText);
                if (this.isPublicKeyJwk(keyType)) {
                    return this.parsePublicKeyJwk(keyText, signatureAlgorithm);
                }
                if (keyType == PemKeyUtil.KeyType.PRIVATE) {
                    return this.parsePrivateKeyJwk(keyText, signatureAlgorithm);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing PEM file: " + e), (Object[])new Object[0]);
            }
        }
        return jwk;
    }

    boolean isPublicKeyJwk(PemKeyUtil.KeyType keyType) {
        return keyType == PemKeyUtil.KeyType.RSA_PUBLIC || keyType == PemKeyUtil.KeyType.EC_PUBLIC || keyType == PemKeyUtil.KeyType.PUBLIC || keyType == PemKeyUtil.KeyType.UNKNOWN;
    }

    JWK parsePublicKeyJwk(String keyText, String signatureAlgorithm) throws Exception {
        PublicKey pubKey = PemKeyUtil.getPublicKey(keyText);
        if (KeyAlgorithmChecker.isESAlgorithm((String)signatureAlgorithm)) {
            return this.getEcJwkPublicKey(pubKey, signatureAlgorithm);
        }
        return this.getRsaJwkPublicKey(pubKey, signatureAlgorithm);
    }

    @Sensitive
    JWK parsePrivateKeyJwk(@Sensitive String keyText, String signatureAlgorithm) throws Exception {
        PrivateKey privateKey = PemKeyUtil.getPrivateKey(keyText);
        if (KeyAlgorithmChecker.isESAlgorithm((String)signatureAlgorithm)) {
            return this.getEcJwkPrivateKey(privateKey, signatureAlgorithm);
        }
        return this.getRsaJwkPrivateKey(privateKey, signatureAlgorithm);
    }

    @FFDCIgnore(value={Exception.class})
    private Jose4jEllipticCurveJWK getEcJwkPublicKey(PublicKey publicKey, String signatureAlgorithm) {
        Jose4jEllipticCurveJWK jwk;
        block4: {
            if (!(publicKey instanceof ECPublicKey)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Provided public key was not of type ECPublicKey", (Object[])new Object[0]);
                }
                return null;
            }
            jwk = null;
            try {
                jwk = Jose4jEllipticCurveJWK.getInstance((ECPublicKey)publicKey, signatureAlgorithm, "sig");
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception instantiating EC JWK object: " + e), (Object[])new Object[0]);
            }
        }
        return jwk;
    }

    @Sensitive
    @FFDCIgnore(value={Exception.class})
    private Jose4jEllipticCurveJWK getEcJwkPrivateKey(@Sensitive PrivateKey privateKey, String signatureAlgorithm) {
        Jose4jEllipticCurveJWK jwk;
        block4: {
            if (!(privateKey instanceof ECPrivateKey)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Provided private key was not of type ECPrivateKey", (Object[])new Object[0]);
                }
                return null;
            }
            jwk = null;
            try {
                jwk = Jose4jEllipticCurveJWK.getInstance(null, signatureAlgorithm, "sig");
                jwk.setPrivateKey(privateKey);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception instantiating EC JWK object: " + e), (Object[])new Object[0]);
            }
        }
        return jwk;
    }

    @FFDCIgnore(value={Exception.class})
    private Jose4jRsaJWK getRsaJwkPublicKey(PublicKey pubKey, String signatureAlgorithm) {
        Jose4jRsaJWK jwk = null;
        try {
            jwk = new Jose4jRsaJWK((RSAPublicKey)pubKey);
            jwk.setAlgorithm(signatureAlgorithm);
            jwk.setUse("sig");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jwk;
    }

    @Sensitive
    @FFDCIgnore(value={Exception.class})
    private Jose4jRsaJWK getRsaJwkPrivateKey(@Sensitive PrivateKey privateKey, String signatureAlgorithm) {
        Jose4jRsaJWK jwk = null;
        try {
            jwk = Jose4jRsaJWK.getInstance(signatureAlgorithm, null, null, privateKey, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jwk;
    }

    @Sensitive
    private JWK parseJwkFormat(@Sensitive JSONObject jsonObject, String signatureAlgorithm) {
        JWK jwk = null;
        Object ktyEntry = jsonObject.get((Object)"kty");
        if (ktyEntry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JSON object is missing 'kty' entry", (Object[])new Object[0]);
            }
            return null;
        }
        if (!(ktyEntry instanceof String)) {
            return null;
        }
        String kty = (String)ktyEntry;
        jwk = this.createJwkBasedOnKty(kty, jsonObject, signatureAlgorithm);
        if (jwk != null) {
            jwk.parse();
        }
        return jwk;
    }

    @Sensitive
    private Set<JWK> parseJwksFormat(@Sensitive JSONObject jsonObject, String signatureAlgorithm) {
        Set<JWK> jwks = Collections.emptySet();
        JSONArray keys = new JSONArray();
        Object keysEntry = jsonObject.get((Object)JWKS);
        if (keysEntry != null) {
            jwks = new HashSet<JWK>();
            keys = this.parseJsonArray(keysEntry.toString());
            for (Object element : keys) {
                JWK jwk;
                JSONObject jwkJson = this.parseJsonObject(element.toString());
                if (jwkJson == null || (jwk = this.parseJwkFormat(jwkJson, signatureAlgorithm)) == null) continue;
                jwks.add(jwk);
            }
        }
        return jwks;
    }

    @Sensitive
    @FFDCIgnore(value={Exception.class})
    JSONObject parseJsonObject(@Sensitive String jsonString) {
        JSONObject jsonObject;
        block4: {
            jsonObject = null;
            if (jsonString == null) {
                return null;
            }
            jsonString = jsonString.trim();
            try {
                if (!jsonString.startsWith(JSON_START)) {
                    jsonString = new String(Base64.decodeBase64((String)jsonString), StandardCharsets.UTF_8);
                }
                jsonObject = JSONObject.parse((String)jsonString);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing JSON string [" + jsonString + "]: " + e), (Object[])new Object[0]);
            }
        }
        return jsonObject;
    }

    @Sensitive
    @FFDCIgnore(value={Exception.class})
    JSONObject parseJsonObject(InputStream is) {
        JSONObject jsonObject;
        block2: {
            jsonObject = null;
            try {
                jsonObject = JSONObject.parse((InputStream)is);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing input stream [" + is.toString() + "]: " + e), (Object[])new Object[0]);
            }
        }
        return jsonObject;
    }

    @Sensitive
    @FFDCIgnore(value={Exception.class})
    JSONArray parseJsonArray(@Sensitive String jsonString) {
        JSONArray jsonArray;
        block2: {
            jsonArray = null;
            try {
                jsonArray = JSONArray.parse((String)jsonString);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing JSON string [" + jsonString + "]: " + e), (Object[])new Object[0]);
            }
        }
        return jsonArray;
    }

    @Sensitive
    JWK createJwkBasedOnKty(String kty, @Sensitive JSONObject keyEntry, String signatureAlgorithm) {
        JWK jwk = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("kty of JWK is '" + kty + "'"), (Object[])new Object[0]);
        }
        if ("RSA".equalsIgnoreCase(kty)) {
            jwk = this.getRsaJwk(keyEntry);
        } else if ("EC".equalsIgnoreCase(kty)) {
            jwk = this.getEllipticCurveJwk(keyEntry, signatureAlgorithm);
        }
        return jwk;
    }

    @Sensitive
    JWK getRsaJwk(@Sensitive JSONObject thing) {
        return Jose4jRsaJWK.getInstance(thing);
    }

    @Sensitive
    JWK getEllipticCurveJwk(@Sensitive JSONObject thing, String signatureAlgorithm) {
        if (signatureAlgorithm != null && signatureAlgorithm.startsWith("ES")) {
            return Jose4jEllipticCurveJWK.getInstance(thing);
        }
        return null;
    }

    protected JSSEHelper getJSSEHelper(SSLSupport sslSupport) throws com.ibm.websphere.ssl.SSLException {
        if (sslSupport != null) {
            return sslSupport.getJSSEHelper();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NoSSLSocketFactoryException.class})
    protected SSLSocketFactory getSSLSocketFactory(String requestUrl, String sslConfigurationName, SSLSupport sslSupport) throws com.ibm.websphere.ssl.SSLException {
        SSLSocketFactory sslSocketFactory;
        block3: {
            sslSocketFactory = null;
            try {
                sslSocketFactory = this.isdefaultssl() ? SecuritySSLUtils.getSSLSocketFactory((SSLSupport)sslSupport) : SecuritySSLUtils.getSSLSocketFactory((SSLSupport)sslSupport, (String)sslConfigurationName);
            }
            catch (SSLException sSLException) {
                void e;
                FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.security.common.jwk.impl.JwKRetriever", (String)"781", (Object)this, (Object[])new Object[]{requestUrl, sslConfigurationName, sslSupport});
                throw new com.ibm.websphere.ssl.SSLException((Exception)e);
            }
            catch (NoSSLSocketFactoryException e) {
                if (requestUrl == null || !requestUrl.startsWith("https")) break block3;
                throw new com.ibm.websphere.ssl.SSLException(Tr.formatMessage((TraceComponent)tc, (String)"JWT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl socket factory", this.configId}));
            }
        }
        return sslSocketFactory;
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) {
        HttpClient client = null;
        if (this.jwkClientId != null && this.jwkClientSecret != null) {
            BasicCredentialsProvider credentialsProvider = this.httpUtils.createCredentialsProvider(this.jwkClientId, this.jwkClientSecret);
            client = this.httpUtils.createHttpClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections, credentialsProvider);
        } else {
            client = this.httpUtils.createHttpClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections, null);
        }
        return client;
    }

    public static enum JwkKeyType {
        PUBLIC,
        PRIVATE;

    }
}

