/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

import com.ibm.ws.logging.data.KeyValueIntegerPair;
import com.ibm.ws.logging.data.KeyValueLongPair;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.KeyValueStringPair;
import java.util.Arrays;

public class GenericData {
    private static final int DEFAULT_SIZE = 16;
    private KeyValuePair[] pairs;
    private String sourceName;
    private String jsonMessage = null;
    private int lastIndex = -1;

    public GenericData() {
        this.pairs = new KeyValuePair[16];
    }

    public GenericData(int size) {
        this.pairs = new KeyValuePair[size];
    }

    public GenericData(String sourceName) {
        this(sourceName, 16);
    }

    public GenericData(String sourceName, int size) {
        this.sourceName = sourceName;
        this.pairs = new KeyValuePair[size];
    }

    public void setPair(int index, String key, String value) {
        KeyValueStringPair kvp = new KeyValueStringPair(key, value);
        this.ensureCapacityAndSetPair(index, kvp);
    }

    public void setPair(int index, String key, int value) {
        KeyValueIntegerPair kvp = new KeyValueIntegerPair(key, value);
        this.ensureCapacityAndSetPair(index, kvp);
    }

    public void setPair(int index, String key, long value) {
        KeyValueLongPair kvp = new KeyValueLongPair(key, value);
        this.ensureCapacityAndSetPair(index, kvp);
    }

    public void setPair(int index, KeyValuePairList kvps) {
        this.ensureCapacityAndSetPair(index, kvps);
    }

    public void addPair(String key, String value) {
        KeyValueStringPair kvp = new KeyValueStringPair(key, value);
        this.ensureCapacityAndAddPair(kvp);
    }

    public void addPair(String key, int value) {
        KeyValueIntegerPair kvp = new KeyValueIntegerPair(key, value);
        this.ensureCapacityAndAddPair(kvp);
    }

    public void addPair(String key, long value) {
        KeyValueLongPair kvp = new KeyValueLongPair(key, value);
        this.ensureCapacityAndAddPair(kvp);
    }

    public void addPair(KeyValuePairList kvps) {
        this.ensureCapacityAndAddPair(kvps);
    }

    private void ensureCapacityAndAddPair(KeyValuePair kvp) {
        if (this.lastIndex + 1 < this.pairs.length) {
            this.pairs[++this.lastIndex] = kvp;
        } else {
            this.pairs = Arrays.copyOf(this.pairs, Math.max(this.pairs.length + (this.pairs.length >> 1), 16));
            this.pairs[++this.lastIndex] = kvp;
        }
    }

    private void ensureCapacityAndSetPair(int index, KeyValuePair kvp) {
        if (index < this.pairs.length) {
            this.pairs[index] = kvp;
        } else {
            this.pairs = Arrays.copyOf(this.pairs, Math.max(index + (index >> 1), 16));
            this.pairs[index] = kvp;
        }
        this.setLastIndex(index);
    }

    private void setLastIndex(int index) {
        this.lastIndex = index > this.lastIndex ? index : this.lastIndex;
    }

    protected String getStringValue(int index) {
        KeyValueStringPair kvp = (KeyValueStringPair)this.pairs[index];
        return kvp == null ? null : kvp.getStringValue();
    }

    protected int getIntValue(int index) {
        KeyValueIntegerPair kvp = (KeyValueIntegerPair)this.pairs[index];
        return kvp.getIntValue();
    }

    protected long getLongValue(int index) {
        KeyValueLongPair kvp = (KeyValueLongPair)this.pairs[index];
        return kvp.getLongValue();
    }

    public KeyValuePair[] getPairs() {
        return this.pairs;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String comma = ",";
        sb.append("GenericData [");
        sb.append("type=" + this.sourceName);
        for (KeyValuePair p : this.pairs) {
            if (p == null || p.isList()) continue;
            KeyValuePair kvp = p;
            String key = kvp.getKey();
            sb.append(comma);
            if (this.sourceName.equals("com.ibm.ws.logging.ffdc.source.ffdcsource") && key.equals("ibm_threadId")) {
                key = "threadID";
            }
            if (kvp.isInteger()) {
                sb.append(key + "=" + kvp.getIntValue());
                continue;
            }
            if (kvp.isLong()) {
                sb.append(key + "=" + kvp.getLongValue());
                continue;
            }
            sb.append(key + "=" + kvp.getStringValue());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getJsonMessage() {
        return this.jsonMessage;
    }

    public void setJsonMessage(String jsonMessage) {
        this.jsonMessage = jsonMessage;
    }
}

