/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.compression;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.http.channel.compression.CompressionHandler;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Deflater;

public class DeflateOutputHandler
implements CompressionHandler {
    private static final TraceComponent tc = Tr.register(DeflateOutputHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private Deflater deflater = null;
    private byte[] buf = null;

    public DeflateOutputHandler() {
        this.buf = new byte[32768];
        this.deflater = new Deflater(-1, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created a deflate output handler; " + this + " with buffer size 32768"), (Object[])new Object[0]);
        }
    }

    public DeflateOutputHandler(Integer bufferSize) {
        this.buf = new byte[bufferSize.intValue()];
        this.deflater = new Deflater(-1, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created a deflate output handler; " + this + " with buffer size " + bufferSize), (Object[])new Object[0]);
        }
    }

    public DeflateOutputHandler(byte[] useragent) {
        this.buf = new byte[32768];
        if (null != useragent && this.isIEBrowser(useragent)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("User-Agent indicates IE browser [" + GenericUtils.getEnglishString(useragent) + "]"), (Object[])new Object[0]);
            }
            this.deflater = new Deflater(-1, true);
        } else {
            this.deflater = new Deflater(-1, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created a deflate output handler; " + this + " with buffer size 32768"), (Object[])new Object[0]);
        }
    }

    public DeflateOutputHandler(byte[] useragent, Integer bufferSize) {
        this.buf = new byte[bufferSize.intValue()];
        if (null != useragent && this.isIEBrowser(useragent)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("User-Agent indicates IE browser [" + GenericUtils.getEnglishString(useragent) + "]"), (Object[])new Object[0]);
            }
            this.deflater = new Deflater(-1, true);
        } else {
            this.deflater = new Deflater(-1, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created a deflate output handler; " + this + " with buffer size " + bufferSize), (Object[])new Object[0]);
        }
    }

    private boolean isIEBrowser(byte[] agent) {
        int end = agent.length - 4;
        int i = 0;
        while (i < end) {
            if (77 == agent[i]) {
                if (83 != agent[++i] || 73 != agent[++i] || 69 != agent[++i]) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public List<WsByteBuffer> compress(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("compress, input=" + buffer), (Object[])new Object[0]);
        }
        List<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        list = this.compress(list, buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("compress, return list of size " + list.size()));
        }
        return list;
    }

    @Override
    public List<WsByteBuffer> compress(WsByteBuffer[] buffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("compress, input=" + buffers), (Object[])new Object[0]);
        }
        List<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        if (null != buffers) {
            for (int i = 0; i < buffers.length; ++i) {
                list = this.compress(list, buffers[i]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("compress, return list of size " + list.size()));
        }
        return list;
    }

    @Override
    public ContentEncodingValues getContentEncoding() {
        return ContentEncodingValues.DEFLATE;
    }

    @Override
    public List<WsByteBuffer> finish() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finish", (Object[])new Object[0]);
        }
        LinkedList<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        if (this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"finish, previously finished");
            }
            return list;
        }
        WsByteBuffer buffer = null;
        this.deflater.finish();
        while (!this.deflater.finished()) {
            int num = this.deflater.deflate(this.buf, 0, this.buf.length);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Compressed amount=" + num + " read=" + this.deflater.getBytesRead() + " written=" + this.deflater.getBytesWritten()), (Object[])new Object[0]);
            }
            if (0 >= num) continue;
            buffer = this.makeBuffer(num);
            list.add(buffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finish, return list of size " + list.size()));
        }
        return list;
    }

    @Override
    public List<WsByteBuffer> flush(boolean isFinal) {
        int len;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flush", (Object[])new Object[0]);
        }
        LinkedList<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        if (this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"flush, already finished");
            }
            return list;
        }
        if (isFinal) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flush for final write called, calling finish() on the compression handler", (Object[])new Object[0]);
            }
            return this.finish();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"flush for non-final write called, performing intermediate flush without finishing the compression stream", (Object[])new Object[0]);
        }
        int offset = 0;
        while ((len = this.deflater.deflate(this.buf, offset, this.buf.length - offset, 2)) > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Compressed amount=" + len + " read=" + this.deflater.getBytesRead() + " written=" + this.deflater.getBytesWritten()), (Object[])new Object[0]);
            }
            if ((offset += len) != this.buf.length) continue;
            list.add(this.makeBuffer(offset));
            offset = 0;
        }
        if (offset > 0) {
            list.add(this.makeBuffer(offset));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("flush, return list of size " + list.size()));
        }
        return list;
    }

    @Override
    public boolean isFinished() {
        return this.deflater.finished();
    }

    protected List<WsByteBuffer> compress(List<WsByteBuffer> list, WsByteBuffer buffer) {
        int dataSize;
        int n = dataSize = null != buffer ? buffer.remaining() : 0;
        if (0 == dataSize) {
            return list;
        }
        byte[] input = null;
        int initOffset = 0;
        if (buffer.hasArray()) {
            input = buffer.array();
            initOffset = buffer.arrayOffset() + buffer.position();
            buffer.position(buffer.limit());
        } else {
            input = new byte[dataSize];
            buffer.get(input);
        }
        this.deflater.setInput(input, initOffset, dataSize);
        int offset = 0;
        while (!this.deflater.needsInput()) {
            int len = this.deflater.deflate(this.buf, offset, this.buf.length - offset);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Compressed amount=" + len + " read=" + this.deflater.getBytesRead() + " written=" + this.deflater.getBytesWritten()), (Object[])new Object[0]);
            }
            if (0 == len) break;
            if ((offset += len) != this.buf.length) continue;
            list.add(this.makeBuffer(offset));
            offset = 0;
        }
        if (0 < offset) {
            list.add(this.makeBuffer(offset));
        }
        return list;
    }

    private WsByteBuffer makeBuffer(int len) {
        WsByteBuffer buffer = HttpDispatcher.getBufferManager().allocateDirect(len);
        buffer.put(this.buf, 0, len);
        buffer.flip();
        return buffer;
    }

    @Override
    public long getBytesRead() {
        return this.deflater.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.deflater.getBytesWritten();
    }
}

