/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.InputParameterStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;

public class InExpressionStateObject
extends AbstractListHolderStateObject<StateObject> {
    private boolean not;
    private boolean singleInputParameter;
    private StateObject stateObject;
    public static String ITEMS_LIST = "items";
    public static final String NOT_PROPERTY = "not";
    public static final String STATE_OBJECT_PROPERTY = "stateObject";

    public InExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public InExpressionStateObject(StateObject parent, boolean not, String path, List<String> items) {
        super(parent);
    }

    public InExpressionStateObject(StateObject parent, boolean not, String path, String parameter) {
        super(parent);
        this.not = not;
        this.parse(path);
        this.addItem(new InputParameterStateObject(this, parameter));
    }

    public InExpressionStateObject(StateObject parent, StateObject stateObject, boolean not, List<? extends StateObject> items) {
        super(parent, items);
        this.not = not;
        this.stateObject = this.parent(stateObject);
    }

    public InExpressionStateObject(StateObject parent, StateObject stateFieldPath, List<? extends StateObject> items) {
        this(parent, stateFieldPath, false, items);
    }

    public InExpressionStateObject(StateObject parent, String path, List<String> items) {
        this(parent, false, path, items);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        if (this.stateObject != null) {
            children.add(this.stateObject);
        }
        super.addChildren(children);
    }

    public InExpressionStateObject addNot() {
        if (!this.not) {
            this.setNot(true);
        }
        return this;
    }

    @Override
    public InExpression getExpression() {
        return (InExpression)super.getExpression();
    }

    public StateObject getStateObject() {
        return this.stateObject;
    }

    public boolean hasNot() {
        return this.not;
    }

    public boolean hasStateObject() {
        return this.stateObject != null;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            InExpressionStateObject inStateObject = (InExpressionStateObject)stateObject;
            return this.not == inStateObject.not && this.singleInputParameter == inStateObject.singleInputParameter && this.areEquivalent(stateObject, stateObject) && this.areChildrenEquivalent(inStateObject);
        }
        return false;
    }

    public boolean isSingleInputParameter() {
        return this.singleInputParameter;
    }

    @Override
    protected String listName() {
        return ITEMS_LIST;
    }

    public void parse(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "in_expression_item");
        this.setStateObject((StateObject)stateObject);
    }

    public void removeNot() {
        if (this.not) {
            this.setNot(false);
        }
    }

    public void setExpression(InExpression expression) {
        super.setExpression(expression);
    }

    public void setNot(boolean not) {
        boolean oldNot = this.not;
        this.not = not;
        this.firePropertyChanged(NOT_PROPERTY, oldNot, not);
    }

    public void setSingleInputParameter(boolean singleInputParameter) {
        this.singleInputParameter = singleInputParameter;
    }

    public void setStateObject(StateObject stateObject) {
        StateObject oldStateObject = this.stateObject;
        this.stateObject = this.parent(stateObject);
        this.firePropertyChanged(STATE_OBJECT_PROPERTY, oldStateObject, stateObject);
    }

    public void toggleNot() {
        this.setNot(!this.not);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.stateObject != null) {
            this.stateObject.toString(writer);
            writer.append(' ');
        }
        writer.append(this.not ? "NOT IN" : "IN");
        writer.append(' ');
        if (this.singleInputParameter) {
            writer.append('(');
        }
        this.toStringItems(writer, true);
        if (this.singleInputParameter) {
            writer.append(')');
        }
    }
}

