/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.io;

import java.util.Arrays;
import org.apache.yoko.io.ReadBuffer;
import org.apache.yoko.io.WriteBuffer;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.Exceptions;
import org.apache.yoko.util.Hex;
import org.apache.yoko.util.MinorCodes;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_MEMORY;

public abstract class Buffer<T extends Buffer<T>>
implements Cloneable {
    final Core core;
    int position = 0;

    public static ReadBuffer createReadBuffer(byte[] data) {
        return new ReadBuffer(new Core(data));
    }

    public static WriteBuffer createWriteBuffer() {
        return new WriteBuffer(new Core());
    }

    public static WriteBuffer createWriteBuffer(int initialBufferSize) {
        return new WriteBuffer(new Core(initialBufferSize));
    }

    Buffer(Core core) {
        this.core = core;
    }

    public final boolean isComplete() {
        return this.position >= this.length();
    }

    public final int getPosition() {
        return this.position;
    }

    public final int available() {
        return this.length() - this.position;
    }

    public final int length() {
        return this.core.length;
    }

    public final T clone() {
        try {
            return (T)((Buffer)super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw Exceptions.as(INTERNAL::new, e, e.getMessage());
        }
    }

    public final boolean dataEquals(T that) {
        return this == that || that != null && this.core.dataEquals(((Buffer)that).core);
    }

    public final String dumpPosition() {
        return String.format("position=0x%x", this.position);
    }

    public final String dumpAllData() {
        return this.dumpAllData(new StringBuilder()).toString();
    }

    public final StringBuilder dumpAllData(StringBuilder dump) {
        return this.core.dumpTo(dump);
    }

    public final T setPosition(int p) {
        this.position = p;
        return (T)this;
    }

    public final T rewind(int n) {
        this.position -= n;
        return (T)this;
    }

    public abstract ReadBuffer newReadBuffer();

    static byte[] copyOf(byte[] data, int length) {
        try {
            return Arrays.copyOf(data, length);
        }
        catch (OutOfMemoryError oom) {
            throw Exceptions.as(NO_MEMORY::new, oom, MinorCodes.describeNoMemory(1095974913), 1095974913, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    private static byte[] newBytes(int len) {
        try {
            return new byte[len + 255 & 0xFFFFFF00];
        }
        catch (OutOfMemoryError oom) {
            throw Exceptions.as(NO_MEMORY::new, oom, MinorCodes.describeNoMemory(1095974913), 1095974913, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    static final class Core {
        byte[] data;
        int length;

        private Core() {
            this(Buffer.newBytes(16), 0);
        }

        private Core(byte[] data) {
            this(data, data.length);
        }

        private Core(int len) {
            this(Buffer.newBytes(len), len);
        }

        private Core(byte[] data, int len) {
            this.data = data;
            this.length = len;
        }

        boolean growBy(int extra) {
            Assert.ensure(extra >= 0);
            this.length += extra;
            if (this.length <= this.data.length) {
                return false;
            }
            this.data = Buffer.copyOf(this.data, this.computeNewBufferSize(this.length));
            return true;
        }

        private int computeNewBufferSize(int len) {
            int MAX_OVERALLOC = 0x400000;
            int minAlloc = this.data.length + Math.min(this.data.length, 0x400000);
            return Math.max(len, minAlloc);
        }

        boolean dataEquals(Core that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.length != that.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.data[i] == that.data[i]) continue;
                return false;
            }
            return true;
        }

        StringBuilder dumpTo(StringBuilder dump) {
            return Hex.formatHexPara(this.data, 0, this.length, dump);
        }

        public String toString() {
            return new ReadBuffer(this).dumpAllDataWithPosition();
        }
    }
}

