/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl;

import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.Callback;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaProducer;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ProducerRecord;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.RecordMetadata;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.AbstractKafkaAdapter;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.RecordMetadataImpl;
import java.time.Duration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KafkaProducerImpl<K, V>
extends AbstractKafkaAdapter<org.apache.kafka.clients.producer.KafkaProducer<K, V>>
implements KafkaProducer<K, V> {
    private static final String CLAZZ = KafkaProducerImpl.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLAZZ);

    public KafkaProducerImpl(Map<String, Object> producerConfig) {
        super(new org.apache.kafka.clients.producer.KafkaProducer(producerConfig));
    }

    public void send(ProducerRecord<K, V> producerRecord, Callback callback) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLAZZ, "send", "ProducerRecord: {0}", new String[]{producerRecord.toString()});
        }
        org.apache.kafka.clients.producer.ProducerRecord delegateRecord = (org.apache.kafka.clients.producer.ProducerRecord)producerRecord.getDelegate();
        org.apache.kafka.clients.producer.Callback delegateCallback = (m, e) -> {
            org.apache.kafka.clients.producer.RecordMetadata delegateRecordMetadata = m;
            callback.onComplete((RecordMetadata)new RecordMetadataImpl(delegateRecordMetadata), e);
        };
        ((org.apache.kafka.clients.producer.KafkaProducer)this.getDelegate()).send(delegateRecord, delegateCallback);
    }

    public void close(Duration timeout) {
        ((org.apache.kafka.clients.producer.KafkaProducer)this.getDelegate()).close(timeout);
    }
}

