/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor;
import com.ibm.ws.wssecurity.cxf.validator.Utils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.PolicyUtils;
import org.apache.cxf.ws.security.wss4j.SamlTokenInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.processor.SAMLTokenProcessor;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.SamlToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSSecuritySamlTokenInterceptor
extends SamlTokenInterceptor {
    private static final TraceComponent tc = Tr.register(WSSecuritySamlTokenInterceptor.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    public static final String WSSEC = "ws-security";
    public static final String SEC = "security";
    public static final String CXF_SIG_PROPS = "ws-security.signature.properties";
    public static final String CXF_ENC_PROPS = "ws-security.encryption.properties";
    public static final String SEC_SIG_PROPS = "security.signature.properties";
    public static final String SEC_ENC_PROPS = "security.encryption.properties";
    static final long serialVersionUID = 2241612764985541210L;

    public WSSecuritySamlTokenInterceptor() {
        this.addBefore(WSSecurityLibertyCallerInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        boolean isReq = MessageUtils.isRequestor((Message)message);
        boolean isOut = MessageUtils.isOutbound((Message)message);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" isReq:" + isReq + "isOut:" + isOut), (Object[])new Object[0]);
        }
        if (isReq != isOut) {
            super.handleMessage(message);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SamlTokenInterceptor handled(1)", (Object[])new Object[0]);
            }
            return;
        }
        if (isReq) {
            super.handleMessage(message);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SamlTokenInterceptor handled(1)", (Object[])new Object[0]);
            }
            return;
        }
        if (message.containsKey((Object)WSS4JInInterceptor.SECURITY_PROCESSED)) {
            return;
        }
        this.processSamlToken(message);
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private void processSamlToken(SoapMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"processSamlToken(1)", (Object[])new Object[0]);
        }
        Header h = this.findSecurityHeader(message, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processSamlToken(2):" + h), (Object[])new Object[0]);
        }
        if (h == null) {
            return;
        }
        Element el = (Element)h.getObject();
        el = (Element)DOMUtils.getDomElement((Node)el);
        Element child = DOMUtils.getFirstElement((Node)el);
        while (child != null) {
            if ("Assertion".equals(child.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(child.getNamespaceURI())) {
                try {
                    List<WSSecurityEngineResult> samlResults = this.processToken(child, message);
                    if (samlResults != null) {
                        SecurityContext sc;
                        ArrayList<WSHandlerResult> results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
                        if (results == null) {
                            results = new ArrayList<WSHandlerResult>();
                            message.put((Object)"RECV_RESULTS", results);
                        }
                        boolean signed = false;
                        for (WSSecurityEngineResult result : samlResults) {
                            SamlAssertionWrapper wrapper = (SamlAssertionWrapper)result.get((Object)"saml-assertion");
                            if (!wrapper.isSigned()) continue;
                            signed = true;
                            break;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("asserting token , signed = " + signed), (Object[])new Object[0]);
                        }
                        this.assertTokens(message, "SamlToken", signed);
                        Integer key = 8;
                        if (signed) {
                            key = 16;
                        }
                        WSHandlerResult rResult = new WSHandlerResult(null, samlResults, Collections.singletonMap(key, samlResults));
                        results.add(0, rResult);
                        this.assertSamlTokens(message);
                        Principal principal = (Principal)samlResults.get(0).get((Object)"principal");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("principal from the results  = " + principal.toString()), (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)("principal from the results  = " + principal.getName()), (Object[])new Object[0]);
                        }
                        if ((sc = (SecurityContext)message.get(SecurityContext.class)) == null || sc.getUserPrincipal() == null) {
                            message.put(SecurityContext.class, (Object)new DefaultSecurityContext(principal, null));
                        }
                    }
                }
                catch (WSSecurityException samlResults) {
                    void ex;
                    FFDCFilter.processException((Throwable)samlResults, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecuritySamlTokenInterceptor", (String)"207", (Object)((Object)this), (Object[])new Object[]{message});
                    throw WSS4JUtils.createSoapFault((SoapMessage)message, (SoapVersion)message.getVersion(), (WSSecurityException)ex);
                }
            }
            child = DOMUtils.getNextElement((Element)child);
        }
    }

    @Trivial
    private List<WSSecurityEngineResult> processToken(Element tokenElement, final SoapMessage message) throws WSSecurityException {
        Object oe;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processToken(1):" + tokenElement), (Object[])new Object[0]);
        }
        WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
        RequestData data = new RequestData(){
            static final long serialVersionUID = 5304520936804503725L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public CallbackHandler getCallbackHandler() {
                return WSSecuritySamlTokenInterceptor.this.getCallback(message);
            }

            /*
             * WARNING - void declaration
             */
            public Validator getValidator(QName qName) throws WSSecurityException {
                String key = null;
                if (WSConstants.SAML_TOKEN.equals(qName)) {
                    key = "ws-security.saml1.validator";
                } else if (WSConstants.SAML2_TOKEN.equals(qName)) {
                    key = "ws-security.saml2.validator";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found key?:" + (key != null)), (Object[])new Object[0]);
                }
                if (key != null) {
                    Object o = message.getContextualProperty(key);
                    try {
                        if (o instanceof Validator) {
                            return (Validator)o;
                        }
                        if (o instanceof Class) {
                            return (Validator)((Class)o).newInstance();
                        }
                        if (o instanceof String) {
                            return (Validator)ClassLoaderUtils.loadClass((String)o.toString(), WSSecuritySamlTokenInterceptor.class).newInstance();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        void t;
                        FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecuritySamlTokenInterceptor$1", (String)"254", (Object)((Object)this), (Object[])new Object[]{qName});
                        throw t;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecuritySamlTokenInterceptor$1", (String)"256", (Object)((Object)this), (Object[])new Object[]{qName});
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, t.getMessage());
                    }
                }
                return super.getValidator(qName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecuritySamlTokenInterceptor$1", 1.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
            }
        };
        data.setMsgContext((Object)message);
        data.setWssConfig(WSSConfig.getNewInstance());
        data.setWsDocInfo(wsDocInfo);
        SAMLTokenProcessor p = new SAMLTokenProcessor();
        Object o = message.getContextualProperty(CXF_SIG_PROPS);
        if (o == null) {
            o = message.getContextualProperty(SEC_SIG_PROPS);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("found sig object:" + (o != null)), (Object[])new Object[0]);
        }
        if (o != null) {
            Map sigPropsMap = (Map)o;
            Properties sigProps = new Properties();
            sigProps.putAll((Map<?, ?>)sigPropsMap);
            Crypto sigCrypto = CryptoFactory.getInstance((Properties)sigProps);
            data.setDecCrypto(sigCrypto);
        }
        if ((oe = message.getContextualProperty(CXF_ENC_PROPS)) == null) {
            oe = message.getContextualProperty(SEC_ENC_PROPS);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("found enc object:" + (oe != null)), (Object[])new Object[0]);
        }
        if (oe != null) {
            Map encPropsMap = (Map)oe;
            Properties encProps = new Properties();
            encProps.putAll((Map<?, ?>)encPropsMap);
            Crypto encCrypto = CryptoFactory.getInstance((Properties)encProps);
            data.setSigVerCrypto(encCrypto);
        }
        List results = p.handleToken(tokenElement, data);
        return results;
    }

    @Trivial
    private SamlToken assertSamlTokens(SoapMessage message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"assertSamlToken(1)", (Object[])new Object[0]);
        }
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"asserting saml (WssSamlV20Token11) policy! ", (Object[])new Object[0]);
        }
        PolicyUtils.assertPolicy((AssertionInfoMap)aim, (String)"WssSamlV20Token11");
        Collection ais = aim.getAssertionInfo(SP12Constants.SAML_TOKEN);
        SamlToken tok = null;
        for (AssertionInfo ai : ais) {
            tok = (SamlToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"asserting saml token, assertion = ", (Object[])new Object[]{ai.toString()});
        }
        ais = aim.getAssertionInfo(SP12Constants.SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"asserting supporting saml token!", (Object[])new Object[0]);
        }
        ais = aim.getAssertionInfo(SP12Constants.SIGNED_SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"asserting signed supporting saml token!", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("assertSamlToken(2)" + (tok != null)), (Object[])new Object[0]);
        }
        return tok;
    }

    @Trivial
    protected Header findSecurityHeader(SoapMessage message, boolean create) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findSecurityHeader(1) create" + create), (Object[])new Object[0]);
        }
        for (Header h : message.getHeaders()) {
            QName n = h.getName();
            if (!n.getLocalPart().equals("Security") || !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && !n.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) continue;
            return h;
        }
        if (!create) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"findSecurityHeader(2)", (Object[])new Object[0]);
        }
        Document doc = DOMUtils.createDocument();
        Element el = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SoapHeader sh = new SoapHeader(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"), (Object)el);
        sh.setMustUnderstand(true);
        message.getHeaders().add(sh);
        return sh;
    }

    private CallbackHandler getCallback(SoapMessage message) {
        Object o = Utils.getSecurityPropertyValue("security.callback-handler", message);
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), ((Object)((Object)this)).getClass()).newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wssecurity.cxf.interceptor.WSSecuritySamlTokenInterceptor", (String)"388", (Object)((Object)this), (Object[])new Object[]{message});
                handler = null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCallBack():" + handler), (Object[])new Object[0]);
        }
        return handler;
    }
}

