/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.caller;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.saml2.Saml20Attribute;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wssecurity.caller.SamlCallerTokenException;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.registry.RegistryHelper;
import com.ibm.wsspi.security.saml2.UserCredentialResolver;
import com.ibm.wsspi.security.saml2.UserIdentityException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AssertionToSubject {
    private static final TraceComponent tc = Tr.register(AssertionToSubject.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    Saml20Token token = null;
    private final Map<String, Object> callerConfig;
    public static final String KEY_USER_RESOLVER = "userResolver";
    static ConcurrentServiceReferenceMap<String, UserCredentialResolver> activatedUserResolverRef = new ConcurrentServiceReferenceMap("userResolver");
    static final String fixedStr = "_ibm";
    static final long serialVersionUID = 7499811885418360259L;

    public AssertionToSubject(Map<String, Object> callerConfig, Saml20Token token) {
        this.callerConfig = callerConfig;
        this.token = token;
    }

    public static void setActivatedUserResolverRef(ConcurrentServiceReferenceMap<String, UserCredentialResolver> userResolverRef) {
        activatedUserResolverRef = userResolverRef;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activatedUserResolverRef size():" + activatedUserResolverRef.size()), (Object[])new Object[0]);
        }
    }

    public String getUser() throws SamlCallerTokenException {
        String user = null;
        if (activatedUserResolverRef.size() > 0 && (user = this.getUserFromUserResolver(user)) != null && !user.isEmpty()) {
            return user;
        }
        user = this.token.getSAMLNameID();
        String name = (String)this.callerConfig.get("userIdentifier");
        if (name != null && !name.isEmpty()) {
            user = null;
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName()) || attribute.getValuesAsString().size() != 1) continue;
                user = (String)attribute.getValuesAsString().get(0);
            }
            if (user == null) {
                throw new SamlCallerTokenException("SAML20_ATTRIBUTE_ERR", null, false, new Object[]{name, "userIdentifier"});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("user from Token Attributes:" + user), (Object[])new Object[0]);
            }
        }
        if (user == null || user.isEmpty()) {
            throw new SamlCallerTokenException("SAML20_ELEMENT_ERR", null, false, new Object[]{"NameID"});
        }
        return user;
    }

    @FFDCIgnore(value={UserIdentityException.class})
    String getUserFromUserResolver(String user) throws SamlCallerTokenException {
        String userid = null;
        Iterator userIdResolvers = activatedUserResolverRef.getServices();
        if (userIdResolvers.hasNext()) {
            UserCredentialResolver userIdResolver = (UserCredentialResolver)userIdResolvers.next();
            try {
                userid = userIdResolver.mapSAMLAssertionToUser(this.token);
            }
            catch (UserIdentityException e) {
                throw new SamlCallerTokenException("SAML20_CANNOT_RESOLVE_ASSERTION", (Exception)((Object)e), false, new Object[]{e.getMessage()});
            }
        }
        return userid;
    }

    public String getRealm() throws SamlCallerTokenException {
        String realm = null;
        if (activatedUserResolverRef.size() > 0 && (realm = this.getRealmFromUserResolver()) != null && !realm.isEmpty()) {
            return realm;
        }
        realm = (String)this.callerConfig.get("realmName");
        if (realm != null && !realm.isEmpty()) {
            return realm;
        }
        realm = this.token.getSAMLIssuerName();
        String name = (String)this.callerConfig.get("realmIdentifier");
        if (name != null && !name.isEmpty()) {
            realm = null;
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName()) || attribute.getValuesAsString().size() != 1) continue;
                realm = (String)attribute.getValuesAsString().get(0);
            }
            if (realm == null) {
                throw new SamlCallerTokenException("SAML20_ATTRIBUTE_ERR", null, false, new Object[]{name, "realmIdentifier"});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("realm from Token Attributes:" + realm), (Object[])new Object[0]);
            }
        }
        if (realm == null) {
            throw new SamlCallerTokenException("SAML20_ELEMENT_ERR", null, false, new Object[]{"IssuerName"});
        }
        return realm;
    }

    @FFDCIgnore(value={UserIdentityException.class})
    String getRealmFromUserResolver() throws SamlCallerTokenException {
        String realm = null;
        Iterator userIdResolvers = activatedUserResolverRef.getServices();
        if (userIdResolvers.hasNext()) {
            UserCredentialResolver userIdResolver = (UserCredentialResolver)userIdResolvers.next();
            try {
                realm = userIdResolver.mapSAMLAssertionToRealm(this.token);
            }
            catch (UserIdentityException e) {
                throw new SamlCallerTokenException("SAML20_CANNOT_RESOLVE_ASSERTION", (Exception)((Object)e), new Object[]{e.getMessage()});
            }
        }
        return realm;
    }

    public String getUserUniqueIdentity(String user, String realm) throws SamlCallerTokenException {
        String uid = null;
        if (activatedUserResolverRef.size() > 0 && (uid = this.getUserUniqueIDFromUserResolver(user)) != null && !uid.isEmpty()) {
            return uid;
        }
        uid = user;
        String name = (String)this.callerConfig.get("userUniqueIdentifier");
        if (name != null && !name.isEmpty()) {
            uid = null;
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName()) || attribute.getValuesAsString().size() != 1) continue;
                uid = (String)attribute.getValuesAsString().get(0);
            }
            if (uid == null) {
                throw new SamlCallerTokenException("SAML20_ATTRIBUTE_ERR", null, false, new Object[]{name, "userUniqueIdentifier"});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("uniqueUserId from Token Attributes:" + uid), (Object[])new Object[0]);
            }
        }
        if (uid == null) {
            throw new SamlCallerTokenException("SAML20_ELEMENT_ERR", null, false, new Object[]{"NameID"});
        }
        String prefix = "user:" + realm + "/";
        if (!uid.startsWith(prefix)) {
            int userIndex = uid.indexOf("/");
            uid = uid.startsWith("user:") && userIndex > 0 ? prefix + uid.substring(userIndex + 1) : prefix + uid;
        }
        return uid;
    }

    @FFDCIgnore(value={UserIdentityException.class})
    String getUserUniqueIDFromUserResolver(String user) throws SamlCallerTokenException {
        String uid = null;
        Iterator userIdResolvers = activatedUserResolverRef.getServices();
        if (userIdResolvers.hasNext()) {
            UserCredentialResolver userIdResolver = (UserCredentialResolver)userIdResolvers.next();
            try {
                uid = userIdResolver.mapSAMLAssertionToUserUniqueID(this.token);
            }
            catch (UserIdentityException e) {
                throw new SamlCallerTokenException("SAML20_CANNOT_RESOLVE_ASSERTION", (Exception)((Object)e), new Object[]{e.getMessage()});
            }
        }
        return uid;
    }

    public List<String> getGroupUniqueIdentityFromRegistry(String realm) throws WSSecurityException, RemoteException, SamlCallerTokenException {
        List<String> newGroups;
        if (activatedUserResolverRef.size() > 0 && (newGroups = this.getGroupsFromUserResolver()) != null && newGroups.size() > 0) {
            return this.mapGroupsToUserRegistry(newGroups, realm);
        }
        ArrayList<String> groups = new ArrayList<String>();
        String name = (String)this.callerConfig.get("groupIdentifier");
        if (name != null) {
            String idpRealmPrefix = "group:" + realm + "/";
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName()) || attribute.getValuesAsString().isEmpty()) continue;
                for (String idpGroup : attribute.getValuesAsString()) {
                    this.mapGroupToUserRegistry(groups, idpGroup, idpRealmPrefix);
                }
            }
        }
        return groups;
    }

    @FFDCIgnore(value={EntryNotFoundException.class})
    List<String> mapGroupToUserRegistry(List<String> groups, String origGroup, String origRealmPrefix) throws RemoteException, WSSecurityException {
        int groupIndex;
        UserRegistry reg = RegistryHelper.getUserRegistry(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("UserRegistry:" + reg), (Object[])new Object[0]);
        }
        if (origGroup != null && origGroup.startsWith(origRealmPrefix)) {
            origGroup = origGroup.substring(origRealmPrefix.length());
        } else if (origGroup != null && origGroup.startsWith("group:") && (groupIndex = origGroup.indexOf("/")) > 0) {
            origGroup = origGroup.substring(groupIndex + 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("original Group:" + origGroup), (Object[])new Object[0]);
        }
        try {
            String groupDN = reg.getUniqueGroupId(origGroup);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("groupDN from registry:" + groupDN), (Object[])new Object[0]);
            }
            String group = origRealmPrefix + groupDN;
            groups.add(group);
            List localGroups = reg.getUniqueGroupIds(groupDN);
            ListIterator it3 = localGroups.listIterator();
            while (it3.hasNext()) {
                groupDN = (String)it3.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("groupDN from GroupIds:" + groupDN), (Object[])new Object[0]);
                }
                group = origRealmPrefix + groupDN;
                groups.add(group);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        return groups;
    }

    List<String> mapGroupsToUserRegistry(List<String> oldGroups, String realm) throws RemoteException, WSSecurityException {
        String origRealmPrefix = "group:" + realm + "/";
        ArrayList<String> groups = new ArrayList<String>();
        for (String group : oldGroups) {
            this.mapGroupToUserRegistry(groups, group, origRealmPrefix);
        }
        return groups;
    }

    @FFDCIgnore(value={UserIdentityException.class})
    List<String> getGroupsFromUserResolver() throws SamlCallerTokenException {
        List groups = null;
        Iterator userIdResolvers = activatedUserResolverRef.getServices();
        if (userIdResolvers.hasNext()) {
            UserCredentialResolver userIdResolver = (UserCredentialResolver)userIdResolvers.next();
            try {
                groups = userIdResolver.mapSAMLAssertionToGroups(this.token);
            }
            catch (UserIdentityException e) {
                throw new SamlCallerTokenException("SAML20_CANNOT_RESOLVE_ASSERTION", (Exception)((Object)e), new Object[]{e.getMessage()});
            }
        }
        return groups;
    }

    public List<String> getGroupUniqueIdentity(String realm) throws SamlCallerTokenException {
        List<String> newGroups;
        ArrayList<String> groups = new ArrayList<String>();
        if (activatedUserResolverRef.size() > 0 && (newGroups = this.getGroupsFromUserResolver()) != null && newGroups.size() > 0) {
            String groupPrefix = "group:" + realm + "/";
            for (String group : newGroups) {
                if (!group.startsWith("group:")) {
                    group = groupPrefix + group;
                }
                groups.add(group);
            }
            return groups;
        }
        String name = (String)this.callerConfig.get("groupIdentifier");
        if (name != null && !name.isEmpty()) {
            String idpRealmPrefix = "group:" + realm + "/";
            List attributes = this.token.getSAMLAttributes();
            for (Saml20Attribute attribute : attributes) {
                if (!name.equals(attribute.getName())) continue;
                if (attribute.getValuesAsString().isEmpty()) break;
                for (String groupDN : attribute.getValuesAsString()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("groupDN from Token Attributes:" + groupDN), (Object[])new Object[0]);
                    }
                    String group = groupDN;
                    if (!groupDN.startsWith(idpRealmPrefix)) {
                        int groupIndex = groupDN.indexOf("/");
                        group = groupDN.startsWith("group:") && groupIndex > 0 ? idpRealmPrefix + groupDN.substring(groupIndex + 1) : idpRealmPrefix + groupDN;
                    }
                    groups.add(group);
                }
            }
        }
        return groups;
    }

    @Trivial
    public String getCustomCacheKeyValue() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.token.getSAMLIssuerName()).append("_").append(this.token.getSamlID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cxf-saml caller token cache key :" + sb.toString()), (Object[])new Object[0]);
        }
        return sb.toString();
    }
}

