/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class StAXUtils {
    private static final TraceComponent tc = Tr.register(StAXUtils.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    private static final EELevel eeLevel = StAXUtils.checkEELevel();
    private static final String JAVA_EE_JAXB_VALIDATOR = "javax.xml.bind.Validator";
    public static final String IBM_XLXP2_XML_EVENT_FACTORY = "com.ibm.xml.xlxp2.api.stax.XMLEventFactoryImpl";
    public static final String IBM_XLXP2_XML_INPUT_FACTORY = "com.ibm.xml.xlxp2.api.wssec.WSSXMLInputFactory";
    public static final String IBM_XLXP2_XML_OUTPUT_FACTORY = "com.ibm.xml.xlxp2.api.stax.XMLOutputFactoryImpl";
    public static final String WOODSTOX_XML_EVENT_FACTORY = "com.ctc.wstx.stax.WstxEventFactory";
    public static final String WOODSTOX_XML_INPUT_FACTORY = "com.ctc.wstx.stax.WstxInputFactory";
    public static final String WOODSTOX_XML_OUTPUT_FACTORY = "com.ctc.wstx.stax.WstxOutputFactory";
    static final long serialVersionUID = 5026314503512502378L;

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static ClassLoader getStAXProviderClassLoader() {
        ClassLoader cl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("EELevel is " + (Object)((Object)eeLevel) + ", loading related StAX Provider"), (Object[])new Object[0]);
        }
        switch (eeLevel) {
            case EE9: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Jakarta EE 9 found, using the JRE's StAX provider", (Object[])new Object[0]);
                }
                cl = ClassLoader.getSystemClassLoader();
                break;
            }
            case EE10: {
                if (StaxUtils.ALLOW_INSECURE_PARSER_VAL) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The System Property `org.apache.cxf.stax.allowInsecureParser` is set, using JRE's StAX Provider", (Object[])new Object[0]);
                    }
                    cl = ClassLoader.getSystemClassLoader();
                    break;
                }
                try {
                    Class.forName(WOODSTOX_XML_OUTPUT_FACTORY);
                    Class.forName(WOODSTOX_XML_INPUT_FACTORY);
                    Class<?> eventFactoryClass = Class.forName(WOODSTOX_XML_EVENT_FACTORY);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Jakarta EE 10 found, using Woodstox's StAX provider", (Object[])new Object[0]);
                    }
                    cl = eventFactoryClass.getClassLoader();
                }
                catch (ClassNotFoundException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to load Woodstox StAX provider " + e.getMessage() + ", StAX from JRE is used"), (Object[])new Object[0]);
                    }
                    cl = ClassLoader.getSystemClassLoader();
                }
                break;
            }
            default: {
                try {
                    Class.forName(IBM_XLXP2_XML_OUTPUT_FACTORY);
                    Class.forName(IBM_XLXP2_XML_INPUT_FACTORY);
                    Class<?> eventFactoryClass = Class.forName(IBM_XLXP2_XML_EVENT_FACTORY);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Java EE and XLXP found, using XLXP's StAX provider", (Object[])new Object[0]);
                    }
                    cl = eventFactoryClass.getClassLoader();
                    break;
                }
                catch (ClassNotFoundException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to load IBM STAX XLXP2 Provider " + e.getMessage() + ", StAX from JRE is used"), (Object[])new Object[0]);
                    }
                    cl = ClassLoader.getSystemClassLoader();
                }
            }
        }
        return cl;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private static EELevel checkEELevel() {
        try {
            if (Class.forName(JAVA_EE_JAXB_VALIDATOR).getName().contains("jakarta")) {
                return EELevel.EE9;
            }
            return EELevel.EE8;
        }
        catch (ClassNotFoundException e1) {
            return EELevel.EE10;
        }
    }

    private static enum EELevel {
        EE8,
        EE9,
        EE10;

    }
}

