/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.transaction;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.transaction.ClientTransactionPolicy;
import com.ibm.ws.transport.iiop.transaction.ClientTransactionPolicyConfig;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CosTransactions.OTSPolicyValueHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ClientTransactionInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(ClientTransactionInterceptor.class, null, null);
    private final Codec codec;
    private final ThreadLocal<Transaction> _storedTx = new ThreadLocal();
    private volatile TransactionManager transactionManager;

    public ClientTransactionInterceptor(Codec codec) {
        this.codec = codec;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Registered", (Object[])new Object[0]);
        }
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        this.resumeTxOnreply();
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
        this.resumeTxOnreply();
    }

    public void receive_reply(ClientRequestInfo ri) {
        this.resumeTxOnreply();
    }

    /*
     * WARNING - void declaration
     */
    private void resumeTxOnreply() {
        block11: {
            Transaction suspendedTx = this._storedTx.get();
            if (suspendedTx != null && this.transactionManager != null) {
                try {
                    Transaction currentTx = this.transactionManager.getTransaction();
                    if (currentTx != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No resume, there is a current transaction " + currentTx + ", the stored transaction is " + suspendedTx), (Object[])new Object[0]);
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No current transaction, so resume " + this._storedTx), (Object[])new Object[0]);
                        }
                        this.transactionManager.resume(suspendedTx);
                    }
                }
                catch (InvalidTransactionException currentTx) {
                    FFDCFilter.processException((Throwable)currentTx, (String)"com.ibm.ws.transport.iiop.transaction.ClientTransactionInterceptor", (String)"94", (Object)((Object)this), (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)"Could not resume transaction", (Object[])new Object[]{e});
                    }
                }
                catch (IllegalStateException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transport.iiop.transaction.ClientTransactionInterceptor", (String)"97", (Object)((Object)this), (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Could not resume transaction", (Object[])new Object[]{e});
                    }
                }
                catch (SystemException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transport.iiop.transaction.ClientTransactionInterceptor", (String)"100", (Object)((Object)this), (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)"Could not resume transaction", (Object[])new Object[]{e});
                }
            }
        }
        this._storedTx.set(null);
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={BAD_PARAM.class})
    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        TaggedComponent taggedComponent = null;
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking if target " + ri.operation() + " has a transaction policy"), (Object[])new Object[0]);
            }
            taggedComponent = ri.get_effective_component(31);
        }
        catch (BAD_PARAM e) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Target has a transaction policy", (Object[])new Object[0]);
        }
        byte[] data = taggedComponent.component_data;
        Any any = null;
        try {
            any = this.codec.decode_value(data, OTSPolicyValueHelper.type());
        }
        catch (FormatMismatch formatMismatch) {
            void formatMismatch2;
            FFDCFilter.processException((Throwable)formatMismatch, (String)"com.ibm.ws.transport.iiop.transaction.ClientTransactionInterceptor", (String)"132", (Object)((Object)this), (Object[])new Object[]{ri});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Mismatched format", (Object[])new Object[]{formatMismatch2});
            }
            throw (INTERNAL)new INTERNAL("Mismatched format").initCause((Throwable)formatMismatch2);
        }
        catch (TypeMismatch formatMismatch2) {
            void typeMismatch;
            FFDCFilter.processException((Throwable)formatMismatch2, (String)"com.ibm.ws.transport.iiop.transaction.ClientTransactionInterceptor", (String)"136", (Object)((Object)this), (Object[])new Object[]{ri});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Type mismatch", (Object[])new Object[]{typeMismatch});
            }
            throw (INTERNAL)new INTERNAL("Type mismatch").initCause((Throwable)typeMismatch);
        }
        short value = OTSPolicyValueHelper.extract((Any)any);
        if (value == 3) {
            Transaction currentTx;
            ClientTransactionPolicy clientTransactionPolicy = (ClientTransactionPolicy)ri.get_request_policy(1095976451);
            if (clientTransactionPolicy == null) {
                return;
            }
            ClientTransactionPolicyConfig clientTransactionPolicyConfig = clientTransactionPolicy.getClientTransactionPolicyConfig();
            if (clientTransactionPolicyConfig == null) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Client has a transaction policy", (Object[])new Object[0]);
            }
            if (this.transactionManager == null) {
                this.transactionManager = clientTransactionPolicyConfig.getTransactionManager();
            }
            if ((currentTx = clientTransactionPolicyConfig.exportTransaction(ri, this.codec)) != null) {
                this._storedTx.set(currentTx);
            }
        }
    }

    public void destroy() {
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

