/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.Configuration;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.config.provider.MapBasedConfiguration;
import org.opensaml.core.xml.config.XMLConfigurator;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Activator
implements BundleActivator {
    private static TraceComponent tc = Tr.register(Activator.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private static XMLObjectProviderRegistry providerRegistry;
    private static final String[] XML_CONFIGS;
    static boolean bInit;
    static final long serialVersionUID = 8186194918106431793L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void start(BundleContext ctx) throws Exception {
        if (!bInit) {
            block15: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Initializing the opensaml3 library...", (Object[])new Object[0]);
                }
                MapBasedConfiguration configuration = new MapBasedConfiguration();
                ConfigurationService.setConfiguration((Configuration)configuration);
                providerRegistry = new XMLObjectProviderRegistry();
                configuration.register(XMLObjectProviderRegistry.class, (Object)providerRegistry, "default");
                try {
                    Class<Configuration> clazz = Configuration.class;
                    XMLConfigurator configurator = new XMLConfigurator();
                    for (String config : XML_CONFIGS) {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("handling config :" + config), (Object[])new Object[0]);
                            }
                            configurator.load(clazz.getResourceAsStream(config));
                        }
                        catch (Exception exception) {
                            void e;
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.impl.Activator", (String)"98", (Object)this, (Object[])new Object[]{ctx});
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("ERR handling config :" + config + e.getMessage()), (Object[])new Object[0]);
                        }
                    }
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Thread thread = Thread.currentThread();
                    thread.setContextClassLoader(InitializationService.class.getClassLoader());
                    try {
                        InitializationService.initialize();
                    }
                    finally {
                        thread.setContextClassLoader(loader);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Initializing SAML20 Artifact builder when we have SAML output", (Object[])new Object[0]);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"initialize Parser pool", (Object[])new Object[0]);
                    }
                    BasicParserPool pp = new BasicParserPool();
                    pp.setNamespaceAware(true);
                    pp.setMaxPoolSize(50);
                    pp.initialize();
                    providerRegistry.setParserPool((ParserPool)pp);
                    Activator.initializeGlobalSecurityConfiguration();
                }
                catch (Exception clazz) {
                    void e;
                    FFDCFilter.processException((Throwable)clazz, (String)"com.ibm.ws.security.saml.impl.Activator", (String)"132", (Object)this, (Object[])new Object[]{ctx});
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug((TraceComponent)tc, (String)("unable to bootstrap the opensaml3 library - config Exception:" + e), (Object[])new Object[0]);
                }
            }
            bInit = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"opensaml3 library bootstrap complete", (Object[])new Object[0]);
            }
        }
    }

    public void stop(BundleContext ctx) throws Exception {
    }

    protected static void initializeGlobalSecurityConfiguration() {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        XML_CONFIGS = new String[]{"/default-config.xml", "/schema-config.xml", "/saml1-assertion-config.xml", "/saml1-metadata-config.xml", "/saml1-protocol-config.xml", "/saml2-assertion-config.xml", "/saml2-assertion-delegation-restriction-config.xml", "/saml2-ecp-config.xml", "/saml2-metadata-algorithm-config.xml", "/saml2-metadata-config.xml", "/saml2-metadata-idp-discovery-config.xml", "/saml2-metadata-query-config.xml", "/saml2-protocol-config.xml", "/saml2-protocol-thirdparty-config.xml", "/saml2-protocol-aslo-config.xml", "/saml2-channel-binding-config.xml", "/saml-ec-gss-config.xml", "/signature-config.xml", "/encryption-config.xml", "/xacml20-context-config.xml", "/xacml20-policy-config.xml", "/xacml10-saml2-profile-config.xml", "/xacml11-saml2-profile-config.xml", "/xacml2-saml2-profile-config.xml", "/xacml3-saml2-profile-config.xml"};
        bInit = false;
    }
}

