/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import org.jboss.weld.WeldCDIProvider;
import org.jboss.weld.util.collections.ImmutableList;

public class CompositeCDIProvider
implements CDIProvider {
    private volatile List<WeldCDIProvider> providers;

    public CDI<Object> getCDI() {
        for (WeldCDIProvider provider : this.providers()) {
            CDI cdi = provider.getCDI();
            if (cdi == null) continue;
            return cdi;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeldCDIProvider> providers() {
        if (this.providers == null) {
            CompositeCDIProvider compositeCDIProvider = this;
            synchronized (compositeCDIProvider) {
                if (this.providers == null) {
                    ImmutableList.Builder<WeldCDIProvider> builder = ImmutableList.builder();
                    for (WeldCDIProvider provider : ServiceLoader.load(WeldCDIProvider.class, CompositeCDIProvider.class.getClassLoader())) {
                        builder.add(provider);
                    }
                    this.providers = builder.build(new Comparator<WeldCDIProvider>(){

                        @Override
                        public int compare(WeldCDIProvider o1, WeldCDIProvider o2) {
                            return Integer.compare(o2.getPriority(), o1.getPriority());
                        }
                    });
                }
            }
        }
        return this.providers;
    }
}

