/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.Scope;
import org.apache.bval.jsr.ConstraintValidation;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.groups.Groups;
import org.apache.bval.jsr.groups.GroupsComputer;
import org.apache.bval.model.MetaBean;

final class ConstraintFinderImpl
implements ElementDescriptor.ConstraintFinder {
    private final MetaBean metaBean;
    private final Set<Scope> findInScopes;
    private Set<ConstraintValidation<?>> constraintDescriptors;

    ConstraintFinderImpl(MetaBean metaBean, Set<ConstraintValidation<?>> constraintDescriptors) {
        this.metaBean = metaBean;
        this.constraintDescriptors = constraintDescriptors;
        this.findInScopes = new HashSet<Scope>(Arrays.asList(Scope.values()));
    }

    public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
        HashSet matchingDescriptors = new HashSet(this.constraintDescriptors.size());
        Groups groupChain = new GroupsComputer().computeGroups(groups);
        for (Group group : groupChain.getGroups()) {
            if (group.isDefault()) {
                for (Group group2 : (List)this.metaBean.getFeature("GroupSequence")) {
                    for (ConstraintValidation<?> descriptor : this.constraintDescriptors) {
                        if (!this.isInScope(descriptor) || !this.isInGroup(descriptor, group2)) continue;
                        matchingDescriptors.add(descriptor);
                    }
                }
                continue;
            }
            for (ConstraintValidation<Object> constraintValidation : this.constraintDescriptors) {
                if (!this.isInScope(constraintValidation) || !this.isInGroup(constraintValidation, group)) continue;
                matchingDescriptors.add(constraintValidation);
            }
        }
        return this.thisWith(matchingDescriptors);
    }

    public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
        if (scope == Scope.LOCAL_ELEMENT) {
            this.findInScopes.remove(Scope.HIERARCHY);
            Iterator<ConstraintValidation<?>> it = this.constraintDescriptors.iterator();
            while (it.hasNext()) {
                if (it.next().getOwner().equals(this.metaBean.getBeanClass())) continue;
                it.remove();
            }
        }
        return this;
    }

    public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... elementTypes) {
        HashSet matchingDescriptors = new HashSet(this.constraintDescriptors.size());
        for (ElementType each : elementTypes) {
            for (ConstraintValidation<?> descriptor : this.constraintDescriptors) {
                if (!this.isInScope(descriptor) || !this.isAtElement(descriptor, each)) continue;
                matchingDescriptors.add(descriptor);
            }
        }
        return this.thisWith(matchingDescriptors);
    }

    private boolean isAtElement(ConstraintValidation<?> descriptor, ElementType each) {
        return descriptor.getAccess().getElementType() == each;
    }

    private boolean isInScope(ConstraintValidation<?> descriptor) {
        if (this.findInScopes.size() == Scope.values().length) {
            return true;
        }
        if (this.metaBean != null) {
            boolean isOwner = descriptor.getOwner().equals(this.metaBean.getBeanClass());
            for (Scope scope : this.findInScopes) {
                switch (scope) {
                    case LOCAL_ELEMENT: {
                        if (!isOwner) break;
                        return true;
                    }
                    case HIERARCHY: {
                        if (isOwner) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isInGroup(ConstraintValidation<?> descriptor, Group group) {
        return descriptor.getGroups().contains(group.getGroup());
    }

    private ElementDescriptor.ConstraintFinder thisWith(Set<ConstraintValidation<?>> matchingDescriptors) {
        this.constraintDescriptors = matchingDescriptors;
        return this;
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        if (this.constraintDescriptors.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.constraintDescriptors);
    }

    public boolean hasConstraints() {
        return !this.constraintDescriptors.isEmpty();
    }
}

