/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.kerberos;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.kerberos.Krb5HelperJdk;
import com.ibm.ws.security.krb5.Krb5Common;
import com.sun.security.auth.module.Krb5LoginModule;
import com.sun.security.jgss.ExtendedGSSContext;
import com.sun.security.jgss.ExtendedGSSCredential;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OtherKrb5Helper
implements Krb5HelperJdk {
    private static final TraceComponent tc = Tr.register(OtherKrb5Helper.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.internal.resources.KerberosMessages");
    static final long serialVersionUID = 2048955998457100144L;

    @Override
    public GSSCredential getDelegateGSSCredUsingS4U2self(final String upn, String targetServiceSpn, final Oid gssNameType, final int gssCredUsage, final String delegateServiceSpn, Subject delegateServiceSubject) throws GSSException {
        final GSSManager gssManager = GSSManager.getInstance();
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){
            static final long serialVersionUID = -6169614897257102543L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public Object run() {
                GSSCredential impersonateGssCred = null;
                try {
                    GSSCredential self = gssManager.createCredential(gssCredUsage);
                    GSSName gssName = gssManager.createName(upn, gssNameType);
                    impersonateGssCred = ((ExtendedGSSCredential)self).impersonate(gssName);
                }
                catch (GSSException self) {
                    void e;
                    FFDCFilter.processException((Throwable)self, (String)"com.ibm.ws.security.kerberos.OtherKrb5Helper$1", (String)"62", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"KRB_IMPERSONATE_USER_TO_GET_GSSCRED_FOR_SELF_FAILURE", (Object[])new Object[]{upn, delegateServiceSpn, e.getMessage()});
                }
                return impersonateGssCred;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.kerberos.OtherKrb5Helper$1", 1.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.internal.resources.KerberosMessages");
            }
        };
        GSSCredential gssCred = (GSSCredential)WSSubject.doAs((Subject)delegateServiceSubject, (PrivilegedAction)action);
        if (gssCred == null) {
            throw new GSSException(11, 12, "GSSCredential is null");
        }
        return gssCred;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GSSCredential getDelegateGSSCredUsingS4U2proxy(String userPrincipalName, GSSContext delegateGSSContext, String delegateServiceSpn) throws GSSException {
        GSSCredential gssCred = null;
        try {
            ExtendedGSSContext extGssContext = (ExtendedGSSContext)delegateGSSContext;
            gssCred = extGssContext.getDelegCred();
        }
        catch (GSSException extGssContext) {
            void e;
            FFDCFilter.processException((Throwable)extGssContext, (String)"com.ibm.ws.security.kerberos.OtherKrb5Helper", (String)"85", (Object)this, (Object[])new Object[]{userPrincipalName, delegateGSSContext, delegateServiceSpn});
            Tr.error((TraceComponent)tc, (String)"KRB_IMPERSONATE_USER_TO_GET_GSSCRED_FOR_BACKEND_SERVICE_FAILURE", (Object[])new Object[]{userPrincipalName, delegateServiceSpn, e.getMessage()});
        }
        if (gssCred == null) {
            throw new GSSException(11, 13, "GSSCredential is null");
        }
        return gssCred;
    }

    @Override
    public Subject doKerberosLogin(String jaasLoginContextEntry, String delegateSpn, String krb5Keytab) throws LoginException {
        Subject subject = new Subject();
        Krb5LoginModule krb5 = new Krb5LoginModule();
        HashMap<String, String> options = new HashMap<String, String>();
        HashMap<String, String> sharedState = new HashMap<String, String>();
        options.put("isInitiator", "true");
        options.put("refreshKrb5Config", "true");
        options.put("doNotPrompt", "true");
        options.put("storeKey", "true");
        options.put("useKeyTab", "true");
        options.put("keyTab", Krb5Common.getSystemProperty((String)"KRB5_KTNAME"));
        sharedState.put("javax.security.auth.login.name", delegateSpn);
        if (tc.isDebugEnabled()) {
            options.put("debug", "true");
        }
        krb5.initialize(subject, null, sharedState, options);
        Krb5Common.debugKrb5LoginModule((Subject)subject, null, sharedState, options);
        krb5.login();
        krb5.commit();
        return subject;
    }
}

