/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.chfw;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.protocol.SipProtocolLayer;
import com.ibm.ws.sip.stack.transaction.transport.SIPConnectionsModel;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnectionFactory;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.util.HashMap;

public class SIPConnectionFactoryImplWs
implements SIPConnectionFactory {
    private static final TraceComponent tc = Tr.register(SIPConnectionFactoryImplWs.class);
    private static SIPConnectionFactoryImplWs s_instance = new SIPConnectionFactoryImplWs();
    private HashMap<ListeningPoint, SIPListenningConnection> m_channels = new HashMap(8);

    public static SIPConnectionFactoryImplWs instance() {
        return s_instance;
    }

    private SIPConnectionFactoryImplWs() {
    }

    @Override
    public SIPListenningConnection createListeningConnection(ListeningPoint lp) throws IOException {
        SIPListenningConnection channel = this.m_channels.get(lp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"createListeningConnection", (Object[])new Object[]{"no listening point [" + lp.toString() + ']'});
        }
        return channel;
    }

    void addListeningConnection(ListeningPoint lp, SIPListenningConnection channel, String chainName) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"addListeningConnection", (Object[])new Object[]{"adding channel to chain [" + chainName + "] on listening point [" + lp + ']'});
        }
        this.m_channels.put(lp, channel);
        SIPConnectionsModel.instance().addedListeningPoint(lp);
        SipProtocolLayer.getInstance().initNewInterfaces(lp);
    }
}

