/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.netty;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.ws.sip.stack.transport.ActiveConfiguration;
import com.ibm.ws.sip.stack.transport.GenericChainBase;
import com.ibm.ws.sip.stack.transport.GenericEndpointImpl;
import com.ibm.ws.sip.stack.transport.netty.GenericChain;
import com.ibm.ws.sip.stack.transport.netty.SipDatagramHandler;
import com.ibm.ws.sip.stack.transport.netty.SipMessageBufferDatagramDecoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.exception.NettyException;
import jain.protocol.ip.sip.ListeningPoint;
import java.util.HashMap;
import java.util.Map;

public class GenericUDPChain
extends GenericChain {
    private static final LogMgr c_logger = Log.get(GenericUDPChain.class);
    private String chainName;

    public GenericUDPChain(GenericEndpointImpl owner) {
        super(owner);
    }

    @Override
    public void init(String endpointId, Object componentId, NettyFramework nfBundle, String name) {
        this.chainName = "UDP_" + name + "_" + endpointId;
        super.init(endpointId, componentId, nfBundle, name);
    }

    @Override
    protected ActiveConfiguration createActiveConfiguration() {
        Map<String, Object> udpOptions = GenericEndpointImpl.getUdpOptions();
        Map<String, Object> endpointOptions = this.owner.getEndpointOptions();
        return new ActiveConfiguration(udpOptions, endpointOptions, this);
    }

    @Override
    protected void rebuildTheChannel(ActiveConfiguration oldConfig, ActiveConfiguration newConfig) {
    }

    @Override
    public String getName() {
        return this.chainName;
    }

    @Override
    public void setupEventProps(Map<String, Object> eventProps) {
    }

    @Override
    public GenericChainBase.Type getType() {
        return GenericChainBase.Type.UDP;
    }

    @Override
    public String getTransport() {
        return "udp";
    }

    @Override
    public synchronized void update() {
        block3: {
            super.update();
            if (this.currentConfig.validConfiguration) {
                EndPointMgr em = this.nettyBundle.getEndpointManager();
                EndPointInfo ep = em.getEndPoint(this.getEndpointName());
                ep = em.defineEndPoint(this.getEndpointName(), this.currentConfig.configHost, this.currentConfig.configPort);
                ListeningPoint lp = this.sipInboundChannelFactory.initChannel(this);
                try {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.putAll(this.getCurrentConfig().udpOptions);
                    options.put("ExternalName", this.getName());
                    this.bootstrap = this.nettyBundle.createUDPBootstrap(options);
                    this.bootstrap.handler((ChannelHandler)new SipUDPInitializer(null));
                    this.nettyBundle.start(this.bootstrap, ep.getHost(), ep.getPort(), future -> {
                        if (future.isSuccess()) {
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug("SIP UDP endpoint start success");
                            }
                        } else if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SIP UDP endpoint start failure: " + future.cause());
                        }
                    });
                }
                catch (NettyException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block3;
                    c_logger.traceDebug("Exception creating UDP bootstrap: " + (Object)((Object)e2));
                }
            }
        }
    }

    private class SipUDPInitializer
    extends ChannelInitializerWrapper {
        ChannelInitializerWrapper parent;

        public SipUDPInitializer(ChannelInitializerWrapper parent) {
            this.parent = parent;
        }

        protected void initChannel(Channel ch) throws Exception {
            if (this.parent != null) {
                this.parent.init(ch);
            }
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new SipMessageBufferDatagramDecoder());
            pipeline.addLast("handler", (ChannelHandler)new SipDatagramHandler());
        }
    }
}

