/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transactions;

import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.BranchMethodKey;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransaction;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.message.Request;
import java.util.TimerTask;

public abstract class SIPTransactionImpl
implements SIPTransaction {
    public static final int STATE_BEFORE_STATE_MACHINE_PROCESSE = -1;
    private static long s_transactionId = 0L;
    private long m_id;
    private BranchMethodKey m_branchMethodId;
    private int m_state;
    private Request m_firstReq;
    private final SipProvider m_provider;
    private SIPTransactionStack m_stack;
    private SIPConnection m_transportConnection;

    public SIPTransactionImpl(SIPTransactionStack transactionStack, SipProvider provider, Request req, BranchMethodKey key, long transactionId) {
        this.m_id = transactionId == -1L ? SIPTransactionImpl.getNextTransactionId() : transactionId;
        this.m_stack = transactionStack;
        this.setState(-1);
        this.m_firstReq = req;
        this.m_branchMethodId = key;
        if (provider == null) {
            throw new IllegalArgumentException("null provider [" + this + ']');
        }
        this.m_provider = provider;
    }

    public static final synchronized long getNextTransactionId() {
        return s_transactionId++;
    }

    @Override
    public SIPTransactionStack getParentStack() {
        return this.m_stack;
    }

    @Override
    public final Request getFirstRequest() {
        return this.m_firstReq;
    }

    @Override
    public long getId() {
        return this.m_id;
    }

    @Override
    public BranchMethodKey getBranchMethodId() {
        return this.m_branchMethodId;
    }

    @Override
    public final String getBranch() {
        return this.m_branchMethodId.getBranch();
    }

    @Override
    public final void setState(int newState) {
        this.m_state = newState;
    }

    @Override
    public final int getState() {
        return this.m_state;
    }

    public String getStateAsString() {
        return this.m_state == -1 ? "Init" : String.valueOf(this.m_state);
    }

    @Override
    public boolean isTransportReliable() {
        return ((ListeningPointImpl)this.getProviderContext().getListeningPoint()).isReliable();
    }

    @Override
    public SipProvider getProviderContext() {
        return this.m_provider;
    }

    @Override
    public void setTransportConnection(SIPConnection connection) {
        this.m_transportConnection = connection;
    }

    @Override
    public SIPConnection getTransportConnection() {
        return this.m_transportConnection;
    }

    @Override
    public synchronized boolean hasInitiated() {
        return this.m_state != -1;
    }

    protected void addTimerTask(TimerTask task, long delay) {
        if (delay > 0L) {
            this.getParentStack().getTimer().schedule(task, delay);
        }
    }

    public final String getCallId() {
        return this.m_firstReq.getCallIdHeader().getCallId();
    }

    protected abstract String getType();

    public String toString() {
        StringBuffer retVal = new StringBuffer(256);
        retVal.append("type [");
        retVal.append(this.getType());
        retVal.append("] id [");
        retVal.append(this.m_id);
        retVal.append("] branch+method [");
        retVal.append(this.m_branchMethodId);
        retVal.append("] state [");
        retVal.append(this.getStateAsString());
        retVal.append(']');
        return retVal.toString();
    }

    protected void updateSipTimersInvocationsPMICounter() {
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null) {
            perfMgr.updateSipTimersInvocationsCounter();
        }
    }
}

