/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.appqueue.AppQueueHandler;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.pmi.TaskDurationMeasurer;
import com.ibm.ws.sip.container.util.Queueable;
import com.ibm.ws.sip.container.was.ExecutorMessageDispatchingHandler;
import com.ibm.ws.sip.container.was.SignalingEndOfTask;

class ContextBasedQueue
extends AppQueueHandler {
    private static final LogMgr c_logger = Log.get(ContextBasedQueue.class);
    boolean m_isQhasTaskInThreadPool = false;
    String m_recordedId = null;
    private Queueable m_lastExecutedTask;
    private Object m_sipQmutex = new Object();
    private ExecutorMessageDispatchingHandler _handler;

    public ContextBasedQueue(int maxQueueSize, int id, ExecutorMessageDispatchingHandler handler) {
        super(maxQueueSize, id, handler);
        this._handler = handler;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "ContextBasedQueue", (Object)("maxQSize=" + maxQueueSize));
        }
    }

    @Override
    protected void extractAmsgAndExecute() {
        block10: {
            try {
                Queueable msg = null;
                while (msg == null) {
                    msg = this.getRunnableObj();
                }
                PerformanceMgr perfMgr = PerformanceMgr.getInstance();
                if (perfMgr != null) {
                    if (perfMgr.isTaskDurationProcessingQueuePMIEnabled()) {
                        if (msg.getSipContainerQueueDuration() != null) {
                            perfMgr.measureTaskDurationProcessingQueue(msg.getSipContainerQueueDuration().takeTimeMeasurement());
                        } else if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "extractAmsgAndExecute", "'takeTimeMeasurment' wasn't called since SipContainerQueueDuration is null");
                        }
                    }
                    if (perfMgr.isApplicationDurationPMIEnabled() && msg != null) {
                        msg.setApplicationCodeDuration(new TaskDurationMeasurer());
                        msg.getApplicationCodeDuration().startMeasuring();
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "extractAmsgAndExecute", "Update QueueMonitoringModule processing queue statistics - task dequeued");
                    }
                    perfMgr.updateQueueMonitoringTaskDequeuedFromProcessingQueue();
                }
                this.executeSignaledTask(msg);
            }
            catch (Throwable e2) {
                if (!c_logger.isErrorEnabled()) break block10;
                c_logger.error("error.exception", null, null, e2);
            }
        }
    }

    private void executeSignaledTask(Queueable msg) throws IllegalStateException, InterruptedException {
        if (c_logger.isTraceEntryExitEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("QId=");
            buff.append(this.getId());
            buff.append(" Message =  ");
            buff.append(msg);
            c_logger.traceEntry((Object)this, "executeSignaledTask", (Object)buff.toString());
        }
        this.m_isQhasTaskInThreadPool = true;
        this.m_lastExecutedTask = msg;
        SignalingEndOfTask task = this._handler.wrapTaskWithSignaling(this, msg);
        this._handler.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedToExecuteTask(Queueable msg) {
        PerformanceMgr perfMgr;
        if (c_logger.isTraceEntryExitEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("QId=");
            buff.append(this.getId());
            buff.append(" Message =  ");
            buff.append(msg);
            c_logger.traceEntry((Object)this, "finishedToExecuteTask", (Object)buff.toString());
        }
        if ((perfMgr = PerformanceMgr.getInstance()) != null && perfMgr.isApplicationDurationPMIEnabled() && msg != null && msg.getApplicationCodeDuration() != null && msg.getAppName() != null && msg.getAppIndexForPMI() != null) {
            perfMgr.measureInApplicationTaskDuration(msg.getAppName(), msg.getAppIndexForPMI(), msg.getApplicationCodeDuration().takeTimeMeasurement());
        }
        this.invalidateWhenReadyTU();
        ContextBasedQueue contextBasedQueue = this;
        synchronized (contextBasedQueue) {
            this.finishToExecuteRunnable();
            this.notifyAll();
            this.unrecordThreadID();
            if (this._queue.isEmpty()) {
                this.m_isQhasTaskInThreadPool = false;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "finishedToExecuteTask", "no more messages in Qid=" + this.getId() + " .releasing flag");
                }
                return;
            }
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("QId=").append(this.getId()).append(" has ");
                buff.append(this._queue.size());
                buff.append(" more messages.");
                buff.append(msg);
                c_logger.traceDebug(this, "finishedToExecuteTask", buff.toString());
            }
            this.extractAmsgAndExecute();
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "finishedToExecuteTask");
            }
        }
    }

    @Override
    public synchronized boolean dispatchMessage(Queueable msg, long blockingTimeout) {
        if (c_logger.isTraceEntryExitEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("QId=");
            buff.append(this.getId());
            buff.append(" block=");
            buff.append(blockingTimeout);
            buff.append(" taskInQ ");
            buff.append(this.m_isQhasTaskInThreadPool);
            c_logger.traceEntry((Object)this, "dispatchMessage", (Object)buff.toString());
        }
        boolean queued = false;
        queued = super.dispatchMessage(msg, -1L);
        if (!queued) {
            boolean shouldBlock = blockingTimeout >= 0L;
            boolean finallyQueued = false;
            if (shouldBlock) {
                finallyQueued = this.blockMessage(msg);
            }
            if (!finallyQueued) {
                return false;
            }
            queued = true;
        }
        if (this.m_isQhasTaskInThreadPool) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "dispatchMessage", "message queued since there is already another message being executed right now. QId=" + this.getId());
            }
            return queued;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "dispatchMessage", "a new task in queue.will try to process it now.");
        }
        this.extractAmsgAndExecute();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "dispatchMessage");
        }
        return true;
    }

    private boolean blockMessage(Queueable msg) {
        boolean queued;
        block3: {
            queued = false;
            try {
                while (!queued) {
                    this.wait();
                    queued = super.dispatchMessage(msg, -1L);
                }
            }
            catch (InterruptedException e2) {
                if (!c_logger.isErrorEnabled()) break block3;
                c_logger.error("error.exception", null, null, (Throwable)e2);
            }
        }
        return queued;
    }

    boolean reportHangedThread(String threadName) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "reportHangedThread", threadName, this.m_recordedId);
        }
        return threadName.equals(this.m_recordedId);
    }

    void recordThreadID() {
        if (this.m_recordedId != null) {
            throw new IllegalStateException("There is a different thread still reported running here.");
        }
        this.m_recordedId = Thread.currentThread().getName();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "recordThreadID ", this.m_recordedId);
        }
    }

    void unrecordThreadID() {
        this.m_recordedId = null;
        this.m_lastExecutedTask = null;
    }

    String getRecordedThreadID() {
        return this.m_recordedId;
    }

    Queueable getLastTask() {
        return this.m_lastExecutedTask;
    }
}

