/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipURIImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.RecordRouteHeader;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.Address;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;

public class IncomingSipServletRequest
extends SipServletRequestImpl {
    private static final long serialVersionUID = 3933920609932862490L;
    private static final LogMgr c_logger = Log.get(IncomingSipServletRequest.class);
    private transient String m_authInfoHeaderData = null;
    private static final String AUTHENTICATION_INFO_HEADER_NAME = "Authentication-Info";
    protected transient boolean m_shouldBeAnsweredReliable = false;
    protected transient boolean m_mayBeAnsweredReliable = false;
    protected transient boolean m_reliableWasParsed = false;
    protected transient boolean m_ackOnErrorResponse = false;
    protected transient SipContainer c_sipContainer = SipContainer.getInstance();

    public IncomingSipServletRequest() {
    }

    public IncomingSipServletRequest(Request request, long transactionId, SipProvider provider) {
        super(request, transactionId, provider);
        this.setIsCommited(false);
    }

    public IncomingSipServletRequest(IncomingSipServletRequest request) {
        super(request);
        this.m_shouldBeAnsweredReliable = request.getShouldBeAnsweredReliable();
        this.m_mayBeAnsweredReliable = request.getMayBeAnsweredReliable();
        this.m_reliableWasParsed = request.m_reliableWasParsed;
        this.m_sipProvider = request.getSipProvider();
    }

    public void setAckOnErrorResponse(boolean responseOnAck) {
        this.m_ackOnErrorResponse = responseOnAck;
    }

    public boolean isAckOnErrorResponse() {
        return this.m_ackOnErrorResponse;
    }

    private boolean setShouldAnswerReliable() throws HeaderParseException, NoSuchElementException {
        if (this.getRequest().hasRequireHeaders()) {
            HeaderIterator iter = this.getRequest().getRequireHeaders();
            Header hValue = null;
            if (iter != null) {
                while (iter.hasNext()) {
                    hValue = iter.next();
                    if (!hValue.getValue().equalsIgnoreCase("100rel")) continue;
                    this.m_shouldBeAnsweredReliable = true;
                    return true;
                }
            }
        }
        return false;
    }

    private void parseMayAnswerReliable() throws HeaderParseException, NoSuchElementException {
        HeaderIterator iter = this.getRequest().getHeaders("Supported");
        Header hValue = null;
        if (iter != null) {
            while (iter.hasNext()) {
                hValue = iter.next();
                if (!hValue.getValue().equalsIgnoreCase("100rel")) continue;
                this.m_mayBeAnsweredReliable = true;
            }
        }
    }

    private void parseReliable() {
        try {
            if (!this.setShouldAnswerReliable()) {
                this.parseMayAnswerReliable();
            }
            this.m_reliableWasParsed = true;
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("shouldBeAnsweredReliably = ");
                buff.append(this.m_shouldBeAnsweredReliable);
                buff.append(" mayBeAnsweredReliably = ");
                buff.append(this.m_mayBeAnsweredReliable);
                c_logger.traceDebug(this, "parseReliable", buff.toString());
            }
        }
        catch (HeaderParseException e2) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception", "Request", null);
            }
            this.logExceptionToSessionLog(259, e2);
        }
        catch (NoSuchElementException e3) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception", "Request", null);
            }
            this.logExceptionToSessionLog(259, e3);
        }
    }

    public boolean getMayBeAnsweredReliable() {
        if (!this.m_reliableWasParsed) {
            this.parseReliable();
        }
        return this.m_mayBeAnsweredReliable;
    }

    @Override
    public SipSession getProxySession(boolean create) {
        return this.getTransactionUser().getSipSession(create);
    }

    public boolean getShouldBeAnsweredReliable() {
        if (!this.m_reliableWasParsed) {
            this.parseReliable();
        }
        return this.m_shouldBeAnsweredReliable;
    }

    @Override
    public String getMethod() {
        String method;
        block2: {
            method = null;
            try {
                method = this.getRequest().getMethod();
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{this.getRequest()};
                c_logger.error("error.get.method", "Request", args, (Throwable)e2);
            }
        }
        return method;
    }

    @Override
    public void send() throws IOException {
        throw new IllegalStateException("This is an Incoming request - cannot be sent.");
    }

    @Override
    Address getLocalParty() {
        return this.getTo();
    }

    @Override
    Address getRemoteParty() {
        return this.getFrom();
    }

    @Override
    public SipServletResponse createResponse(int statusCode) {
        return this.createResponse(statusCode, null);
    }

    @Override
    public SipServletResponse createResponse(int statusCode, String reasonPhrase) {
        if (this.isUnmatchedReqeust()) {
            throw new IllegalStateException("This is unmatched incoming request. It is incactive");
        }
        String toTag = this.getRequest().getToHeader().getTag();
        return this.createResponse(statusCode, reasonPhrase, toTag);
    }

    public OutgoingSipServletResponse createResponseForCommitedRequest(int statusCode, String reasonPhrase) {
        if (this.isUnmatchedReqeust()) {
            throw new IllegalStateException("This is unmatched incoming request. It is incactive");
        }
        String toTag = this.getRequest().getToHeader().getTag();
        return this.createResponse(statusCode, reasonPhrase, toTag);
    }

    public OutgoingSipServletResponse createResponse(int statusCode, String reasonPhrase, String toTag) {
        return this.createResponse(statusCode, reasonPhrase, toTag, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutgoingSipServletResponse createResponse(int statusCode, String reasonPhrase, String toTag, TransactionUserWrapper incomingResponseTransactionUser) {
        Object[] params;
        if (c_logger.isTraceDebugEnabled()) {
            params = new Object[]{statusCode, reasonPhrase, toTag, incomingResponseTransactionUser};
            c_logger.traceEntry((Object)this, "createOutgoingResponse", params);
        }
        if (this.isUnmatchedReqeust()) {
            throw new IllegalStateException("This is unmatched incoming request. It is incactive");
        }
        try {
            if (!this.isLiveMessage("createResponse")) {
                params = null;
                return params;
            }
            if (this.getMethod().equals("ACK")) {
                throw new IllegalStateException("Can not generate response for a ACK");
            }
            TransactionUserWrapper tUser = this.getTransactionUser();
            if (this.getTransaction().isTerminated()) {
                if (tUser != null) {
                    tUser.logToContext(0x100002, this);
                }
                throw new IllegalStateException("Transaction terminated, Can not generate response. Call Id: " + this.getCallId());
            }
            SipServletMessageImpl sipServletMessageImpl = this;
            synchronized (sipServletMessageImpl) {
                boolean proxying = false;
                proxying = incomingResponseTransactionUser == null ? tUser != null && tUser.isProxying() : incomingResponseTransactionUser.isProxying();
                if (!(statusCode < 200 || tUser == null || proxying && this.isInitial())) {
                    this.setIsCommited(true);
                } else if (c_logger.isTraceDebugEnabled() && tUser != null) {
                    c_logger.traceDebug(this, "createResponse", "Message state was not changed to commited, isProxy: " + proxying + ", isInital: " + this.isInitial());
                }
            }
            sipServletMessageImpl = this.createOutgoingResponse(statusCode, reasonPhrase, toTag, incomingResponseTransactionUser);
            return sipServletMessageImpl;
        }
        finally {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceExit(this, "createOutgoingResponse");
            }
        }
    }

    protected OutgoingSipServletResponse createOutgoingResponse(int statusCode, String reasonPhrase, String toTag, TransactionUserWrapper incomingResponseTu) {
        OutgoingSipServletResponse response;
        block7: {
            if (c_logger.isTraceDebugEnabled()) {
                Object[] params = new Object[]{statusCode, reasonPhrase, toTag, incomingResponseTu};
                c_logger.traceEntry((Object)this, "createOutgoingResponse", params);
            }
            if (statusCode < 100 || statusCode > 999) {
                throw new IllegalArgumentException("status code out of range [" + statusCode + ']');
            }
            response = null;
            try {
                Request jainRequest = this.getRequest();
                Response jainResponse = this.getMessageFactory().createResponse(statusCode, jainRequest);
                if (null != reasonPhrase) {
                    jainResponse.setReasonPhrase(reasonPhrase);
                }
                if (null != toTag) {
                    jainResponse.getToHeader().setTag(toTag);
                }
                TransactionUserWrapper tu = incomingResponseTu != null ? incomingResponseTu : this.getTransactionUser();
                response = new OutgoingSipServletResponse(jainResponse, this);
                response.setTransactionUser(tu);
                this.addAuthenticationHeader(response);
                this.updateViaHeader(jainResponse);
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block7;
                Object[] args = new Object[]{this.getRequest()};
                c_logger.error("error.create.response", "Request", args, (Throwable)e2);
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit((Object)this, "createOutgoingResponse", response);
        }
        return response;
    }

    protected void updateViaHeader(Response jainResponse) throws SipParseException {
        TransactionUserWrapper tUser;
        if (this.c_sipContainer.isUsingExternalRouter() && (tUser = this.getTransactionUser()) != null) {
            ViaHeader viaH = (ViaHeader)jainResponse.getHeader("Via", true);
            viaH.setParameter("ibmsid", tUser.getId());
        }
    }

    protected void addAuthenticationHeader(OutgoingSipServletResponse response) {
        if (this.m_authInfoHeaderData != null) {
            response.addHeader(AUTHENTICATION_INFO_HEADER_NAME, this.m_authInfoHeaderData);
        }
    }

    @Override
    public SipServletRequest createCancel() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "createCancel", "Can not cancel an incoming request");
        }
        throw new IllegalStateException("Can not cancel an incoming request");
    }

    @Override
    public String getTransport() {
        String transport = this.getLocalTransportInt();
        if (transport == null) {
            transport = this.getTransportInt();
        }
        return transport;
    }

    private SipURL getUriForParams() {
        if (this.isInitial()) {
            if (this.getRequestURI().isSipURI()) {
                SipURIImpl uri = (SipURIImpl)this.getRequestURI();
                return uri.getJainSipUrl();
            }
        } else {
            try {
                RequestImpl request = (RequestImpl)this.getJainSipMessage();
                HeaderIterator i = request.getRecordRouteHeaders();
                if (null != i && i.hasNext()) {
                    RecordRouteHeader rrHeader = (RecordRouteHeader)i.next();
                    if (null != rrHeader) {
                        SipURL url = (SipURL)rrHeader.getNameAddress().getAddress();
                        return url;
                    }
                } else {
                    RouteHeader rHeader;
                    if (this._poppedRoute != null) {
                        SipURL url = (SipURL)((AddressImpl)this._poppedRoute).getNameAddressHeader().getNameAddress().getAddress();
                        return url;
                    }
                    i = request.getRouteHeaders();
                    if (null != i && i.hasNext() && null != (rHeader = (RouteHeader)i.next())) {
                        SipURL url = (SipURL)rHeader.getNameAddress().getAddress();
                        return url;
                    }
                }
            }
            catch (HeaderParseException e2) {
                this.log("getParameter", "can not get parameter", e2);
            }
            catch (NoSuchElementException e3) {
                this.log("getParameter", "can not get parameter", e3);
            }
        }
        return null;
    }

    @Override
    public String getParameter(String name) {
        SipURL url = this.getUriForParams();
        if (null != url) {
            return url.getParameter(name);
        }
        return null;
    }

    @Override
    public Map getParameterMap() {
        HashMap<String, String[]> parameterMap = null;
        SipURL url = this.getUriForParams();
        if (null != url && url.hasParameters()) {
            parameterMap = new HashMap<String, String[]>();
            Iterator i = url.getParameters();
            while (i.hasNext()) {
                String name = (String)i.next();
                String[] value = new String[]{url.getParameter(name)};
                parameterMap.put(name, value);
            }
        }
        return parameterMap;
    }

    private static Enumeration iteratorToEnumeration(final Iterator i) {
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            public Object nextElement() {
                return i.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Enumeration getParameterNames() {
        Enumeration parameterNames = null;
        SipURL url = this.getUriForParams();
        if (null != url && url.hasParameters()) {
            parameterNames = IncomingSipServletRequest.iteratorToEnumeration(url.getParameters());
        }
        return parameterNames;
    }

    @Override
    public String[] getParameterValues(String name) {
        String[] parameterValues = null;
        SipURL url = this.getUriForParams();
        if (null != url) {
            parameterValues = new String[]{url.getParameter(name)};
        }
        return parameterValues;
    }

    public void setAuthInfoHeaderData(String infoHeaderData) {
        this.m_authInfoHeaderData = infoHeaderData;
    }

    @Override
    protected void updateUnCommittedMessagesList(boolean isCommited) {
        TransactionUserWrapper transactionUser = this.getTransactionUser();
        if (!this.getMethod().equals("ACK")) {
            if (isCommited) {
                transactionUser.removeB2BPendingMsg(this, UAMode.UAS);
            } else {
                transactionUser.addB2BPendingMsg(this, UAMode.UAS);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "updateUnCommittedMessagesList", "Incomming ACK request should not be stored in the pending messages");
        }
    }

    protected ContactHeader createContactHeader() throws SipParseException {
        return null;
    }

    @Override
    public void setRoutingDirective(SipApplicationRoutingDirective directive, SipServletRequest origRequest) {
        throw new IllegalStateException("This is an Incoming request - can not set routing directive");
    }

    @Override
    public B2buaHelper getB2buaHelper() throws IllegalStateException {
        return this.getB2buaHelper(true, UAMode.UAS);
    }

    @Override
    protected boolean shouldCreateContactIfNotExist() {
        return false;
    }

    @Override
    public void processCompositionErrorResponse() {
        SipRouter.sendErrorResponse(this, 500);
    }

    @Override
    public String getAppInvokedName() {
        return null;
    }

    @Override
    public void setAppInvokedName(String appInvokedName) {
    }

    @Override
    public boolean isAppInvoked116Type() {
        return false;
    }

    @Override
    public String getLocalAddr() {
        if (this._isInternallyGenerated) {
            return null;
        }
        return this.getLocalAddrInt();
    }

    @Override
    public int getLocalPort() {
        if (this._isInternallyGenerated) {
            return -1;
        }
        return this.getLocalPortInt();
    }

    @Override
    public String getRemoteAddr() {
        if (this._isInternallyGenerated) {
            return null;
        }
        return this.getRemoteAddrInt();
    }

    @Override
    public int getRemotePort() {
        if (this._isInternallyGenerated) {
            return -1;
        }
        return this.getRemotePortInt();
    }

    @Override
    public String getInitialRemoteAddr() {
        return this.getInitialRemoteAddrInt();
    }

    @Override
    public int getInitialRemotePort() {
        return this.getInitialRemotePortInt();
    }

    @Override
    public String getInitialTransport() {
        return this.getInitialTransportInt();
    }

    @Override
    public void cleanExpiredCompositionHeaders() {
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public AsyncContext startAsync() {
        return null;
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) {
        return null;
    }
}

