/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.pmi.taskduration;

import com.ibm.ws.sip.container.pmi.ApplicationTaskDurationModuleInterface;
import com.ibm.ws.sip.container.pmi.taskduration.TaskDurationCounter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationTaskDurationModule
implements ApplicationTaskDurationModuleInterface {
    private static final Logger s_logger = Logger.getLogger(ApplicationTaskDurationModule.class.getName());
    private TaskDurationCounter _applicationCodeTaskDurationCounter = new TaskDurationCounter();
    private long _avgTaskDurationInApplicationCode = 0L;
    private long _maxTaskDurationInApplicationCode = 0L;
    private long _minTaskDurationInApplicationCode = 0L;

    public ApplicationTaskDurationModule(String appFullName) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public synchronized void updateTaskDurationInApplication(long ms) {
        this._applicationCodeTaskDurationCounter.updateTaskDurationStatistics(ms);
        if (s_logger.isLoggable(Level.FINEST)) {
            StringBuilder buf = new StringBuilder();
            buf.append("New task duration in application code = " + ms);
            s_logger.logp(Level.FINEST, ApplicationTaskDurationModule.class.getName(), "updateTaskDurationInApplication", buf.toString());
        }
    }

    @Override
    public synchronized void updatePMICounters() {
        this._avgTaskDurationInApplicationCode = this._applicationCodeTaskDurationCounter.getAvgTaskDurationOut();
        this._maxTaskDurationInApplicationCode = this._applicationCodeTaskDurationCounter.getMaxTaskDurationOut();
        this._minTaskDurationInApplicationCode = this._applicationCodeTaskDurationCounter.getMinTaskDurationOut();
        this._applicationCodeTaskDurationCounter.init();
    }

    @Override
    public boolean isApplicationDurationPMIEnabled() {
        return true;
    }

    @Override
    public long getAvgTaskDurationInApplication() {
        return this._avgTaskDurationInApplicationCode;
    }

    @Override
    public long getMaxTaskDurationInApplication() {
        return this._maxTaskDurationInApplicationCode;
    }

    @Override
    public long getMinTaskDurationInApplication() {
        return this._minTaskDurationInApplicationCode;
    }
}

